/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.hylafax;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.inet.ftp.ServerResponseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import yajhfc.Utils;
import yajhfc.file.FileFormat;
import yajhfc.model.JobFormat;
import yajhfc.model.servconn.FaxDocument;
import yajhfc.model.servconn.HylafaxWorker;
import yajhfc.model.servconn.JobState;
import yajhfc.model.servconn.hylafax.AbstractHylaFaxJob;
import yajhfc.model.servconn.hylafax.AbstractHylaFaxJobList;
import yajhfc.model.servconn.hylafax.HylaServerDoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentFaxJob
extends AbstractHylaFaxJob<JobFormat> {
    private static final long serialVersionUID = 1L;
    static final Logger log = Logger.getLogger(SentFaxJob.class.getName());
    protected static final Pattern lineSplitter = Pattern.compile("\\s");

    protected SentFaxJob(AbstractHylaFaxJobList<JobFormat> abstractHylaFaxJobList, String[] stringArray) {
        super(abstractHylaFaxJobList, stringArray);
    }

    @Override
    protected JobState calculateJobState() {
        String string = this.getRawData(JobFormat.a);
        if (string == null || string.length() < 1) {
            return JobState.UNDEFINED;
        }
        return JobState.getJobStateFromCharCode(Character.toUpperCase(string.charAt(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getJobProperties(String ... stringArray) {
        if (Utils.debugMode) {
            log.finer("Retrieving properties for job " + this.getIDValue() + ": " + Arrays.toString(stringArray));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            HylaFAXClient hylaFAXClient = this.getConnection().beginServerTransaction();
            try {
                HylaFAXClient hylaFAXClient2 = hylaFAXClient;
                synchronized (hylaFAXClient2) {
                    Job job = this.getJob(hylaFAXClient);
                    for (String string : stringArray) {
                        try {
                            hashMap.put(string, job.getProperty(string));
                        }
                        catch (Exception exception) {
                            log.log(Level.INFO, "Error retrieving property " + string, exception);
                        }
                    }
                }
            }
            finally {
                this.getConnection().endServerTransaction();
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error retrieving the job properties", exception);
        }
        if (Utils.debugMode) {
            log.finer("Retrieved properties for job " + this.getIDValue() + ": " + hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<FaxDocument> calcDocuments() {
        ArrayList<FaxDocument> arrayList = new ArrayList<FaxDocument>();
        this.inaccessibleDocuments = new ArrayList();
        try {
            HylaFAXClient hylaFAXClient = this.getConnection().beginServerTransaction();
            try {
                String[] stringArray;
                HylaFAXClient hylaFAXClient2 = hylaFAXClient;
                synchronized (hylaFAXClient2) {
                    stringArray = Utils.fastSplit(this.getJob(hylaFAXClient).getDocumentName(), '\n');
                }
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    String[] stringArray2 = lineSplitter.split(stringArray[i]);
                    String string = stringArray2[1];
                    String string2 = stringArray2[0];
                    if (Utils.debugMode) {
                        log.info("Trying to access file " + string + "; type: " + string2);
                    }
                    try {
                        hylaFAXClient.stat(string);
                        FileFormat fileFormat = Utils.getFaxOptions().pclBug && string2.equalsIgnoreCase("pcl") ? FileFormat.Unknown : (string2.equalsIgnoreCase("tif") || string2.equalsIgnoreCase("tiff") ? FileFormat.TIFF : (string2.equalsIgnoreCase("ps") ? FileFormat.PostScript : (string2.equalsIgnoreCase("pdf") ? FileFormat.PDF : FileFormat.Unknown)));
                        arrayList.add(new HylaServerDoc<JobFormat>(this, string, fileFormat));
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (Utils.debugMode) {
                            log.log(Level.FINER, "Could not access " + stringArray[i], fileNotFoundException);
                        }
                        if (this.inaccessibleDocuments == null) continue;
                        this.inaccessibleDocuments.add(string + ": \"" + fileNotFoundException.getMessage() + '\"');
                    }
                }
            }
            finally {
                this.getConnection().endServerTransaction();
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error retrieving the associated documents", exception);
        }
        return arrayList;
    }

    @Override
    public FaxDocument getCommunicationsLog() throws IOException {
        String string = (String)this.getData(JobFormat.W);
        if (Utils.debugMode) {
            log.finer("CommID for job " + this.getIDValue() + " is: " + string);
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return new HylaServerDoc<JobFormat>(this, "log/c" + string, FileFormat.PlainText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteImpl(HylaFAXClient hylaFAXClient) throws IOException, ServerResponseException {
        HylaFAXClient hylaFAXClient2 = hylaFAXClient;
        synchronized (hylaFAXClient2) {
            hylaFAXClient.delete(this.getJob(hylaFAXClient));
        }
    }

    public Job getJob(HylaFAXClient hylaFAXClient) throws ServerResponseException, IOException {
        Object object = this.getData(JobFormat.j);
        if (object == null) {
            throw new IOException("Cannot get job ID for fax job");
        }
        return hylaFAXClient.getJob(((Integer)object).intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doHylafaxWork(HylafaxWorker hylafaxWorker) throws IOException, ServerResponseException {
        HylaFAXClient hylaFAXClient = this.getConnection().beginServerTransaction();
        try {
            if (Utils.debugMode) {
                log.fine("doHylafaxWork on " + this.getIDValue() + ": worker=" + hylafaxWorker);
            }
            Object object = hylafaxWorker.work(hylaFAXClient, this.getJob(hylaFAXClient));
            return object;
        }
        finally {
            this.getConnection().endServerTransaction();
        }
    }

    @Override
    public Object getIDValue() {
        return this.getData(JobFormat.j);
    }
}

