/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.servconn.srfax;

import com.google.gson.JsonObject;
import gnu.hylafax.HylaFAXClient;
import java.io.IOException;
import java.util.TimerTask;
import yajhfc.HylaClientManager;
import yajhfc.Utils;
import yajhfc.model.JobFormat;
import yajhfc.model.RecvFormat;
import yajhfc.model.TableType;
import yajhfc.model.servconn.ConnectionState;
import yajhfc.model.servconn.FaxListConnectionListener;
import yajhfc.model.servconn.hylafax.HylaFaxListConnection;
import yajhfc.model.servconn.hylafax.ManagedFaxJobList;
import yajhfc.model.servconn.srfax.SRFaxJobList;
import yajhfc.server.ServerOptions;
import yajhfc.ui.YajOptionPane;
import yajhfc.util.SRFaxAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRFaxListConnection
extends HylaFaxListConnection {
    public SRFaxListConnection(ServerOptions serverOptions, YajOptionPane yajOptionPane) {
        super(serverOptions, yajOptionPane);
    }

    @Override
    public boolean connect(boolean bl) {
        this.setStatusText(Utils._("Connecting..."));
        try {
            JsonObject jsonObject = SRFaxAPI.sendPost("Get_Fax_Usage", this.fo.user, this.fo.pass.getPassword());
            if (jsonObject.get("Status").getAsString().compareTo("Success") != 0) {
                this.dialogUI.showMessageDialog(jsonObject.get("Result").getAsString(), Utils._("Test connection"), 1);
            }
        }
        catch (Exception exception) {
            this.dialogUI.showExceptionDialog(exception.getClass().getSimpleName(), exception);
            this.setConnectionState(ConnectionState.DISCONNECTED);
            return false;
        }
        this.setConnectionState(ConnectionState.CONNECTED);
        this.setStatusText(Utils._("Connected") + " " + this.fo.SRFaxNumber);
        this.jobRefresher = this.createJobListRefresher();
        this.refreshTimer.schedule(this.jobRefresher, 0L, 60000L);
        return true;
    }

    @Override
    protected TimerTask createJobListRefresher() {
        return new SRFaxJobListRefresher();
    }

    @Override
    protected ManagedFaxJobList<RecvFormat> createRecvdList() {
        return new SRFaxJobList<RecvFormat>(this.fo.getParent().recvfmt, this, TableType.RECEIVED);
    }

    @Override
    public ManagedFaxJobList<JobFormat> createSendingList() {
        return new SRFaxJobList<JobFormat>(this.fo.getParent().sendingfmt, this, TableType.SENDING);
    }

    @Override
    public ManagedFaxJobList<JobFormat> createSentList() {
        return new SRFaxJobList<JobFormat>(this.fo.getParent().sentfmt, this, TableType.SENT);
    }

    @Override
    public HylaClientManager getClientManager() {
        return null;
    }

    @Override
    public HylaFAXClient beginServerTransaction() throws IOException {
        return null;
    }

    @Override
    public void endServerTransaction() {
    }

    @Override
    public void beginMultiOperation() throws IOException {
        this.beginServerTransaction();
    }

    @Override
    public void endMultiOperation() {
        this.endServerTransaction();
    }

    @Override
    public void refreshFaxLists() {
        if (this.receivedJobs != null) {
            try {
                this.receivedJobs.pollForNewJobs(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.sentJobs != null) {
            try {
                this.sentJobs.pollForNewJobs(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.sendingJobs != null) {
            try {
                this.sendingJobs.pollForNewJobs(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.fireRefreshComplete(FaxListConnectionListener.RefreshKind.FAXLISTS, true);
    }

    @Override
    public void setOptions(ServerOptions serverOptions) {
        super.setOptions(serverOptions);
    }

    @Override
    protected void saveToCache() {
    }

    @Override
    protected void loadFromCache() {
    }

    class SRFaxJobListRefresher
    extends TimerTask {
        SRFaxJobListRefresher() {
        }

        public synchronized void run() {
            SRFaxListConnection.this.refreshFaxLists();
        }

        public boolean cancel() {
            return super.cancel();
        }
    }
}

