/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.table;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.VirtualColumnType;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.servconn.FaxJobList;
import yajhfc.model.servconn.FaxJobListListener;
import yajhfc.model.table.FaxListTableModel;
import yajhfc.model.table.UnreadItemEvent;
import yajhfc.model.table.UnreadItemListener;
import yajhfc.virtualcolumnstore.VirtColPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadStateFaxListTableModel<T extends FmtItem>
extends FaxListTableModel<T> {
    protected Font readFont = null;
    protected Font unreadFont = null;
    protected EventListenerList listenerList = new EventListenerList();
    private FaxJobListListener<T> jobsListener;

    public Font getReadFont() {
        return this.readFont;
    }

    public void setReadFont(Font font) {
        this.readFont = font;
    }

    public Font getUnreadFont() {
        return this.unreadFont;
    }

    public void setUnreadFont(Font font) {
        this.unreadFont = font;
    }

    public ReadStateFaxListTableModel(FaxJobList<T> faxJobList) {
        super(faxJobList);
    }

    public void addUnreadItemListener(UnreadItemListener<T> unreadItemListener) {
        this.listenerList.add(UnreadItemListener.class, unreadItemListener);
    }

    public void removeUnreadItemListener(UnreadItemListener<T> unreadItemListener) {
        this.listenerList.remove(UnreadItemListener.class, unreadItemListener);
    }

    public int getNumberOfUnreadFaxes() {
        if (this.visibleJobs == null) {
            return 0;
        }
        int n = 0;
        for (FaxJob faxJob : this.visibleJobs) {
            if (faxJob.isRead()) continue;
            ++n;
        }
        return n;
    }

    protected void fireNewUnreadItemsAvailable(Collection<FaxJob<T>> collection, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        UnreadItemEvent<T> unreadItemEvent = new UnreadItemEvent<T>(this, collection, bl);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UnreadItemListener.class) continue;
            ((UnreadItemListener)objectArray[i + 1]).newItemsAvailable(unreadItemEvent);
        }
    }

    protected void fireReadStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UnreadItemListener.class) continue;
            ((UnreadItemListener)objectArray[i + 1]).readStateChanged();
        }
    }

    @Override
    public void setJobs(FaxJobList<T> faxJobList) {
        if (faxJobList != this.jobs) {
            if (this.jobs != null) {
                this.jobs.removeFaxJobListListener(this.getJobsListener());
            }
            super.setJobs(faxJobList);
            if (faxJobList != null) {
                faxJobList.addFaxJobListListener(this.getJobsListener());
            }
        }
    }

    private FaxJobListListener<T> getJobsListener() {
        if (this.jobsListener == null) {
            this.jobsListener = new FaxJobListListener<T>(){

                @Override
                public void faxJobsUpdated(FaxJobList<T> faxJobList, final List<FaxJob<T>> list, List<FaxJob<T>> list2) {
                    if (ReadStateFaxListTableModel.this.persistence == null) {
                        return;
                    }
                    Map map = FaxListTableModel.buildIDMap(list);
                    final ArrayList arrayList = new ArrayList();
                    for (FaxJob faxJob : list2) {
                        String string = VirtColPersister.getKeyForFaxJob(faxJob);
                        Object object = ReadStateFaxListTableModel.this.persistence.getValue(string, VirtualColumnType.READ);
                        boolean bl = object != null && (Boolean)object != false;
                        FaxJob faxJob2 = map.get(string);
                        if (faxJob2 == null) {
                            if (this.jobIsInProgress(faxJob) || bl) continue;
                            arrayList.add(faxJob);
                            continue;
                        }
                        if (!this.jobIsInProgress(faxJob2) || this.jobIsInProgress(faxJob) || bl) continue;
                        arrayList.add(faxJob);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (arrayList.size() > 0) {
                                ReadStateFaxListTableModel.this.fireNewUnreadItemsAvailable(arrayList, list.size() == 0);
                            }
                            ReadStateFaxListTableModel.this.fireReadStateChanged();
                        }
                    });
                }

                private boolean jobIsInProgress(FaxJob<T> faxJob) {
                    switch (faxJob.getJobState()) {
                        case DONE: 
                        case FAILED: {
                            return false;
                        }
                    }
                    return true;
                }

                @Override
                public void readStateChanged(FaxJobList<T> faxJobList, FaxJob<T> faxJob, boolean bl, boolean bl2) {
                    final int n = Utils.identityIndexOf(ReadStateFaxListTableModel.this.jobs.getJobs(), faxJob);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ReadStateFaxListTableModel.this.fireTableRowsUpdated(n, n);
                            ReadStateFaxListTableModel.this.fireReadStateChanged();
                        }
                    });
                }

                @Override
                public void columnChanged(FaxJobList<T> faxJobList, FaxJob<T> faxJob, T t, int n, Object object, Object object2) {
                }
            };
        }
        return this.jobsListener;
    }

    @Override
    public Font getCellFont(int n, int n2) {
        if (this.getJob(n).isRead()) {
            return this.readFont;
        }
        return this.unreadFont;
    }
}

