/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.model.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import yajhfc.Utils;
import yajhfc.model.FmtItem;
import yajhfc.model.servconn.FaxJob;
import yajhfc.model.table.FaxListTableModel;
import yajhfc.util.TableSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooltipJTable<T extends FmtItem>
extends JTable {
    private static final Logger log = Logger.getLogger(TooltipJTable.class.getName());

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.columnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return ((FmtItem)TooltipJTable.this.getRealModel().getColumns().get(n2)).getLongDescription();
            }
        };
    }

    public FaxListTableModel<T> getRealModel() {
        return (FaxListTableModel)((TableSorter)this.dataModel).getTableModel();
    }

    public TableSorter getSorter() {
        return (TableSorter)this.dataModel;
    }

    public TooltipJTable(FaxListTableModel<T> faxListTableModel) {
        super(new TableSorter(faxListTableModel));
        this.getSorter().setTableHeader(this.getTableHeader());
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 4);
    }

    public String getColumnCfgString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < this.getColumnCount() && (n = (i + 1) * this.getSorter().getSortingStatus(i)) == 0; ++i) {
        }
        stringBuilder.append(n).append('|');
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            stringBuilder.append(tableColumn.getIdentifier()).append(':').append(tableColumn.getWidth()).append('|');
        }
        return stringBuilder.toString();
    }

    public void setColumnCfgString(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = Utils.fastSplit(string, '|');
        if (stringArray.length < 1) {
            return;
        }
        try {
            n = Integer.parseInt(stringArray[0]);
            if (n != 0 && Math.abs(n) <= this.getColumnCount()) {
                this.getSorter().setSortingStatus(Math.abs(n) - 1, n > 0 ? 1 : -1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.log(Level.WARNING, "Couldn't parse value: " + stringArray[0]);
        }
        block4: for (n = 1; n < stringArray.length; ++n) {
            try {
                int n2 = stringArray[n].indexOf(58);
                if (n2 < 0) continue;
                String string2 = stringArray[n].substring(0, n2);
                int n3 = Integer.parseInt(stringArray[n].substring(n2 + 1));
                Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn = enumeration.nextElement();
                    if (!tableColumn.getIdentifier().equals(string2)) continue;
                    tableColumn.setPreferredWidth(n3);
                    continue block4;
                }
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.WARNING, "Couldn't parse value: " + stringArray[n]);
            }
        }
    }

    public FaxJob<T> getJobForRow(int n) {
        return this.getRealModel().getJob(this.getSorter().modelIndex(n));
    }

    public FaxJob<T>[] getSelectedJobs() {
        int[] nArray = this.getSelectedRows();
        FaxJob[] faxJobArray = new FaxJob[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            faxJobArray[i] = this.getJobForRow(nArray[i]);
        }
        return faxJobArray;
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.getColumnModel().getColumn(tableColumnModelEvent.getToIndex()).setIdentifier(((FmtItem)this.getRealModel().getColumns().get(tableColumnModelEvent.getToIndex())).name());
        super.columnAdded(tableColumnModelEvent);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        int n3 = this.getSorter().modelIndex(n);
        int n4 = this.getColumnModel().getColumn(n2).getModelIndex();
        FaxListTableModel<T> faxListTableModel = this.getRealModel();
        Font font = faxListTableModel.getCellFont(n3, n4);
        if (font != null) {
            component.setFont(font);
        }
        if (!this.isCellSelected(n, n2)) {
            Color color = faxListTableModel.getCellBackgroundColor(n3, n4);
            component.setBackground(color);
            color = faxListTableModel.getCellForegroundColor(n3, n4);
            component.setForeground(color);
        }
        return component;
    }
}

