/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import yajhfc.FaxOptions;
import yajhfc.IDAndNameOptions;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.IdentityPanel;
import yajhfc.options.MultiEditPanel;
import yajhfc.options.OptionsPageWrapper;
import yajhfc.options.OptionsWin;
import yajhfc.options.PanelTreeNode;
import yajhfc.phonebook.convrules.CompanyRule;
import yajhfc.phonebook.convrules.LocationRule;
import yajhfc.phonebook.convrules.NameRule;
import yajhfc.phonebook.convrules.ZIPCodeRule;
import yajhfc.util.ListComboModel;
import yajhfc.util.ListListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverPanel
extends AbstractOptionsPanel<FaxOptions> {
    JPanel panelCover;
    JComboBox comboNameRule;
    JComboBox comboCompanyRule;
    JComboBox comboLocationRule;
    JComboBox comboZIPCodeRule;
    MultiEditPanel<SenderIdentity> coverPanel;
    ListListModel<SenderIdentity> listModel = new ListComboModel(new ArrayList());

    public CoverPanel() {
        super(new BorderLayout(), false);
    }

    public ListListModel<SenderIdentity> getListModel() {
        return this.listModel;
    }

    @Override
    protected void createOptionsUI() {
        this.add((Component)this.getBottomPanel(), "West");
        this.add(this.getPanelCover(), "Center");
    }

    private MultiEditPanel<SenderIdentity> getPanelCover() {
        if (this.coverPanel == null) {
            this.coverPanel = new MultiEditPanel<SenderIdentity>(this.listModel){
                IdentityPanel idPanel;
                MessageFormat identityFormat;
                private boolean listSaved;
                {
                    this.idPanel = new IdentityPanel(CoverPanel.this);
                    this.identityFormat = new MessageFormat(Utils._("Identity {0}"));
                    this.listSaved = false;
                }

                @Override
                protected String getDeletePrompt(SenderIdentity senderIdentity) {
                    return MessageFormat.format(Utils._("Do you really want to remove the identity \"{0}\"?"), senderIdentity);
                }

                @Override
                protected String getDeletePrompt(int[] nArray) {
                    return MessageFormat.format(Utils._("Do you really want to remove the selected {0} identities?"), nArray.length);
                }

                @Override
                protected SenderIdentity duplicateItem(SenderIdentity senderIdentity) {
                    SenderIdentity senderIdentity2 = new SenderIdentity(senderIdentity);
                    senderIdentity2.generateNewID();
                    senderIdentity2.name = MessageFormat.format(Utils._("Copy of {0}"), senderIdentity2.name);
                    return senderIdentity2;
                }

                @Override
                protected SenderIdentity createNewItem() {
                    return new SenderIdentity(Utils.getFaxOptions());
                }

                @Override
                protected PanelTreeNode createChildNode(SenderIdentity senderIdentity) {
                    String string = senderIdentity.toString();
                    PanelTreeNode panelTreeNode = new PanelTreeNode(this.settingsNode, new OptionsPageWrapper<SenderIdentity>(this.idPanel, senderIdentity, this), string, Utils.loadIcon("general/ComposeMail"), this.identityFormat.format(new Object[]{string}));
                    return panelTreeNode;
                }

                @Override
                protected void updateChildNode(PanelTreeNode panelTreeNode, SenderIdentity senderIdentity) {
                    String string = senderIdentity.toString();
                    panelTreeNode.setLabel(string);
                    panelTreeNode.setLongLabel(this.identityFormat.format(new Object[]{string}));
                }

                @Override
                public void saveSettingsCalled(OptionsPageWrapper<SenderIdentity> optionsPageWrapper, FaxOptions faxOptions) {
                    if (this.listSaved) {
                        return;
                    }
                    ListListModel listListModel = this.itemsListModel;
                    faxOptions.identities.clear();
                    faxOptions.identities.addAll(listListModel.getList());
                    this.listSaved = true;
                }

                @Override
                public boolean validateSettingsCalled(OptionsPageWrapper<SenderIdentity> optionsPageWrapper, OptionsWin optionsWin) {
                    List list = this.itemsListModel.getList();
                    if (list.size() == 0) {
                        JOptionPane.showMessageDialog(optionsWin, "Need at least one identity!");
                        return false;
                    }
                    if (IDAndNameOptions.checkForDuplicates(list)) {
                        JOptionPane.showMessageDialog(optionsWin, "Duplicate IDs found, please cancel this dialog (should never happen)!");
                        return false;
                    }
                    return true;
                }
            };
            this.coverPanel.setBorder(BorderFactory.createTitledBorder(Utils._("Identities")));
        }
        return this.coverPanel;
    }

    private JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Utils._("General")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.comboNameRule = new JComboBox<NameRule>(NameRule.values());
        this.comboCompanyRule = new JComboBox<CompanyRule>(CompanyRule.values());
        this.comboLocationRule = new JComboBox<LocationRule>(LocationRule.values());
        this.comboZIPCodeRule = new JComboBox<ZIPCodeRule>(ZIPCodeRule.values());
        Dimension dimension = new Dimension(5, 5);
        jPanel.add(Box.createRigidArea(dimension));
        this.addComboToBox(jPanel, this.comboNameRule, Utils._("Name format:"));
        jPanel.add(Box.createRigidArea(dimension));
        this.addComboToBox(jPanel, this.comboCompanyRule, Utils._("Company format:"));
        jPanel.add(Box.createRigidArea(dimension));
        this.addComboToBox(jPanel, this.comboLocationRule, Utils._("Location format:"));
        jPanel.add(Box.createRigidArea(dimension));
        this.addComboToBox(jPanel, this.comboZIPCodeRule, Utils._("ZIP code format:"));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(Box.createRigidArea(dimension));
        return jPanel;
    }

    private void addComboToBox(JPanel jPanel, JComboBox jComboBox, String string) {
        Dimension dimension = jComboBox.getPreferredSize();
        dimension.width = Integer.MAX_VALUE;
        jComboBox.setMaximumSize(dimension);
        jComboBox.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentX(0.0f);
        jLabel.setLabelFor(jComboBox);
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        this.comboNameRule.setSelectedItem(faxOptions.coverNameRule);
        this.comboCompanyRule.setSelectedItem(faxOptions.coverCompanyRule);
        this.comboLocationRule.setSelectedItem((Object)faxOptions.coverLocationRule);
        this.comboZIPCodeRule.setSelectedItem(faxOptions.coverZIPCodeRule);
    }

    @Override
    public void initializeTreeNode(PanelTreeNode panelTreeNode, FaxOptions faxOptions) {
        this.getPanelCover().setSettingsNode(panelTreeNode);
        ListListModel<Object> listListModel = this.getPanelCover().itemsListModel;
        listListModel.clear();
        for (SenderIdentity senderIdentity : faxOptions.identities) {
            listListModel.add(new SenderIdentity(senderIdentity));
        }
        if (listListModel.getSize() == 0) {
            SenderIdentity senderIdentity = new SenderIdentity(faxOptions);
            senderIdentity.name = Utils._("Default");
            listListModel.add(senderIdentity);
        }
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        faxOptions.coverNameRule = (NameRule)this.comboNameRule.getSelectedItem();
        faxOptions.coverCompanyRule = (CompanyRule)this.comboCompanyRule.getSelectedItem();
        faxOptions.coverLocationRule = (LocationRule)((Object)this.comboLocationRule.getSelectedItem());
        faxOptions.coverZIPCodeRule = (ZIPCodeRule)this.comboZIPCodeRule.getSelectedItem();
        this.coverPanel.saveSettingsCalled(null, faxOptions);
    }
}

