/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import yajhfc.HylaClientManager;
import yajhfc.HylaModem;
import yajhfc.Utils;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.server.ServerOptions;
import yajhfc.ui.swing.SwingYajOptionPane;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.JTableTABAction;
import yajhfc.util.ProgressDialog;
import yajhfc.util.ProgressWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModemsPanel
extends AbstractOptionsPanel<ServerOptions> {
    ButtonGroup customOrAllGroup;
    Action actAdd;
    Action actRemove;
    Action actUp;
    Action actDown;
    Action actReset;
    JTable modemsTable;
    JRadioButton radAuto;
    JRadioButton radManual;
    HylaModemTableModel tableModel;
    ServerOptions myopts;

    public ModemsPanel() {
        super(false);
    }

    private void createActions() {
        this.actAdd = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                ModemsPanel.this.tableModel.addRow();
            }
        };
        this.actAdd.putValue("Name", Utils._("Add"));
        this.actAdd.putValue("SmallIcon", Utils.loadIcon("general/Add"));
        this.actRemove = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                int n = ModemsPanel.this.modemsTable.getSelectedRow();
                if (n >= 0) {
                    ModemsPanel.this.tableModel.deleteRow(n);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        this.actRemove.putValue("Name", Utils._("Remove"));
        this.actRemove.putValue("SmallIcon", Utils.loadIcon("general/Delete"));
        this.actRemove.setEnabled(false);
        this.actUp = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                int n = ModemsPanel.this.modemsTable.getSelectedRow();
                if (n >= 1) {
                    ModemsPanel.this.tableModel.moveUp(n);
                    ModemsPanel.this.modemsTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        this.actUp.putValue("Name", Utils._("Up"));
        this.actUp.putValue("SmallIcon", Utils.loadIcon("navigation/Up"));
        this.actUp.setEnabled(false);
        this.actDown = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                int n = ModemsPanel.this.modemsTable.getSelectedRow();
                if (n >= 0 && n < ModemsPanel.this.tableModel.getRowCount() - 1) {
                    ModemsPanel.this.tableModel.moveDown(n);
                    ModemsPanel.this.modemsTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        this.actDown.putValue("Name", Utils._("Down"));
        this.actDown.putValue("SmallIcon", Utils.loadIcon("navigation/Down"));
        this.actDown.setEnabled(false);
        this.actReset = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(ModemsPanel.this, Utils._("Reset the list of modems?"), Utils._("Reset"), 0) == 0) {
                    ModemsPanel.this.resetModemsList();
                }
            }
        };
        this.actReset.putValue("Name", Utils._("Reset"));
        this.actReset.putValue("SmallIcon", Utils.loadIcon("general/Refresh"));
    }

    @Override
    protected void createOptionsUI() {
        this.createActions();
        double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0, -2.0, 5.0}, new double[16]};
        for (int i = 0; i < 7; ++i) {
            dArrayArray[1][i * 2] = 5.0;
            dArrayArray[1][i * 2 + 1] = -2.0;
        }
        dArrayArray[1][14] = -1.0;
        dArrayArray[1][15] = 5.0;
        this.setLayout(new TableLayout(dArrayArray));
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ModemsPanel.this.enableCheck();
            }
        };
        this.radAuto = new JRadioButton(Utils._("Automatically get the list of modems"));
        this.radAuto.addItemListener(itemListener);
        this.radManual = new JRadioButton(Utils._("Use the following list of modems:"));
        this.radManual.addItemListener(itemListener);
        this.customOrAllGroup = new ButtonGroup();
        this.customOrAllGroup.add(this.radAuto);
        this.customOrAllGroup.add(this.radManual);
        this.tableModel = new HylaModemTableModel();
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(this.actAdd));
        jPopupMenu.add(new JMenuItem(this.actRemove));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(this.actUp));
        jPopupMenu.add(new JMenuItem(this.actDown));
        this.modemsTable = new JTable(this.tableModel);
        this.modemsTable.setShowGrid(true);
        this.modemsTable.setSelectionMode(0);
        this.modemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ModemsPanel.this.enableCheck();
                }
            }
        });
        this.modemsTable.getActionMap().put("yajhfc-delete", this.actRemove);
        InputMap inputMap = this.modemsTable.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "yajhfc-delete");
        JTableTABAction.wrapDefTabAction(this.modemsTable);
        this.modemsTable.setComponentPopupMenu(jPopupMenu);
        this.add((Component)this.radAuto, new TableLayoutConstraints(1, 1, 3, 1, 0, 1));
        this.add((Component)this.radManual, new TableLayoutConstraints(1, 3, 4, 3, 0, 1));
        this.add((Component)new JScrollPane(this.modemsTable), new TableLayoutConstraints(1, 5, 1, 14, 2, 2));
        this.add((Component)new JButton(this.actAdd), new TableLayoutConstraints(3, 5));
        this.add((Component)new JButton(this.actRemove), new TableLayoutConstraints(3, 7));
        this.add((Component)new JButton(this.actUp), new TableLayoutConstraints(3, 9));
        this.add((Component)new JButton(this.actDown), new TableLayoutConstraints(3, 11));
        this.add((Component)new JButton(this.actReset), new TableLayoutConstraints(3, 13));
    }

    void enableCheck() {
        boolean bl = this.modemsTable.getSelectedRow() >= 0;
        this.actUp.setEnabled(bl);
        this.actDown.setEnabled(bl);
        this.actRemove.setEnabled(bl);
    }

    @Override
    public void loadSettings(ServerOptions serverOptions) {
        this.myopts = serverOptions;
        this.tableModel.loadFromStringList(serverOptions.customModems);
        if (serverOptions.useCustomModems) {
            this.radManual.setSelected(true);
        } else {
            this.radAuto.setSelected(true);
            if (serverOptions.customModems.size() == 0) {
                this.resetModemsList();
            }
        }
        this.enableCheck();
    }

    @Override
    public void saveSettings(ServerOptions serverOptions) {
        serverOptions.useCustomModems = this.radManual.isSelected();
        this.tableModel.saveToStringList(serverOptions.customModems);
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        if (this.modemsTable.isEditing()) {
            this.modemsTable.getCellEditor().stopCellEditing();
        }
        return true;
    }

    void resetModemsList() {
        ModemRefreshWorker modemRefreshWorker = new ModemRefreshWorker((Dialog)SwingUtilities.getWindowAncestor(this), this.myopts, this.tableModel);
        modemRefreshWorker.startWork();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HylaModemTableModel
    extends AbstractTableModel {
        protected static final String[] columns = new String[]{Utils._("HylaFAX name"), Utils._("Number/Description"), Utils._("Full Description")};
        protected List<MutableHylaModem> modems = new ArrayList<MutableHylaModem>();

        HylaModemTableModel() {
        }

        @Override
        public int getColumnCount() {
            return columns.length;
        }

        @Override
        public String getColumnName(int n) {
            return columns[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.modems.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            MutableHylaModem mutableHylaModem = this.modems.get(n);
            switch (n2) {
                case 0: {
                    return mutableHylaModem.getInternalName();
                }
                case 1: {
                    return mutableHylaModem.getNumber();
                }
                case 2: {
                    return mutableHylaModem.getDescription();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            MutableHylaModem mutableHylaModem = this.modems.get(n);
            switch (n2) {
                case 0: {
                    mutableHylaModem.setInternalName(object.toString());
                    break;
                }
                case 1: {
                    mutableHylaModem.setNumber(object.toString());
                    break;
                }
                case 2: {
                    mutableHylaModem.setDescription(object.toString());
                    break;
                }
            }
            this.fireTableRowsUpdated(n, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void addRow() {
            this.addRow(new MutableHylaModem("", "", ""));
        }

        public void addRow(MutableHylaModem mutableHylaModem) {
            this.modems.add(mutableHylaModem);
            this.fireTableRowsInserted(this.modems.size() - 1, this.modems.size() - 1);
        }

        public HylaModem getRow(int n) {
            return this.modems.get(n);
        }

        public void clear() {
            this.modems.clear();
            this.fireTableDataChanged();
        }

        public void addAll(Collection<? extends HylaModem> collection) {
            for (HylaModem hylaModem : collection) {
                this.modems.add(new MutableHylaModem(hylaModem));
            }
            this.fireTableDataChanged();
        }

        public void deleteRow(int n) {
            this.modems.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void moveUp(int n) {
            if (n <= 0) {
                throw new ArrayIndexOutOfBoundsException("Cannot move up further");
            }
            MutableHylaModem mutableHylaModem = this.modems.get(n);
            this.modems.set(n, this.modems.get(n - 1));
            this.modems.set(n - 1, mutableHylaModem);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveDown(int n) {
            if (n >= this.modems.size() - 1) {
                throw new ArrayIndexOutOfBoundsException("Cannot move down further");
            }
            MutableHylaModem mutableHylaModem = this.modems.get(n);
            this.modems.set(n, this.modems.get(n + 1));
            this.modems.set(n + 1, mutableHylaModem);
            this.fireTableRowsUpdated(n, n + 1);
        }

        public void saveToStringList(List<String> list) {
            list.clear();
            for (MutableHylaModem mutableHylaModem : this.modems) {
                list.add(mutableHylaModem.saveToString());
            }
        }

        public void loadFromStringList(List<String> list) {
            this.modems.clear();
            for (String string : list) {
                this.modems.add(new MutableHylaModem(string));
            }
            this.fireTableDataChanged();
        }
    }

    static class MutableHylaModem
    extends HylaModem {
        public MutableHylaModem(HylaModem hylaModem) {
            this(hylaModem.getInternalName(), hylaModem.getNumber(), hylaModem.getDescription());
        }

        public MutableHylaModem(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        public MutableHylaModem(String string) {
            super(string);
        }

        public void setInternalName(String string) {
            this.checkUpdateDescription(string, this.number);
            this.internalName = string;
        }

        public void setNumber(String string) {
            this.checkUpdateDescription(this.internalName, string);
            this.number = string;
        }

        public void setDescription(String string) {
            this.description = string == null || string.length() == 0 ? MutableHylaModem.generateDescription(this.internalName, this.number) : string;
        }

        protected void checkUpdateDescription(String string, String string2) {
            if (this.description == null || this.description.length() == 0 || this.description.equals(MutableHylaModem.generateDescription(this.internalName, this.number))) {
                this.description = MutableHylaModem.generateDescription(string, string2);
            }
        }
    }

    protected static final class ModemRefreshWorker
    extends ProgressWorker
    implements ActionListener {
        private final Dialog ow;
        private final ServerOptions tempFO;
        private HylaClientManager tempHCM;
        private volatile boolean cancelled = false;
        private List<HylaModem> modemList = null;
        private final HylaModemTableModel tableModel;

        protected ModemRefreshWorker(Dialog dialog, ServerOptions serverOptions, HylaModemTableModel hylaModemTableModel) {
            this.ow = dialog;
            this.tempFO = serverOptions;
            this.tableModel = hylaModemTableModel;
            this.setProgressMonitor(new ProgressDialog((Dialog)dialog, (String)Utils._((String)"Refreshing modem list"), (ActionListener)this).progressPanel);
        }

        public void startWork() {
            this.startWork(this.ow, Utils._("Refreshing modem list"));
        }

        public void doWork() {
            this.updateNote(Utils._("Logging in..."));
            this.tempHCM = new HylaClientManager(this.tempFO);
            if (!this.cancelled && this.tempHCM.forceLogin(new SwingYajOptionPane(this.ow)) != null) {
                if (!this.cancelled) {
                    this.updateNote(Utils._("Retrieving modem list..."));
                    this.modemList = this.tempHCM.getRealModems();
                }
                if (!this.cancelled) {
                    this.updateNote(Utils._("Login successful, logging out."));
                }
                this.tempHCM.forceLogout();
                if (!this.cancelled) {
                    this.progressMonitor.close();
                }
            }
        }

        protected void done() {
            if (!this.cancelled && this.modemList != null) {
                this.tableModel.clear();
                this.tableModel.addAll(HylaModem.defaultModems);
                this.tableModel.addAll(this.modemList);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cancelled = true;
            if (this.tempHCM != null) {
                this.tempHCM.setShowErrorsUsingGUI(false);
            }
            this.interrupt();
            this.getProgressMonitor().close();
        }
    }
}

