/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.options;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import yajhfc.FaxNotification;
import yajhfc.FaxResolution;
import yajhfc.HylaModem;
import yajhfc.IDAndNameOptions;
import yajhfc.PaperSize;
import yajhfc.SenderIdentity;
import yajhfc.Utils;
import yajhfc.model.IconMap;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.send.JobPropsEditorDialog;
import yajhfc.server.Server;
import yajhfc.server.ServerManager;
import yajhfc.server.ServerOptions;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ListComboModel;
import yajhfc.util.ListListModel;
import yajhfc.util.WrapperComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendPanel
extends AbstractOptionsPanel<ServerOptions> {
    static final Logger log = Logger.getLogger(SendPanel.class.getName());
    JTextField textFilterFromFaxNr;
    JTextField textNotifyAddress;
    JTextField textNumberPrefix;
    JCheckBox checkArchiveSentFaxes;
    JComboBox comboModem;
    JComboBox comboNotify;
    JComboBox comboPaperSize;
    JComboBox comboResolution;
    JSpinner spinKillTime;
    JSpinner spinMaxDial;
    JSpinner spinMaxTry;
    Action jobOptionAction;
    Map<String, String> customProperties;
    JComboBox comboIdentity;
    ListListModel<SenderIdentity> identitiesModel;
    ListComboModel<HylaModem> modemsModel;

    public SendPanel() {
        super(false);
    }

    public ListListModel<SenderIdentity> getIdentitiesModel() {
        return this.identitiesModel;
    }

    public void setIdentitiesModel(ListListModel<SenderIdentity> listListModel) {
        this.identitiesModel = listListModel;
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{5.0, 0.5, 5.0, -1.0, 5.0}, new double[22]};
        for (int i = 0; i < 21; ++i) {
            dArrayArray[1][i] = i % 3 == 0 ? 5.0 : -2.0;
        }
        dArrayArray[1][21] = -1.0;
        this.setLayout(new TableLayout(dArrayArray));
        this.setBorder(BorderFactory.createTitledBorder(Utils._("Delivery settings")));
        this.textNotifyAddress = new JTextField();
        this.textNotifyAddress.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textFilterFromFaxNr = new JTextField();
        this.textFilterFromFaxNr.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textFilterFromFaxNr.setToolTipText(Utils._("Characters filtered from the fax number sent to HylaFAX."));
        this.textNumberPrefix = new JTextField();
        this.textNumberPrefix.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textNumberPrefix.setToolTipText(Utils._("Characters put in front of the fax number before sending it to HylaFAX."));
        this.comboNotify = new JComboBox<FaxNotification>(FaxNotification.values());
        this.comboNotify.setRenderer(new IconMap.ListCellRenderer());
        this.comboPaperSize = new JComboBox<PaperSize>(PaperSize.values());
        this.comboResolution = new JComboBox<FaxResolution>(FaxResolution.values());
        this.modemsModel = new ListComboModel(Collections.emptyList());
        this.comboModem = new JComboBox<HylaModem>(this.modemsModel);
        this.comboModem.setEditable(true);
        this.spinMaxDial = new JSpinner(new SpinnerNumberModel(12, 1, 100, 1));
        this.spinMaxTry = new JSpinner(new SpinnerNumberModel(6, 1, 100, 1));
        this.spinKillTime = new JSpinner(new SpinnerNumberModel(180, 0, 142560, 15));
        this.checkArchiveSentFaxes = new JCheckBox(Utils._("Archive sent fax jobs"));
        this.jobOptionAction = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                JobPropsEditorDialog jobPropsEditorDialog = new JobPropsEditorDialog((Dialog)SwingUtilities.getWindowAncestor(SendPanel.this), SendPanel.this.customProperties);
                jobPropsEditorDialog.setVisible(true);
            }
        };
        this.jobOptionAction.putValue("Name", Utils._("Job properties") + "...");
        JButton jButton = new JButton(this.jobOptionAction);
        this.comboIdentity = new JComboBox(new WrapperComboBoxModel(this.getIdentitiesModel()));
        Utils.addWithLabel((JPanel)this, (Component)this.textNotifyAddress, Utils._("E-mail address for notifications:"), "1, 2, 3, 2, f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.comboNotify, Utils._("Notify when:"), "1, 5, 1, 5, f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.comboModem, Utils._("Modem:"), "3, 5, 3, 5, f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.comboPaperSize, Utils._("Paper size:"), "1, 8, f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.comboResolution, Utils._("Resolution:"), "3, 8, f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.spinMaxDial, Utils._("Maximum dials:"), "1, 11, f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.spinKillTime, Utils._("Cancel job after (minutes):"), "3,11,f, c");
        Utils.addWithLabel((JPanel)this, (Component)this.textFilterFromFaxNr, Utils._("Filter from fax number:"), "1,14,f,c");
        Utils.addWithLabel((JPanel)this, (Component)this.spinMaxTry, Utils._("Maximum tries:"), "3,14,f,c");
        Utils.addWithLabel((JPanel)this, (Component)this.textNumberPrefix, Utils._("Dial prefix:"), "1,17,1,17,f,c");
        Utils.addWithLabel((JPanel)this, (Component)this.comboIdentity, Utils._("Default identity:"), "3,17,3,17,f,c");
        this.add((Component)jButton, "1,20,f,c");
        this.add((Component)this.checkArchiveSentFaxes, "3,20,f,c");
    }

    private String getModem() {
        Object object = this.comboModem.getSelectedItem();
        if (Utils.debugMode) {
            log.info("Selected modem (" + object.getClass().getCanonicalName() + "): " + object);
        }
        if (object instanceof HylaModem) {
            return ((HylaModem)object).getInternalName();
        }
        String string = object.toString();
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadSettings(ServerOptions serverOptions) {
        void var6_9;
        this.textNotifyAddress.setText(serverOptions.notifyAddress);
        this.textFilterFromFaxNr.setText(serverOptions.filterFromFaxNr);
        this.textNumberPrefix.setText(serverOptions.numberPrefix);
        this.comboNotify.setSelectedItem(serverOptions.notifyWhen);
        this.comboPaperSize.setSelectedItem((Object)serverOptions.paperSize);
        this.comboResolution.setSelectedItem((Object)serverOptions.resolution);
        Server server = ServerManager.getDefault().getServerByID(serverOptions.id);
        List<HylaModem> list = server != null ? (server.getClientManager() != null ? server.getClientManager().getModems() : HylaModem.defaultModems) : HylaModem.defaultModems;
        this.modemsModel.setList(list);
        Object object2 = serverOptions.defaultModem;
        for (HylaModem object3 : list) {
            if (!object3.getInternalName().equals(object2)) continue;
            object2 = object3;
            break;
        }
        this.comboModem.setSelectedItem(object2);
        this.checkArchiveSentFaxes.setSelected(serverOptions.archiveSentFaxes);
        this.spinMaxDial.setValue(serverOptions.maxDial);
        this.spinMaxTry.setValue(serverOptions.maxTry);
        this.spinKillTime.setValue(serverOptions.killTime);
        this.customProperties = new TreeMap<String, String>(serverOptions.customJobOptions);
        List<SenderIdentity> list2 = this.getIdentitiesModel().getList();
        SenderIdentity senderIdentity = (SenderIdentity)IDAndNameOptions.getItemByID(list2, serverOptions.defaultIdentity);
        if (senderIdentity == null) {
            SenderIdentity senderIdentity2 = serverOptions.getParent().getDefaultIdentity();
        }
        this.comboIdentity.setSelectedItem(var6_9);
    }

    @Override
    public void saveSettings(ServerOptions serverOptions) {
        serverOptions.maxDial = (Integer)this.spinMaxDial.getValue();
        serverOptions.maxTry = (Integer)this.spinMaxTry.getValue();
        serverOptions.killTime = (Integer)this.spinKillTime.getValue();
        serverOptions.notifyAddress = this.textNotifyAddress.getText();
        serverOptions.filterFromFaxNr = this.textFilterFromFaxNr.getText();
        serverOptions.numberPrefix = this.textNumberPrefix.getText();
        serverOptions.notifyWhen = (FaxNotification)this.comboNotify.getSelectedItem();
        serverOptions.paperSize = (PaperSize)((Object)this.comboPaperSize.getSelectedItem());
        serverOptions.resolution = (FaxResolution)((Object)this.comboResolution.getSelectedItem());
        serverOptions.archiveSentFaxes = this.checkArchiveSentFaxes.isSelected();
        serverOptions.defaultModem = this.getModem();
        serverOptions.customJobOptions.clear();
        serverOptions.customJobOptions.putAll(this.customProperties);
        SenderIdentity senderIdentity = (SenderIdentity)this.comboIdentity.getSelectedItem();
        serverOptions.defaultIdentity = senderIdentity == null ? -1 : senderIdentity.id;
    }
}

