/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook;

import java.awt.Dialog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import yajhfc.Utils;
import yajhfc.filters.Filter;
import yajhfc.filters.FilterableObject;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookEntryList;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.PhonebookEvent;
import yajhfc.phonebook.PhonebookEventListener;
import yajhfc.phonebook.convrules.ChoiceRule;
import yajhfc.phonebook.convrules.ConcatRule;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.NameRule;
import yajhfc.phonebook.convrules.PBEntryFieldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhoneBook
implements PhoneBookEntryList {
    public static final EntryToStringRule DEFAULT_TOSTRINGRULE = PhoneBook.toStringRuleFromNameRule(NameRule.GIVENNAME_NAME);
    protected EntryToStringRule entryToStringRule = DEFAULT_TOSTRINGRULE;
    protected List<PhonebookEventListener> listeners = new ArrayList<PhonebookEventListener>();
    protected static final int CAPTION_LENGTH = 40;
    public final Dialog parentDialog;
    protected String strDescriptor;
    public Object treeModelData = null;

    public static EntryToStringRule toStringRuleFromNameRule(EntryToStringRule entryToStringRule) {
        return new ChoiceRule(entryToStringRule, new ConcatRule(PBEntryField.Department, ", ", PBEntryField.Company), new ConcatRule(Utils._("<no name>")));
    }

    public String getDescriptor() {
        return this.strDescriptor;
    }

    public String getPrefix() {
        try {
            Field field = this.getClass().getField("PB_Prefix");
            return (String)field.get(null);
        }
        catch (Exception exception) {
            return this.getClass().getCanonicalName();
        }
    }

    public String getDisplayName() {
        try {
            Field field = this.getClass().getField("PB_DisplayName");
            return (String)field.get(null);
        }
        catch (Exception exception) {
            return this.getClass().getName();
        }
    }

    public String getDescription() {
        try {
            Field field = this.getClass().getField("PB_Description");
            return (String)field.get(null);
        }
        catch (Exception exception) {
            return this.getClass().toString();
        }
    }

    public int findEntry(int n, boolean bl, Filter<PhoneBookEntry, PBEntryField> filter) {
        int n2;
        List<PhoneBookEntry> list = this.getEntries();
        filter.initFilter(PBEntryField.filterKeyList);
        int n3 = list.size();
        int n4 = n < 0 ? (bl ? n3 - 1 : 0) : n;
        int n5 = n2 = bl ? -1 : 1;
        while (n4 >= 0 && n4 < n3) {
            if (filter.matchesFilter((PhoneBookEntry)((FilterableObject)list.get(n4)))) {
                return n4;
            }
            n4 += n2;
        }
        return -1;
    }

    @Override
    public abstract PhoneBookEntry addNewEntry();

    public DistributionList addDistributionList() {
        throw new UnsupportedOperationException("No distribution lists supported.");
    }

    public DistributionList addDistributionList(String string, Collection<? extends PBEntryFieldContainer> collection) {
        DistributionList distributionList = this.addDistributionList();
        distributionList.addEntries(collection);
        distributionList.setField(PBEntryField.Name, string);
        return distributionList;
    }

    @Override
    public void addEntries(Collection<? extends PBEntryFieldContainer> collection) {
        for (PBEntryFieldContainer pBEntryFieldContainer : collection) {
            if (pBEntryFieldContainer instanceof DistributionList) {
                List<PhoneBookEntry> list = ((DistributionList)pBEntryFieldContainer).getEntries();
                if (this.supportsDistributionLists()) {
                    this.addDistributionList(pBEntryFieldContainer.getField(PBEntryField.Name), list);
                    continue;
                }
                this.addEntries(list);
                continue;
            }
            this.addNewEntry(pBEntryFieldContainer);
        }
    }

    @Override
    public PhoneBookEntry addNewEntry(PBEntryFieldContainer pBEntryFieldContainer) {
        PhoneBookEntry phoneBookEntry = this.addNewEntry();
        phoneBookEntry.copyFrom(pBEntryFieldContainer);
        phoneBookEntry.commit();
        return phoneBookEntry;
    }

    @Override
    public abstract List<PhoneBookEntry> getEntries();

    public List<PhoneBookEntry> applyFilter(Filter<PhoneBookEntry, PBEntryField> filter) {
        if (filter != null) {
            List<PhoneBookEntry> list = this.getEntries();
            ArrayList<PhoneBookEntry> arrayList = new ArrayList<PhoneBookEntry>(list.size());
            filter.initFilter(PBEntryField.filterKeyList);
            for (PhoneBookEntry phoneBookEntry : list) {
                if (!filter.matchesFilter(phoneBookEntry)) continue;
                arrayList.add(phoneBookEntry);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public void addPhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.listeners.add(phonebookEventListener);
    }

    @Override
    public void removePhonebookEventListener(PhonebookEventListener phonebookEventListener) {
        this.listeners.remove(phonebookEventListener);
    }

    protected void fireEntriesAdded(int n, PhoneBookEntry phoneBookEntry) {
        this.fireEntriesAdded(new PhonebookEvent(this, new PhoneBookEntry[]{phoneBookEntry}, new int[]{n}));
    }

    protected void fireEntriesChanged(int n, PhoneBookEntry phoneBookEntry) {
        this.fireEntriesChanged(new PhonebookEvent(this, new PhoneBookEntry[]{phoneBookEntry}, new int[]{n}));
    }

    protected PhonebookEvent eventObjectForInterval(int n, int n2) {
        return PhonebookEvent.createForInterval(this, n, n2);
    }

    protected void fireEntriesRemoved(int n, PhoneBookEntry phoneBookEntry) {
        this.fireEntriesRemoved(new PhonebookEvent(this, new PhoneBookEntry[]{phoneBookEntry}, new int[]{n}));
    }

    protected void fireEntriesAdded(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.elementsAdded(phonebookEvent);
        }
    }

    protected void fireEntriesChanged(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.elementsChanged(phonebookEvent);
        }
    }

    protected void fireEntriesRemoved(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.elementsRemoved(phonebookEvent);
        }
    }

    protected void firePhonebookReloaded() {
        this.firePhonebookReloaded(new PhonebookEvent(this, null, null));
    }

    protected void firePhonebookReloaded(PhonebookEvent phonebookEvent) {
        for (PhonebookEventListener phonebookEventListener : this.listeners) {
            phonebookEventListener.phonebookReloaded(phonebookEvent);
        }
    }

    public abstract String browseForPhoneBook(boolean var1);

    public void open(String string) throws PhoneBookException {
        int n = string.indexOf(58);
        if (n >= 0) {
            this.strDescriptor = string;
            this.openInternal(string.substring(n + 1));
        } else {
            this.strDescriptor = this.getPrefix() + ":" + string;
            this.openInternal(string);
        }
    }

    public abstract boolean isOpen();

    protected abstract void openInternal(String var1) throws PhoneBookException;

    public abstract void close();

    public boolean isFieldAvailable(PBEntryField pBEntryField) {
        return true;
    }

    public int getMaxLength(PBEntryField pBEntryField) {
        return 0;
    }

    public String getDisplayCaption() {
        return this.getDescriptor().substring(0, 40);
    }

    public String toString() {
        return this.getDisplayCaption();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean supportsDistributionLists() {
        return false;
    }

    public EntryToStringRule getEntryToStringRule() {
        return this.entryToStringRule;
    }

    public void setEntryToStringRule(EntryToStringRule entryToStringRule) {
        if (entryToStringRule != this.entryToStringRule) {
            this.entryToStringRule = entryToStringRule;
            for (PhoneBookEntry phoneBookEntry : this.getEntries()) {
                phoneBookEntry.refreshToStringRule();
            }
        }
    }

    public PhoneBook(Dialog dialog) {
        this.parentDialog = dialog;
    }
}

