/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.convrules;

import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.RuleParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSerializer {
    private static final Logger log = Logger.getLogger(RuleSerializer.class.getName());

    public static <T extends Enum<T>> EntryToStringRule stringToRule(String string, Class<T> clazz, EntryToStringRule entryToStringRule) {
        EntryToStringRule entryToStringRule2;
        if (string == null || string.length() == 0) {
            return entryToStringRule;
        }
        switch (string.charAt(0)) {
            case '$': {
                entryToStringRule2 = (EntryToStringRule)Enum.valueOf(clazz, string.substring(1));
                break;
            }
            case '%': {
                try {
                    entryToStringRule2 = RuleParser.parseRule(string.substring(1), false);
                }
                catch (RuleParser.RuleParseException ruleParseException) {
                    log.log(Level.WARNING, "Could not parse rule", ruleParseException);
                    entryToStringRule2 = null;
                }
                break;
            }
            default: {
                entryToStringRule2 = (EntryToStringRule)Enum.valueOf(clazz, string);
            }
        }
        if (entryToStringRule2 == null) {
            log.warning("Unknown rule, returning default: " + string);
            return entryToStringRule;
        }
        return entryToStringRule2;
    }

    public static <T extends Enum<T>> String ruleToString(EntryToStringRule entryToStringRule, Class<T> clazz) {
        if (clazz.isAssignableFrom(entryToStringRule.getClass())) {
            return "$" + ((Enum)((Object)entryToStringRule)).name();
        }
        return "%" + RuleParser.ruleToString(entryToStringRule, false);
    }
}

