/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.csv;

import au.com.bytecode.opencsv.CSVReader;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.csv.CSVSettings;
import yajhfc.phonebook.jdbc.ConnectionSettings;
import yajhfc.util.CancelAction;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExceptionDialog;

public class CSVDialog
extends JDialog {
    private static final int border = 8;
    protected CSVSettings settings;
    protected JComboBox comboCharset;
    protected JComboBox comboSeparator;
    protected JComboBox comboQuote;
    protected JCheckBox checkFirstLineHeader;
    protected JTable tablePreview;
    protected Map<PBEntryField, JComboBox> mappingEntryFields;
    protected DefaultTableModel previewModel;
    protected JTextField textDisplayCaption;
    protected boolean doPreview;
    public boolean clickedOK = false;
    protected boolean eventLock = false;

    public CSVDialog(Frame frame, CSVSettings cSVSettings, String string) {
        super(frame, string, true);
        this.settings = cSVSettings;
        this.initialize();
    }

    public CSVDialog(Dialog dialog, CSVSettings cSVSettings) {
        super(dialog, MessageFormat.format(Utils._("Open CSV file {0}"), Utils.shortenFileNameForDisplay(cSVSettings.fileName, 30)), true);
        this.settings = cSVSettings;
        this.initialize();
    }

    private void initialize() {
        double[][] dArrayArray = new double[][]{{8.0, 0.5, 8.0, -1.0, 8.0}, {8.0, -2.0, -2.0, 8.0, -2.0, -2.0, 8.0, -2.0, -2.0, 8.0, -1.0, -2.0, 8.0}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        Vector<Charset> vector = new Vector<Charset>(Charset.availableCharsets().values());
        Collections.sort(vector);
        this.comboCharset = new JComboBox<Charset>(vector);
        String[] stringArray = new String[]{";", ",", "TAB"};
        this.comboSeparator = new JComboBox<String>(stringArray);
        this.comboSeparator.setEditable(true);
        String[] stringArray2 = new String[]{"\"", "'"};
        this.comboQuote = new JComboBox<String>(stringArray2);
        this.checkFirstLineHeader = new JCheckBox(Utils._("First line contains headers"));
        Utils.addWithLabel(jPanel, (Component)this.comboCharset, Utils._("Charset:"), "1,2");
        Utils.addWithLabel(jPanel, (Component)this.comboSeparator, Utils._("Separator:"), "3,2");
        Utils.addWithLabel(jPanel, (Component)this.comboQuote, Utils._("Quote character:"), "1,5");
        jPanel.add((Component)this.checkFirstLineHeader, "3,5");
        if (!this.settings.overwrite) {
            this.textDisplayCaption = new JTextField();
            this.textDisplayCaption.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
            Utils.addWithLabel(jPanel, (Component)this.textDisplayCaption, Utils._("Phone book name to display:"), "1,8,3,8");
        }
        boolean bl = this.doPreview = !this.settings.overwrite && new File(this.settings.fileName).exists();
        if (this.doPreview) {
            jPanel.add((Component)this.getMappingEntries(), "1,10,3,10,f,f");
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 8, 8));
        JButton jButton = new JButton(Utils._("OK"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CSVDialog.this.saveToSettings(CSVDialog.this.settings);
                CSVDialog.this.clickedOK = true;
                CSVDialog.this.dispose();
            }
        });
        CancelAction cancelAction = new CancelAction(this);
        jPanel2.add(jButton);
        jPanel2.add(cancelAction.createCancelButton());
        jPanel.add((Component)jPanel2, "0,11,4,11");
        this.setContentPane(jPanel);
        this.loadFromSettings(this.settings);
        this.pack();
    }

    void loadFromSettings(CSVSettings cSVSettings) {
        this.eventLock = true;
        this.comboCharset.setSelectedItem(Charset.forName(cSVSettings.charset));
        this.comboSeparator.setSelectedItem(this.separatorToUserDisplay(cSVSettings.separator));
        this.comboQuote.setSelectedItem(cSVSettings.quoteChar);
        this.checkFirstLineHeader.setSelected(cSVSettings.firstLineAreHeaders);
        if (this.textDisplayCaption != null) {
            this.textDisplayCaption.setText(cSVSettings.displayCaption);
        }
        if (this.doPreview) {
            this.refreshPreview();
            for (PBEntryField pBEntryField : PBEntryField.values()) {
                String string = cSVSettings.getMappingFor(pBEntryField);
                int n = ConnectionSettings.isNoField(string) ? 0 : Integer.parseInt(string) + 1;
                this.mappingEntryFields.get(pBEntryField).setSelectedIndex(n);
            }
        }
        this.eventLock = false;
    }

    void saveToSettings(CSVSettings cSVSettings) {
        cSVSettings.charset = ((Charset)this.comboCharset.getSelectedItem()).name();
        cSVSettings.separator = this.userDisplayToSeparator((String)this.comboSeparator.getSelectedItem());
        cSVSettings.quoteChar = (String)this.comboQuote.getSelectedItem();
        cSVSettings.firstLineAreHeaders = this.checkFirstLineHeader.isSelected();
        if (this.textDisplayCaption != null) {
            cSVSettings.displayCaption = this.textDisplayCaption.getText();
        }
        if (this.doPreview) {
            PBEntryField[] pBEntryFieldArray = PBEntryField.values();
            int n = pBEntryFieldArray.length;
            for (int i = 0; i < n; ++i) {
                PBEntryField pBEntryField;
                int n2 = this.mappingEntryFields.get(pBEntryField = pBEntryFieldArray[i]).getSelectedIndex();
                cSVSettings.setMappingFor(pBEntryField, n2 == 0 ? "<none>" : String.valueOf(n2 - 1));
            }
        } else {
            PBEntryField[] pBEntryFieldArray = PBEntryField.values();
            for (int i = 0; i < pBEntryFieldArray.length; ++i) {
                cSVSettings.setMappingFor(pBEntryFieldArray[i], String.valueOf(i));
            }
        }
    }

    private String separatorToUserDisplay(String string) {
        if (string.equals("\t")) {
            return "TAB";
        }
        return string;
    }

    private String userDisplayToSeparator(String string) {
        if (string.equals("TAB")) {
            return "\t";
        }
        if (string.length() > 1) {
            return string.substring(0, 1);
        }
        if (string.length() == 0) {
            return ";";
        }
        return string;
    }

    void refreshPreview() {
        try {
            int n;
            Vector<String> vector;
            String[] stringArray;
            CSVReader cSVReader = this.settings.createReader();
            String[] stringArray2 = null;
            if (this.settings.firstLineAreHeaders) {
                stringArray2 = cSVReader.readNext();
            }
            Vector vector2 = new Vector(20);
            int n2 = 0;
            while ((stringArray = cSVReader.readNext()) != null && n2++ < 20) {
                vector = new Vector(stringArray.length);
                String[] stringArray3 = stringArray;
                int n3 = stringArray3.length;
                for (n = 0; n < n3; ++n) {
                    String string = stringArray3[n];
                    vector.add(string);
                }
                vector2.add(vector);
            }
            vector = new Vector<String>();
            if (stringArray2 == null) {
                int n4 = vector2.size() > 0 ? ((Vector)vector2.get(0)).size() : 0;
                MessageFormat messageFormat = new MessageFormat(Utils._("Column {0}"));
                for (n = 0; n < n4; ++n) {
                    vector.add(messageFormat.format(new Object[]{n + 1}));
                }
            } else {
                for (String string : stringArray2) {
                    vector.add(string);
                }
            }
            this.previewModel.setDataVector(vector2, vector);
            Vector<String> vector3 = new Vector<String>(vector.size() + 1);
            vector3.add(ConnectionSettings.noField_translated);
            vector3.addAll(vector);
            for (PBEntryField pBEntryField : PBEntryField.values()) {
                JComboBox jComboBox = this.mappingEntryFields.get(pBEntryField);
                int n5 = jComboBox.getSelectedIndex();
                jComboBox.setModel(new DefaultComboBoxModel(vector3));
                if (n5 >= 0 && n5 < vector3.size()) {
                    jComboBox.setSelectedIndex(n5);
                    continue;
                }
                if (vector3.size() <= 0) continue;
                jComboBox.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this, Utils._("Error previewing your settings:"), exception);
        }
    }

    private JPanel getMappingEntries() {
        this.mappingEntryFields = new EnumMap<PBEntryField, JComboBox>(PBEntryField.class);
        int n = (PBEntryField.FIELD_COUNT + 2) / 3;
        double[] dArray = new double[n * 3 + 4];
        dArray[0] = -2.0;
        dArray[1] = -1.0;
        dArray[2] = 8.0;
        dArray[3] = -2.0;
        for (int i = 3; i < dArray.length; ++i) {
            dArray[i] = i % 3 == 1 ? 4.0 : -2.0;
        }
        double[][] dArrayArray = new double[][]{{0.33333, 4.0, 0.33333, 4.0, -1.0}, dArray};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        this.previewModel = new DefaultTableModel();
        this.tablePreview = new JTable(this.previewModel);
        this.tablePreview.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.tablePreview.setSelectionMode(0);
        this.tablePreview.setAutoResizeMode(0);
        Utils.addWithLabel(jPanel, (Component)new JScrollPane(this.tablePreview), Utils._("Preview") + ":", "0,1,4,1");
        jPanel.add((Component)new JLabel("<html>" + Utils._("Please select which columns in the CSV file represent the phone book fields:") + "</html>"), "0,3,4,3");
        PBEntryField[] pBEntryFieldArray = PBEntryField.values();
        int n2 = 0;
        int n3 = 6;
        for (int i = 0; i < pBEntryFieldArray.length; ++i) {
            PBEntryField pBEntryField = pBEntryFieldArray[i];
            JComboBox jComboBox = new JComboBox();
            this.mappingEntryFields.put(pBEntryField, jComboBox);
            Utils.addWithLabel(jPanel, jComboBox, pBEntryField.getDescription() + ":", new TableLayoutConstraints(n2, n3));
            if ((n2 += 2) <= 4) continue;
            n2 = 0;
            n3 += 3;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CSVDialog.this.eventLock) {
                    return;
                }
                Utils.setWaitCursor(CSVDialog.this);
                CSVDialog.this.saveToSettings(CSVDialog.this.settings);
                CSVDialog.this.refreshPreview();
                Utils.unsetWaitCursor(CSVDialog.this);
            }
        };
        this.comboCharset.addActionListener(actionListener);
        this.comboQuote.addActionListener(actionListener);
        this.comboSeparator.addActionListener(actionListener);
        this.checkFirstLineHeader.addActionListener(actionListener);
        return jPanel;
    }
}

