/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.jdbc;

import java.awt.Dialog;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import yajhfc.Utils;
import yajhfc.phonebook.AbstractConnectionSettings;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.GeneralConnectionSettings;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.WrapperDistributionList;
import yajhfc.phonebook.jdbc.ConnectionDialog;
import yajhfc.phonebook.jdbc.ConnectionSettings;
import yajhfc.phonebook.jdbc.JDBCPhoneBookEntry;
import yajhfc.plugin.PluginManager;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.PasswordDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPhoneBook
extends PhoneBook {
    private static final Logger log = Logger.getLogger(JDBCPhoneBook.class.getName());
    ConnectionSettings settings;
    boolean open = false;
    List<JDBCPhoneBookEntry> items = new ArrayList<JDBCPhoneBookEntry>();
    List<JDBCPhoneBookEntry> deleted_items = new ArrayList<JDBCPhoneBookEntry>();
    List<PhoneBookEntry> itemsView = new ArrayList<PhoneBookEntry>();
    List<DBKey> rowId = new ArrayList<DBKey>();
    int[] maxLength = new int[PBEntryField.FIELD_COUNT];
    protected static final Map<String, ConnectionDialog.FieldMapEntry> fieldNameMap = new HashMap<String, ConnectionDialog.FieldMapEntry>();
    public static final String PB_Prefix = "JDBC";
    public static final String PB_DisplayName;
    public static final String PB_Description;

    public JDBCPhoneBook(Dialog dialog) {
        super(dialog);
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        JDBCPhoneBookEntry jDBCPhoneBookEntry = new JDBCPhoneBookEntry(this);
        this.items.add(jDBCPhoneBookEntry);
        this.itemsView.add(jDBCPhoneBookEntry);
        this.fireEntriesAdded(this.itemsView.size() - 1, jDBCPhoneBookEntry);
        return jDBCPhoneBookEntry;
    }

    @Override
    public DistributionList addDistributionList() {
        if (!this.settings.allowDistLists) {
            throw new UnsupportedOperationException("No distribution lists allowed.");
        }
        JDBCPhoneBookEntry jDBCPhoneBookEntry = new JDBCPhoneBookEntry(this);
        WrapperDistributionList wrapperDistributionList = new WrapperDistributionList(jDBCPhoneBookEntry);
        this.items.add(jDBCPhoneBookEntry);
        this.itemsView.add(wrapperDistributionList);
        this.fireEntriesAdded(this.itemsView.size() - 1, wrapperDistributionList);
        return wrapperDistributionList;
    }

    @Override
    public String browseForPhoneBook(boolean bl) {
        ConnectionSettings connectionSettings = new ConnectionSettings(this.settings);
        ConnectionDialog connectionDialog = new ConnectionDialog(this.parentDialog, Utils._("New JDBC phone book"), Utils._("Please select which database fields correspond to the phone book entry fields of YajHFC:"), fieldNameMap, true);
        if (connectionDialog.promptForNewSettings(connectionSettings)) {
            return "JDBC:" + connectionSettings.saveToString();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.open) {
            this.commitToDB();
            this.open = false;
        }
    }

    private PBEntryField getPBEntryFieldFor(String string) {
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            if (!string.equalsIgnoreCase(this.settings.getMappingFor(pBEntryField))) continue;
            return pBEntryField;
        }
        return null;
    }

    private int appendFieldList(StringBuilder stringBuilder, String string, String string2) {
        int n = 0;
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            String string3 = this.settings.getMappingFor(pBEntryField);
            if (ConnectionSettings.isNoField(string3)) continue;
            stringBuilder.append(string3).append(string).append(string2);
            ++n;
        }
        stringBuilder.setLength(stringBuilder.length() - string2.length());
        return n;
    }

    private int appendKeyList(StringBuilder stringBuilder, String string, String string2) {
        int n = 0;
        for (DBKey dBKey : this.rowId) {
            stringBuilder.append(dBKey.columnName).append(string).append(string2);
            ++n;
        }
        if (n > 0) {
            stringBuilder.setLength(stringBuilder.length() - string2.length());
        }
        return n;
    }

    private String getSELECTQuery() {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.appendFieldList(stringBuilder, "", ", ") == 0) {
            return null;
        }
        for (DBKey dBKey : this.rowId) {
            if (dBKey.isDataColumn()) continue;
            stringBuilder.append(", ").append(dBKey.columnName);
        }
        stringBuilder.append(" FROM ").append(this.settings.table);
        return stringBuilder.toString();
    }

    private String getDELETEQuery() {
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
        stringBuilder.append(this.settings.table);
        stringBuilder.append(" WHERE ");
        if (this.appendKeyList(stringBuilder, " = ?", " AND ") == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    private String getINSERTQuery() {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        stringBuilder.append(this.settings.table);
        stringBuilder.append(" (");
        int n = this.appendFieldList(stringBuilder, "", ", ");
        if (n == 0) {
            return null;
        }
        stringBuilder.append(") VALUES (");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("?, ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String getUPDATEQuery() {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        stringBuilder.append(this.settings.table);
        stringBuilder.append(" SET ");
        if (this.appendFieldList(stringBuilder, " = ?", ", ") == 0) {
            return null;
        }
        stringBuilder.append(" WHERE ");
        this.appendKeyList(stringBuilder, " = ?", " AND ");
        return stringBuilder.toString();
    }

    protected Connection openConnection() throws PhoneBookException {
        String string;
        try {
            PluginManager.registerJDBCDriver(this.settings.driver);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Could not load the specified driver class:"), exception);
            throw new PhoneBookException(exception, true);
        }
        if (this.settings.askForPWD) {
            String[] stringArray = PasswordDialog.showPasswordDialog(this.parentDialog, Utils._("Database password"), MessageFormat.format(Utils._("Please enter the database password (database: {0}):"), this.settings.dbURL), this.settings.user, false);
            if (stringArray == null) {
                return null;
            }
            string = stringArray[1];
        } else {
            string = this.settings.pwd.getPassword();
        }
        try {
            return DriverManager.getConnection(this.settings.dbURL, this.settings.user, string);
        }
        catch (SQLException sQLException) {
            ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Could not connect to the database:"), sQLException);
            throw new PhoneBookException(sQLException, true);
        }
    }

    @Override
    protected void openInternal(String string) throws PhoneBookException {
        this.settings = new ConnectionSettings(string);
        Connection connection = this.openConnection();
        if (connection == null) {
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getBestRowIdentifier(null, null, this.settings.table, 2, true);
            this.rowId.clear();
            while (resultSet.next()) {
                String string2 = resultSet.getString("COLUMN_NAME");
                this.rowId.add(new DBKey(string2, this.getPBEntryFieldFor(string2)));
            }
            resultSet.close();
            if (this.rowId.size() == 0) {
                log.info("No key found, using all data fields as replacement");
                for (PBEntryField pBEntryField : PBEntryField.values()) {
                    String string3 = this.settings.getMappingFor(pBEntryField);
                    if (AbstractConnectionSettings.isNoField(string3)) continue;
                    this.rowId.add(new DBKey(string3, pBEntryField));
                }
            }
            if (Utils.debugMode) {
                log.fine("Table key is: " + this.rowId);
            }
            this.loadItems(connection);
            this.open = true;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Could not load the phone book:"), exception);
            throw new PhoneBookException(exception, true);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                log.log(Level.WARNING, "Error closing the database connection:", sQLException);
            }
        }
    }

    protected void loadItems(Connection connection) throws SQLException {
        String string = this.getSELECTQuery();
        if (Utils.debugMode) {
            log.fine("JDBC phone book: SELECT query: " + string);
        }
        if (string == null) {
            JOptionPane.showMessageDialog(this.parentDialog, Utils._("Cannot open phone book since no database fields were selected!"));
            return;
        }
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 1;
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            this.maxLength[pBEntryField.ordinal()] = !ConnectionSettings.isNoField(this.settings.getMappingFor(pBEntryField)) ? resultSetMetaData.getColumnDisplaySize(n++) : 0;
        }
        this.deleted_items.clear();
        this.items.clear();
        this.itemsView.clear();
        while (resultSet.next()) {
            JDBCPhoneBookEntry jDBCPhoneBookEntry = new JDBCPhoneBookEntry(this);
            jDBCPhoneBookEntry.readFromCurrentDataset(resultSet);
            this.items.add(jDBCPhoneBookEntry);
            if (WrapperDistributionList.isDistributionList(jDBCPhoneBookEntry)) {
                this.itemsView.add(new WrapperDistributionList(jDBCPhoneBookEntry));
                continue;
            }
            this.itemsView.add(jDBCPhoneBookEntry);
        }
        resultSet.close();
        statement.close();
    }

    protected void commitToDB() {
        if (this.isReadOnly()) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.openConnection();
            if (connection == null) {
                return;
            }
            this.commitToDB(connection);
        }
        catch (PhoneBookException phoneBookException) {
            if (!phoneBookException.messageAlreadyDisplayed()) {
                ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Could not save the phone book:"), phoneBookException);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Could not save the phone book:"), exception);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                log.log(Level.WARNING, "Error closing the database connection:", sQLException);
            }
        }
    }

    protected void commitToDB(Connection connection) throws SQLException {
        if (this.isReadOnly()) {
            return;
        }
        String string = this.getINSERTQuery();
        if (Utils.debugMode) {
            log.fine("JDBC phone book: INSERT query: " + string);
        }
        if (string == null) {
            JOptionPane.showMessageDialog(this.parentDialog, MessageFormat.format(Utils._("Could not save the changes: No valid {0} query."), "INSERT"), Utils._("Error"), 2);
            return;
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        string = this.getUPDATEQuery();
        if (Utils.debugMode) {
            log.fine("JDBC phone book: UPDATE query: " + string);
        }
        if (string == null) {
            JOptionPane.showMessageDialog(this.parentDialog, MessageFormat.format(Utils._("Could not save the changes: No valid {0} query."), "UPDATE"), Utils._("Error"), 2);
            return;
        }
        PreparedStatement preparedStatement2 = connection.prepareStatement(string);
        string = this.getDELETEQuery();
        if (Utils.debugMode) {
            log.fine("JDBC phone book: DELETE query: " + string);
        }
        if (string == null) {
            JOptionPane.showMessageDialog(this.parentDialog, MessageFormat.format(Utils._("Could not save the changes: No valid {0} query."), "DELETE"), Utils._("Error"), 2);
            return;
        }
        PreparedStatement preparedStatement3 = connection.prepareStatement(string);
        connection.setAutoCommit(false);
        for (JDBCPhoneBookEntry jDBCPhoneBookEntry : this.deleted_items) {
            try {
                jDBCPhoneBookEntry.commitToDB(preparedStatement, preparedStatement2, preparedStatement3);
            }
            catch (SQLException sQLException) {
                ExceptionDialog.showExceptionDialog(this.parentDialog, MessageFormat.format(Utils._("Could not save the changes for entry {0}:"), jDBCPhoneBookEntry.toString()), sQLException);
            }
        }
        for (JDBCPhoneBookEntry jDBCPhoneBookEntry : this.items) {
            try {
                jDBCPhoneBookEntry.commitToDB(preparedStatement, preparedStatement2, preparedStatement3);
            }
            catch (SQLException sQLException) {
                ExceptionDialog.showExceptionDialog(this.parentDialog, MessageFormat.format(Utils._("Could not save the changes for entry {0}:"), jDBCPhoneBookEntry.toString()), sQLException);
            }
        }
        connection.commit();
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    void updatePosition(JDBCPhoneBookEntry jDBCPhoneBookEntry) {
        int n = Utils.identityIndexOf(this.items, jDBCPhoneBookEntry);
        this.fireEntriesChanged(n, jDBCPhoneBookEntry);
    }

    void removeFromList(JDBCPhoneBookEntry jDBCPhoneBookEntry) {
        int n = Utils.identityIndexOf(this.items, jDBCPhoneBookEntry);
        if (n >= 0) {
            this.items.remove(n);
            this.itemsView.remove(n);
            this.fireEntriesRemoved(n, jDBCPhoneBookEntry);
        }
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.itemsView;
    }

    @Override
    public String getDisplayCaption() {
        if (this.settings.displayCaption != null && this.settings.displayCaption.length() > 0) {
            return this.settings.displayCaption;
        }
        String string = this.settings.dbURL;
        if (string.length() > 40) {
            return string.substring(0, 37) + "...";
        }
        return string;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isReadOnly() {
        return this.settings.readOnly;
    }

    @Override
    public boolean supportsDistributionLists() {
        return this.settings.allowDistLists && WrapperDistributionList.areDistributionListsSupported(this);
    }

    @Override
    public boolean isFieldAvailable(PBEntryField pBEntryField) {
        return !ConnectionSettings.isNoField(this.settings.getMappingFor(pBEntryField));
    }

    @Override
    public int getMaxLength(PBEntryField pBEntryField) {
        return this.maxLength[pBEntryField.ordinal()];
    }

    private static JDBCPhoneBookEntry toJDBCEntry(PhoneBookEntry phoneBookEntry) {
        if (phoneBookEntry instanceof WrapperDistributionList) {
            return (JDBCPhoneBookEntry)((WrapperDistributionList)phoneBookEntry).getWrappedEntry();
        }
        return (JDBCPhoneBookEntry)phoneBookEntry;
    }

    static {
        GeneralConnectionSettings.PBEntrySettingsField[] pBEntrySettingsFieldArray = GeneralConnectionSettings.entryFields;
        for (int i = 0; i < pBEntrySettingsFieldArray.length; ++i) {
            GeneralConnectionSettings.PBEntrySettingsField pBEntrySettingsField = pBEntrySettingsFieldArray[i];
            fieldNameMap.put(pBEntrySettingsField.getName(), new ConnectionDialog.FieldMapEntry(pBEntrySettingsField.getField().getDescription() + ":", i));
        }
        fieldNameMap.put("readOnly", new ConnectionDialog.FieldMapEntry(Utils._("Open as read only"), 0, false, Boolean.class));
        fieldNameMap.put("displayCaption", new ConnectionDialog.FieldMapEntry(Utils._("Phone book name to display:"), 2, false, String.class));
        fieldNameMap.put("allowDistLists", new ConnectionDialog.FieldMapEntry(Utils._("Allow distribution list entries"), 1, false, Boolean.class));
        PB_DisplayName = Utils._("JDBC phone book");
        PB_Description = Utils._("A phone book saving its entries in a relational database using JDBC.");
    }

    protected static class DBKey {
        public final String columnName;
        public final PBEntryField dataField;

        public DBKey(String string, PBEntryField pBEntryField) {
            this.columnName = string;
            this.dataField = pBEntryField;
        }

        public String toString() {
            return "DBKey[columnName=" + this.columnName + ";dataField=" + (this.dataField == null ? "<null>" : this.dataField.name()) + "]";
        }

        public boolean isDataColumn() {
            return this.dataField != null;
        }
    }
}

