/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.SimplePhoneBookEntry;
import yajhfc.phonebook.jdbc.ConnectionSettings;
import yajhfc.phonebook.jdbc.JDBCPhoneBook;

public class JDBCPhoneBookEntry
extends SimplePhoneBookEntry {
    private static final Logger log = Logger.getLogger(JDBCPhoneBookEntry.class.getName());
    private JDBCPhoneBook parent;
    private Object[] rowKeys;
    int entryStatus;
    static final int ENTRY_NOTINSERTED = 1;
    static final int ENTRY_UNCHANGED = 2;
    static final int ENTRY_CHANGED = 3;
    static final int ENTRY_DELETED = 4;

    JDBCPhoneBookEntry(JDBCPhoneBook jDBCPhoneBook) {
        this.parent = jDBCPhoneBook;
        this.rowKeys = new Object[jDBCPhoneBook.rowId.size()];
        this.entryStatus = 1;
    }

    private String fetchValue(String string, ResultSet resultSet) {
        if (ConnectionSettings.isNoField(string)) {
            return "";
        }
        try {
            return resultSet.getString(string);
        }
        catch (SQLException sQLException) {
            log.log(Level.WARNING, "Error loading value " + string + " from " + resultSet, sQLException);
            return Utils._("<error>");
        }
    }

    void readFromCurrentDataset(ResultSet resultSet) throws SQLException {
        ConnectionSettings connectionSettings = this.parent.settings;
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            this.setFieldUndirty(pBEntryField, this.fetchValue(connectionSettings.getMappingFor(pBEntryField), resultSet));
        }
        this.readKeys(resultSet);
        this.entryStatus = 2;
        this.setDirty(false);
    }

    private void readKeys(ResultSet resultSet) throws SQLException {
        for (int i = 0; i < this.parent.rowId.size(); ++i) {
            JDBCPhoneBook.DBKey dBKey = this.parent.rowId.get(i);
            this.rowKeys[i] = dBKey.isDataColumn() ? this.getField(dBKey.dataField) : resultSet.getObject(dBKey.columnName);
        }
    }

    private int setChangedValues(PreparedStatement preparedStatement, int n) throws SQLException {
        ConnectionSettings connectionSettings = this.parent.settings;
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            if (ConnectionSettings.isNoField(connectionSettings.getMappingFor(pBEntryField))) continue;
            preparedStatement.setString(n, this.getField(pBEntryField));
            ++n;
        }
        return n;
    }

    private int setOriginalValues(PreparedStatement preparedStatement, int n) throws SQLException {
        for (int i = 0; i < this.parent.rowId.size(); ++i) {
            preparedStatement.setObject(n++, this.rowKeys[i]);
        }
        return n;
    }

    void commitToDB(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3) throws SQLException {
        switch (this.entryStatus) {
            case 2: {
                break;
            }
            case 3: {
                int n = this.setChangedValues(preparedStatement2, 1);
                this.setOriginalValues(preparedStatement2, n);
                preparedStatement2.execute();
                break;
            }
            case 1: {
                this.setChangedValues(preparedStatement, 1);
                preparedStatement.execute();
                break;
            }
            case 4: {
                this.setOriginalValues(preparedStatement3, 1);
                preparedStatement3.execute();
            }
        }
    }

    public void updateDisplay() {
        if (this.isDirty()) {
            this.parent.updatePosition(this);
        }
    }

    public void commit() {
        if (this.isDirty()) {
            this.parent.updatePosition(this);
            if (this.entryStatus == 2) {
                this.entryStatus = 3;
            }
            this.setDirty(false);
        }
    }

    public void delete() {
        if (this.entryStatus != 1) {
            this.entryStatus = 4;
            this.parent.deleted_items.add(this);
        }
        this.parent.removeFromList(this);
    }

    public PhoneBook getParent() {
        return this.parent;
    }
}

