/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ldap;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import yajhfc.Utils;
import yajhfc.filters.CombinationFilter;
import yajhfc.filters.ConcatStringFilter;
import yajhfc.filters.Filter;
import yajhfc.filters.OrFilter;
import yajhfc.filters.StringFilter;
import yajhfc.filters.StringFilterOperator;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.ldap.ConnectionDialog;
import yajhfc.phonebook.ldap.LDAPPhoneBookEntry;
import yajhfc.phonebook.ldap.LDAPSettings;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.PasswordDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPhoneBook
extends PhoneBook {
    public static final String PB_Prefix = "LDAP";
    public static final String PB_DisplayName = Utils._("LDAP phone book (read only)");
    public static final String PB_Description = Utils._("A phone book reading its entries from an LDAP directory.");
    private static final Logger log = Logger.getLogger(LDAPPhoneBook.class.getName());
    LDAPSettings settings;
    private DirContext ctx;
    private final ArrayList<LDAPPhoneBookEntry> entries = new ArrayList();
    protected static final Pattern tokenSplitter = Pattern.compile("(\\s|[,;])+");
    private List<PhoneBookEntry> itemsView = Collections.unmodifiableList(this.entries);

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public PhoneBookEntry addNewEntry() {
        return null;
    }

    @Override
    public String browseForPhoneBook(boolean bl) {
        ConnectionDialog connectionDialog = new ConnectionDialog(this.parentDialog);
        LDAPSettings lDAPSettings = new LDAPSettings(this.settings);
        if (connectionDialog.browseForPhonebook(lDAPSettings)) {
            return "LDAP:" + lDAPSettings.saveToString();
        }
        return null;
    }

    @Override
    public void close() {
        this.entries.clear();
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.ctx = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.ctx != null;
    }

    @Override
    protected void openInternal(String string) throws PhoneBookException {
        try {
            this.settings = new LDAPSettings(string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            hashtable.put("java.naming.provider.url", "ldap://" + this.settings.serverName + ":" + this.settings.port + "/" + LDAPSettings.sanitizeDN(this.settings.baseDN));
            if (this.settings.useAuth) {
                String string2;
                hashtable.put("java.naming.security.authentication", "simple");
                hashtable.put("java.naming.security.principal", LDAPSettings.sanitizeDN(this.settings.bindDN));
                if (this.settings.askForCredential) {
                    String[] stringArray = PasswordDialog.showPasswordDialog(this.parentDialog, Utils._("LDAP password"), Utils._("Please enter the LDAP password:"), this.settings.bindDN, false);
                    if (stringArray == null) {
                        return;
                    }
                    string2 = stringArray[1];
                } else {
                    string2 = this.settings.credential.getPassword();
                }
                hashtable.put("java.naming.security.credentials", string2);
            } else {
                hashtable.put("java.naming.security.authentication", "none");
            }
            this.ctx = new InitialDirContext(hashtable);
            if (this.settings.initiallyLoadAll) {
                this.loadEntries(this.entries, null, this.settings.countLimit);
            }
        }
        catch (NamingException namingException) {
            this.ctx = null;
            throw new PhoneBookException(namingException, false);
        }
    }

    protected <T extends PhoneBookEntry> void loadEntries(List<T> list, Filter<PhoneBookEntry, PBEntryField> filter, int n) throws NamingException {
        SearchControls searchControls = new SearchControls();
        if (this.settings.searchSubTree) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setCountLimit(n);
        searchControls.setReturningAttributes(this.settings.getAttributes());
        String string = this.getLDAPFilter(filter);
        if (Utils.debugMode) {
            log.fine("LDAP filter: " + string);
        }
        NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search("", string, searchControls);
        while (namingEnumeration.hasMore()) {
            list.add(new LDAPPhoneBookEntry(this, namingEnumeration.next()));
        }
        namingEnumeration.close();
        Collections.sort(list);
        Utils.dedupSortedList(list);
    }

    @Override
    public List<PhoneBookEntry> applyFilter(Filter<PhoneBookEntry, PBEntryField> filter) {
        if (this.settings.initiallyLoadAll || filter == null) {
            return super.applyFilter(filter);
        }
        ArrayList<PhoneBookEntry> arrayList = new ArrayList<PhoneBookEntry>();
        try {
            this.loadEntries(arrayList, filter, this.settings.countLimit);
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog(this.parentDialog, Utils._("Error executing the search:"), namingException);
        }
        return arrayList;
    }

    protected String getLDAPFilter(Filter<PhoneBookEntry, PBEntryField> filter) {
        String string = this.settings.objectFilter == null || this.settings.objectFilter.length() == 0 ? "(objectClass=*)" : this.settings.objectFilter;
        if (filter == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(&");
        if (string.charAt(0) == '(' && string.charAt(string.length() - 1) == ')') {
            stringBuilder.append(string);
        } else {
            stringBuilder.append('(').append(string).append(')');
        }
        this.appendLDAPSearchForFilter(stringBuilder, filter);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected void appendLDAPSearchForFilter(StringBuilder stringBuilder, Filter<PhoneBookEntry, PBEntryField> filter) {
        if (filter instanceof CombinationFilter) {
            CombinationFilter combinationFilter = (CombinationFilter)filter;
            stringBuilder.append('(');
            if (filter instanceof OrFilter) {
                stringBuilder.append('|');
            } else {
                stringBuilder.append('&');
            }
            for (Filter<PhoneBookEntry, PBEntryField> filter2 : combinationFilter.getChildList()) {
                this.appendLDAPSearchForFilter(stringBuilder, filter2);
            }
            stringBuilder.append(')');
        } else if (filter instanceof StringFilter) {
            StringFilter stringFilter = (StringFilter)filter;
            this.appendStringFilter(stringBuilder, (PBEntryField)stringFilter.getColumn(), stringFilter.getOperator(), stringFilter.getCompareValue().toString());
        } else if (filter instanceof ConcatStringFilter) {
            ConcatStringFilter concatStringFilter = (ConcatStringFilter)filter;
            String[] stringArray = tokenSplitter.split(concatStringFilter.getCompareValue().toString());
            if (stringArray.length > 1) {
                stringBuilder.append("(&");
            }
            for (String string : stringArray) {
                stringBuilder.append("(|");
                for (Object object : concatStringFilter.getConcatVals()) {
                    if (!(object instanceof PBEntryField)) continue;
                    this.appendStringFilter(stringBuilder, (PBEntryField)object, concatStringFilter.getOperator(), string);
                }
                stringBuilder.append(')');
            }
            if (stringArray.length > 1) {
                stringBuilder.append(')');
            }
        } else {
            log.severe("Unsupported filter type: " + filter.getClass());
            stringBuilder.append("(objectClass=*)");
        }
    }

    protected void appendStringFilter(StringBuilder stringBuilder, PBEntryField pBEntryField, StringFilterOperator stringFilterOperator, String string) {
        String string2 = this.settings.getMappingFor(pBEntryField);
        if (LDAPSettings.isNoField(string2)) {
            stringBuilder.append("(objectClass=*)");
        } else {
            stringBuilder.append('(');
            switch (stringFilterOperator) {
                case CONTAINS: {
                    stringBuilder.append(string2);
                    stringBuilder.append("=*");
                    LDAPPhoneBook.appendEscaped(stringBuilder, string);
                    stringBuilder.append('*');
                    break;
                }
                case CONTAINS_NOT: {
                    stringBuilder.append("!(");
                    stringBuilder.append(string2);
                    stringBuilder.append("=*");
                    LDAPPhoneBook.appendEscaped(stringBuilder, string);
                    stringBuilder.append('*');
                    stringBuilder.append(')');
                    break;
                }
                case ENDSWITH: {
                    stringBuilder.append(string2);
                    stringBuilder.append("=*");
                    LDAPPhoneBook.appendEscaped(stringBuilder, string);
                    break;
                }
                case STARTSWITH: {
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    LDAPPhoneBook.appendEscaped(stringBuilder, string);
                    stringBuilder.append('*');
                    break;
                }
                default: {
                    log.warning("Unsupported String operator " + stringFilterOperator.name());
                }
                case EQUAL: {
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    LDAPPhoneBook.appendEscaped(stringBuilder, string);
                    break;
                }
                case NOTEQUAL: {
                    stringBuilder.append("!(");
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    LDAPPhoneBook.appendEscaped(stringBuilder, string);
                    stringBuilder.append(')');
                }
            }
            stringBuilder.append(')');
        }
    }

    public static void appendEscaped(StringBuilder stringBuilder, String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': 
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    stringBuilder.append('\\').append(Character.forDigit(c & 0xF, 16)).append(Character.forDigit(c >> 4 & 0xF, 16));
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    @Override
    public String getDisplayCaption() {
        if (this.settings.displayCaption != null && this.settings.displayCaption.length() > 0) {
            return this.settings.displayCaption;
        }
        String string = "LDAP:" + this.settings.serverName + "/" + this.settings.baseDN;
        if (string.length() > 40) {
            return string.substring(0, 37) + "...";
        }
        return string;
    }

    @Override
    public List<PhoneBookEntry> getEntries() {
        return this.itemsView;
    }

    public LDAPPhoneBook(Dialog dialog) {
        super(dialog);
    }
}

