/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import yajhfc.FaxOptions;
import yajhfc.Utils;
import yajhfc.export.PhoneBookHTMLExporter;
import yajhfc.file.FileFormat;
import yajhfc.filters.AndFilter;
import yajhfc.filters.ConcatStringFilter;
import yajhfc.filters.Filter;
import yajhfc.filters.OrFilter;
import yajhfc.filters.StringFilter;
import yajhfc.filters.StringFilterOperator;
import yajhfc.filters.ui.CustomFilterDialog;
import yajhfc.phonebook.DistributionList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.PhoneBookEntry;
import yajhfc.phonebook.PhoneBookEntryList;
import yajhfc.phonebook.PhoneBookException;
import yajhfc.phonebook.PhoneBookFactory;
import yajhfc.phonebook.PhoneBookType;
import yajhfc.phonebook.SortOrder;
import yajhfc.phonebook.convrules.ConcatRule;
import yajhfc.phonebook.convrules.EntryToStringRule;
import yajhfc.phonebook.convrules.NameRule;
import yajhfc.phonebook.convrules.RuleSerializer;
import yajhfc.phonebook.ui.DistributionListPhonebookPanel;
import yajhfc.phonebook.ui.NewSearchWin;
import yajhfc.phonebook.ui.PBEntryFieldTableModel;
import yajhfc.phonebook.ui.PhoneBookTreeModel;
import yajhfc.phonebook.ui.PhonebookPanel;
import yajhfc.phonebook.ui.RuleParserDialog;
import yajhfc.phonebook.ui.SingleEntryPhonebookPanel;
import yajhfc.phonebook.ui.SortOrderDialog;
import yajhfc.plugin.PluginManager;
import yajhfc.plugin.PluginUI;
import yajhfc.print.PhonebooksPrinter;
import yajhfc.util.AbstractQuickSearchHelper;
import yajhfc.util.AcceleratorKeyDialog;
import yajhfc.util.AcceleratorKeys;
import yajhfc.util.ActionJCheckBoxMenuItem;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.ExampleFileFilter;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.ExceptionDialog;
import yajhfc.util.MultiButtonGroup;
import yajhfc.util.ProgressPanel;
import yajhfc.util.ProgressWorker;
import yajhfc.util.SafeJFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewPhoneBookWin
extends JDialog
implements ActionListener {
    private static final String CUSTOM_NAME_RULE = "%custom%";
    private static final String FILTER_ACTION_COMMAND = "FilterEntries";
    private static final String SHOWALL_ACTION_COMMAND = "ShowAllEntries";
    private static final String SORT_DEFAULT_ACTION_COMMAND = "SortDefault";
    private static final String SORT_CUSTOM_ACTION_COMMAND = "SortCustom";
    static final Logger log = Logger.getLogger(NewPhoneBookWin.class.getName());
    JSplitPane splitPane;
    JTree phoneBookTree;
    PhoneBookTreeModel treeModel;
    JPanel rightPane;
    JPanel leftPane;
    SingleEntryPhonebookPanel singleEntryPanel;
    DistributionListPhonebookPanel distListPanel;
    JTextField textDescriptor;
    JButton buttonBrowse;
    JMenu pbMenu;
    JMenu importMenu;
    JMenu openMenu;
    JMenu entryMenu;
    JMenu exportMenu;
    JMenu viewMenu;
    JPopupMenu treePopup;
    Action listRemoveAction;
    Action addEntryAction;
    Action removeEntryAction;
    Action searchEntryAction;
    Action selectAction;
    Action addDistListAction;
    Action viewPopupMenuAction;
    Action printAction;
    Action exportHTMLAction;
    Action closeAction;
    Action editAcceleratorsAction;
    Action expandAllAction;
    Action collapseAllAction;
    Action expandOnLoadAction;
    MultiButtonGroup nameStyleGroup;
    MultiButtonGroup viewGroup;
    MultiButtonGroup sortGroup;
    ProgressPanel progressPanel;
    SearchHelper searchHelper = new SearchHelper();
    NewSearchWin searchWin;
    boolean usedSelectButton = false;
    final List<PhoneBookEntry> selectedItems = new ArrayList<PhoneBookEntry>();
    PhoneBook currentPhonebook = null;
    static final int border = 5;
    TreeCellRenderer phoneBookRenderer = new PhoneBookRenderer();
    boolean allowSavePhonebooks = false;
    Map<String, Action> availableActions = new HashMap<String, Action>();
    EntryToStringRule nameRule;
    SortOrder sortOrder;
    private PhonebookPanel lastPanel;
    ProgressWorker closeWorker;
    int openCounter = 0;

    void writeToTextFields(PhoneBook phoneBook, List<PhoneBookEntry> list) {
        PhonebookPanel phonebookPanel;
        if (list == null || list.size() == 0) {
            phonebookPanel = this.getPanelFor(null);
            phonebookPanel.writeToTextFields(null, null);
        } else if (list.size() == 1) {
            PhoneBookEntry phoneBookEntry = list.get(0);
            phonebookPanel = this.getPanelFor(phoneBookEntry);
            phonebookPanel.writeToTextFields(phoneBook, phoneBookEntry);
        } else {
            phonebookPanel = this.distListPanel;
            this.distListPanel.showMultiSelection(phoneBook, list);
        }
        if (phonebookPanel != this.lastPanel) {
            if (this.lastPanel != null) {
                this.lastPanel.setVisible(false);
            }
            phonebookPanel.setVisible(true);
            this.lastPanel = phonebookPanel;
        }
    }

    void readFromTextFields(PhoneBookEntry phoneBookEntry, boolean bl) {
        this.getPanelFor(phoneBookEntry).readFromTextFields(phoneBookEntry, bl);
    }

    private PhonebookPanel getPanelFor(PhoneBookEntry phoneBookEntry) {
        if (phoneBookEntry instanceof DistributionList) {
            return this.distListPanel;
        }
        return this.singleEntryPanel;
    }

    private JPanel getRightPane() {
        if (this.rightPane == null) {
            double[][] dArrayArray = new double[][]{{5.0, -1.0, 5.0}, {5.0, -2.0, -2.0, 5.0, -2.0, 5.0, -1.0, 5.0}};
            this.rightPane = new JPanel(new TableLayout(dArrayArray));
            this.textDescriptor = new JTextField();
            this.textDescriptor.setEditable(false);
            this.textDescriptor.setBackground(UIManager.getColor("Label.backgroundColor"));
            this.textDescriptor.addMouseListener(this.getDefClPop());
            this.buttonBrowse = new JButton(Utils.loadIcon("general/Open"));
            this.buttonBrowse.setActionCommand("browse");
            this.buttonBrowse.addActionListener(this);
            JPanel jPanel = new JPanel(null);
            jPanel.setLayout(new OverlayLayout(jPanel));
            this.singleEntryPanel = new SingleEntryPhonebookPanel(this);
            this.lastPanel = this.singleEntryPanel;
            this.distListPanel = new DistributionListPhonebookPanel(this);
            this.distListPanel.setVisible(false);
            jPanel.add(this.singleEntryPanel);
            jPanel.add(this.distListPanel);
            Box box = Box.createHorizontalBox();
            box.add(this.textDescriptor);
            box.add(this.buttonBrowse);
            this.rightPane.add((Component)new JLabel(Utils._("Current phone book:")), "1,1");
            this.rightPane.add((Component)box, "1,2");
            this.rightPane.add((Component)new JSeparator(), "0,4,2,4");
            this.rightPane.add((Component)jPanel, "1,6");
        }
        return this.rightPane;
    }

    private ClipboardPopup getDefClPop() {
        return ClipboardPopup.DEFAULT_POPUP;
    }

    public PhoneBook getCurrentPhoneBook() {
        return this.currentPhonebook;
    }

    public List<PhoneBookEntry> getRawSelectedEntries() {
        return this.selectedItems;
    }

    public JTree getPhoneBookTree() {
        return this.phoneBookTree;
    }

    public PhoneBookTreeModel getTreeModel() {
        return this.treeModel;
    }

    public List<PhoneBook> getAvailablePhoneBooks() {
        return this.treeModel.getPhoneBooks();
    }

    void addPhoneBook(String string) {
        for (PhoneBook phoneBook : this.treeModel.getPhoneBooks()) {
            if (!string.equals(phoneBook.getDescriptor())) continue;
            JOptionPane.showMessageDialog(this, Utils._("This phone book has already been added."), Utils._("Add to list"), 2);
            return;
        }
        PBOpenWorker pBOpenWorker = new PBOpenWorker(string);
        pBOpenWorker.startWork(this, Utils._("Opening phone books..."));
    }

    void closeCurrentPhoneBook() {
        if (this.currentPhonebook != null) {
            PhoneBook phoneBook = this.currentPhonebook;
            phoneBook.close();
            this.currentPhonebook = null;
            this.selectedItems.clear();
            this.treeModel.removePhoneBook(phoneBook);
        }
    }

    public void browseForPhonebook() {
        String string;
        if (this.currentPhonebook != null && (string = this.currentPhonebook.browseForPhoneBook(false)) != null) {
            try {
                this.currentPhonebook.close();
                this.selectedItems.clear();
                this.currentPhonebook.open(string);
                this.treeModel.refreshPhoneBook(this.currentPhonebook);
            }
            catch (PhoneBookException phoneBookException) {
                if (!phoneBookException.messageAlreadyDisplayed()) {
                    ExceptionDialog.showExceptionDialog(this, Utils._("Error loading the phone book: "), phoneBookException);
                }
                this.closeCurrentPhoneBook();
            }
        }
    }

    void closeAndSaveAllPhonebooks(final boolean bl) {
        if (this.closeWorker != null && this.closeWorker.isWorking()) {
            return;
        }
        if (!this.allowSavePhonebooks) {
            if (bl) {
                this.dispose();
            }
            return;
        }
        this.commitCurrentEdits();
        this.allowSavePhonebooks = false;
        log.fine("Closing all phone books...");
        this.closeWorker = new ProgressWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doWork() {
                List<String> list;
                List<String> list2 = list = Utils.getFaxOptions().phoneBooks;
                synchronized (list2) {
                    list.clear();
                    for (PhoneBook phoneBook : NewPhoneBookWin.this.treeModel.getPhoneBooks()) {
                        try {
                            if (Utils.debugMode) {
                                log.finest("Closing phone book " + phoneBook.getDescriptor());
                            }
                            this.updateNote(phoneBook.toString());
                            list.add(phoneBook.getDescriptor());
                            phoneBook.close();
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog(NewPhoneBookWin.this, Utils._("Error saving a phone book:"), exception);
                        }
                    }
                }
            }

            protected void done() {
                if (Utils.debugMode) {
                    log.finest("Closed all phone books. pbList=" + Utils.getFaxOptions().phoneBooks);
                }
                if (bl) {
                    NewPhoneBookWin.this.dispose();
                } else {
                    NewPhoneBookWin.this.checkMenuEnable();
                }
                NewPhoneBookWin.this.allowSavePhonebooks = true;
                NewPhoneBookWin.this.closeWorker = null;
            }
        };
        this.closeWorker.setProgressMonitor(this.progressPanel);
        this.selectedItems.clear();
        this.currentPhonebook = null;
        this.closeWorker.startWork(this, Utils._("Closing phone books..."));
    }

    void checkMenuEnable() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.currentPhonebook != null;
        bl3 = this.treeModel.getPhoneBooks().size() > 0;
        bl2 = bl5 && !this.currentPhonebook.isReadOnly() && this.currentPhonebook.isOpen();
        bl4 = this.selectedItems.size() > 0;
        bl = bl4 && bl2;
        this.removeEntryAction.setEnabled(bl);
        this.addEntryAction.setEnabled(bl2);
        this.addDistListAction.setEnabled(bl2 && this.currentPhonebook.supportsDistributionLists());
        this.entryMenu.setEnabled(bl3);
        this.importMenu.setEnabled(bl2);
        this.exportMenu.setEnabled(bl4 || bl5);
        this.listRemoveAction.setEnabled(bl5);
        this.buttonBrowse.setEnabled(bl5);
        if (this.selectAction != null) {
            this.selectAction.setEnabled(bl4);
        }
        this.exportHTMLAction.setEnabled(bl5);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("descopen")) {
            this.doDescOpen();
        } else if (string.equals("descimport")) {
            this.doDescImport();
        } else if (string.equals("browse")) {
            this.browseForPhonebook();
        } else assert (false);
    }

    private String promptForDescriptor(String string) {
        return JOptionPane.showInputDialog(this, Utils._("Please enter the phone book descriptor to open."), string, 3);
    }

    void doDescOpen() {
        String string = this.promptForDescriptor(Utils._("Open by descriptor"));
        if (string != null) {
            this.addPhoneBook(string);
        }
    }

    void doDescImport() {
        if (this.currentPhonebook == null || this.currentPhonebook.isReadOnly()) {
            return;
        }
        String string = this.promptForDescriptor(Utils._("Import by descriptor"));
        if (string != null) {
            this.importFromPhonebook(null, string);
        }
    }

    protected void importFromPhonebook(PhoneBook phoneBook, String string) {
        block5: {
            try {
                if (phoneBook == null) {
                    phoneBook = PhoneBookFactory.instanceForDescriptor(string, this);
                }
                if (phoneBook == null) {
                    JOptionPane.showMessageDialog(this, Utils._("Unsupported phone book format."), Utils._("Error"), 2);
                    return;
                }
                if (string != null) {
                    phoneBook.open(string);
                    this.currentPhonebook.addEntries(phoneBook.getEntries());
                    phoneBook.close();
                }
            }
            catch (PhoneBookException phoneBookException) {
                if (phoneBookException.messageAlreadyDisplayed()) break block5;
                ExceptionDialog.showExceptionDialog(this, Utils._("Error loading the phone book: "), phoneBookException);
            }
        }
    }

    protected void exportToPhonebook(PhoneBook phoneBook, String string) {
        block8: {
            try {
                if (phoneBook == null) {
                    phoneBook = PhoneBookFactory.instanceForDescriptor(string, this);
                }
                if (phoneBook == null) {
                    JOptionPane.showMessageDialog(this, Utils._("Unsupported phone book format."), Utils._("Error"), 2);
                    return;
                }
                if (string != null) {
                    phoneBook.open(string);
                    if (this.selectedItems.size() > 0) {
                        phoneBook.addEntries(this.selectedItems);
                    } else if (this.currentPhonebook != null) {
                        phoneBook.addEntries(this.currentPhonebook.getEntries());
                    }
                    phoneBook.close();
                }
            }
            catch (PhoneBookException phoneBookException) {
                if (phoneBookException.messageAlreadyDisplayed()) break block8;
                ExceptionDialog.showExceptionDialog(this, Utils._("Error loading the phone book: "), phoneBookException);
            }
        }
    }

    private JComponent createJContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createToolBar(), "North");
        jPanel.add((Component)this.getSplitPane(), "Center");
        this.progressPanel = new ProgressPanel();
        this.progressPanel.setContentComponent(jPanel);
        return this.progressPanel;
    }

    private JToolBar createToolBar() {
        return this.searchHelper.getQuickSearchBar(null, Utils._("Reset quick search and show all phone book entries."), this.searchEntryAction, this.viewPopupMenuAction);
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(1, this.getLeftPane(), this.getRightPane());
            this.splitPane.setDividerLocation(200);
            this.splitPane.setOpaque(true);
        }
        return this.splitPane;
    }

    private JPanel getLeftPane() {
        if (this.leftPane == null) {
            double[][] dArrayArray = new double[][]{{0.5, 5.0, -1.0}, {-1.0, 2.0, -2.0, -2.0, -2.0}};
            this.leftPane = new JPanel(new TableLayout(dArrayArray), false);
            this.treeModel = new PhoneBookTreeModel();
            this.treeModel.addPBTreeModelListener(this.searchHelper);
            this.treeModel.setNameToStringRule(this.nameRule);
            this.treeModel.setComparator(this.sortOrder);
            this.phoneBookTree = new JTree(this.treeModel);
            this.treeModel.setTree(this.phoneBookTree);
            this.phoneBookTree.setEditable(false);
            this.phoneBookTree.setRootVisible(true);
            this.phoneBookTree.getSelectionModel().setSelectionMode(4);
            this.phoneBookTree.setCellRenderer(this.phoneBookRenderer);
            this.phoneBookTree.addTreeSelectionListener(new TreeSelectionListener(){
                private TreePath[] oldSelection = null;

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    try {
                        TreePath[] treePathArray = NewPhoneBookWin.this.phoneBookTree.getSelectionPaths();
                        if (NewPhoneBookWin.treePathsEqual(this.oldSelection, treePathArray)) {
                            return;
                        }
                        NewPhoneBookWin.this.commitCurrentEdits();
                        NewPhoneBookWin.this.selectedItems.clear();
                        NewPhoneBookWin.this.currentPhonebook = null;
                        if (treePathArray != null && treePathArray.length > 0) {
                            PhoneBook phoneBook = null;
                            boolean bl = true;
                            for (TreePath treePath : treePathArray) {
                                if (treePath.getPathCount() > 1) {
                                    if (phoneBook == null) {
                                        phoneBook = (PhoneBook)treePath.getPathComponent(1);
                                    } else {
                                        boolean bl2 = bl = bl && phoneBook == treePath.getPathComponent(1);
                                    }
                                    if (treePath.getPathCount() != 3) continue;
                                    NewPhoneBookWin.this.selectedItems.add((PhoneBookEntry)treePath.getPathComponent(2));
                                    continue;
                                }
                                bl = false;
                            }
                            if (bl) {
                                NewPhoneBookWin.this.currentPhonebook = phoneBook;
                            }
                        }
                        NewPhoneBookWin.this.checkMenuEnable();
                        NewPhoneBookWin.this.writeToTextFields(NewPhoneBookWin.this.currentPhonebook, NewPhoneBookWin.this.selectedItems);
                        if (NewPhoneBookWin.this.currentPhonebook != null) {
                            NewPhoneBookWin.this.textDescriptor.setText(NewPhoneBookWin.this.currentPhonebook.getDescriptor());
                            NewPhoneBookWin.this.textDescriptor.setCaretPosition(0);
                        } else {
                            NewPhoneBookWin.this.textDescriptor.setText("<" + Utils._("Multiple or no phone books selected") + ">");
                        }
                        this.oldSelection = treePathArray;
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog(NewPhoneBookWin.this.phoneBookTree, "", exception);
                    }
                }
            });
            this.phoneBookTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "RemoveEntry");
            this.phoneBookTree.getActionMap().put("RemoveEntry", this.removeEntryAction);
            this.phoneBookTree.setTransferHandler(new TransferHandler(){

                public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                    return Utils.indexOfArray(dataFlavorArray, PBEntryTransferable.PHONEBOOKENTRY_FLAVOR) >= 0;
                }

                protected Transferable createTransferable(JComponent jComponent) {
                    return new PBEntryTransferable(new ArrayList<PhoneBookEntry>(NewPhoneBookWin.this.selectedItems));
                }

                private Object getDropItem() {
                    Point point = NewPhoneBookWin.this.phoneBookTree.getMousePosition();
                    if (point == null) {
                        return null;
                    }
                    int n = NewPhoneBookWin.this.phoneBookTree.getRowForLocation(point.x, point.y);
                    if (n >= 0) {
                        return NewPhoneBookWin.this.phoneBookTree.getPathForRow(n).getLastPathComponent();
                    }
                    return null;
                }

                public int getSourceActions(JComponent jComponent) {
                    return NewPhoneBookWin.this.selectedItems.size() > 0 ? 1 : 0;
                }

                public boolean importData(JComponent jComponent, Transferable transferable) {
                    if (transferable.isDataFlavorSupported(PBEntryTransferable.PHONEBOOKENTRY_FLAVOR)) {
                        try {
                            PhoneBookEntryList phoneBookEntryList;
                            List list = (List)transferable.getTransferData(PBEntryTransferable.PHONEBOOKENTRY_FLAVOR);
                            Object object = this.getDropItem();
                            if (object instanceof PhoneBookEntryList && !(phoneBookEntryList = (PhoneBookEntryList)object).isReadOnly()) {
                                phoneBookEntryList.addEntries(list);
                                if (phoneBookEntryList instanceof DistributionList) {
                                    ((DistributionList)phoneBookEntryList).commit();
                                }
                                return true;
                            }
                            return false;
                        }
                        catch (Exception exception) {
                            log.log(Level.SEVERE, "Error importing drag data", exception);
                            return false;
                        }
                    }
                    return super.importData(jComponent, transferable);
                }
            });
            this.phoneBookTree.setDragEnabled(true);
            this.treePopup = new JPopupMenu();
            this.treePopup.add(new JMenuItem(this.addEntryAction));
            final JMenuItem jMenuItem = new JMenuItem(this.removeEntryAction);
            final JMenuItem jMenuItem2 = new JMenuItem(this.listRemoveAction);
            this.treePopup.add(jMenuItem);
            this.treePopup.add(jMenuItem2);
            this.treePopup.add(new JSeparator());
            JMenu jMenu = new JMenu(this.nameStyleGroup.label);
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.nameStyleGroup.createMenuItems()) {
                jMenu.add(jRadioButtonMenuItem);
            }
            this.treePopup.add(jMenu);
            this.treePopup.addSeparator();
            this.treePopup.add(new JMenuItem(this.searchEntryAction));
            this.treePopup.addSeparator();
            this.treePopup.add(new JMenuItem(this.collapseAllAction));
            this.treePopup.add(new JMenuItem(this.expandAllAction));
            this.treePopup.add(new ActionJCheckBoxMenuItem(this.expandOnLoadAction));
            this.treePopup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    boolean bl = NewPhoneBookWin.this.selectedItems.size() > 0;
                    jMenuItem.setVisible(bl);
                    jMenuItem2.setVisible(!bl);
                }
            });
            this.phoneBookTree.setComponentPopupMenu(this.treePopup);
            JScrollPane jScrollPane = new JScrollPane(this.phoneBookTree);
            JButton jButton = new JButton(this.addEntryAction);
            jButton.setText("");
            JButton jButton2 = new JButton(this.removeEntryAction);
            jButton2.setText("");
            this.leftPane.add((Component)jScrollPane, "0,0,2,0,f,f");
            this.leftPane.add((Component)jButton, "0,2");
            this.leftPane.add((Component)jButton2, "2,2");
        }
        return this.leftPane;
    }

    public JMenu getPhonebookMenu() {
        if (this.pbMenu == null) {
            this.importMenu = new JMenu(Utils._("Import"));
            this.importMenu.setIcon(Utils.loadIcon("general/Import"));
            this.openMenu = new JMenu(Utils._("Add to list"));
            this.openMenu.setIcon(Utils.loadIcon("general/Open"));
            this.exportMenu = new JMenu(Utils._("Export"));
            this.exportMenu.setIcon(Utils.loadIcon("general/Export"));
            for (PhoneBookType phoneBookType : PhoneBookFactory.PhonebookTypes) {
                String string = phoneBookType.getDisplayName();
                PhonebookMenuActionListener phonebookMenuActionListener = new PhonebookMenuActionListener(phoneBookType);
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setActionCommand("pb_import");
                jMenuItem.addActionListener(phonebookMenuActionListener);
                this.importMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(string);
                jMenuItem.setActionCommand("pb_open");
                jMenuItem.addActionListener(phonebookMenuActionListener);
                this.openMenu.add(jMenuItem);
                if (!phoneBookType.canExport()) continue;
                jMenuItem = new JMenuItem(string);
                jMenuItem.setActionCommand("pb_export");
                jMenuItem.addActionListener(phonebookMenuActionListener);
                this.exportMenu.add(jMenuItem);
            }
            Object object = new JMenuItem(Utils._("By descriptor..."));
            ((AbstractButton)object).setActionCommand("descimport");
            ((AbstractButton)object).addActionListener(this);
            this.importMenu.addSeparator();
            this.importMenu.add((JMenuItem)object);
            object = new JMenuItem(Utils._("By descriptor..."));
            ((AbstractButton)object).setActionCommand("descopen");
            ((AbstractButton)object).addActionListener(this);
            this.openMenu.addSeparator();
            this.openMenu.add((JMenuItem)object);
            this.pbMenu = new JMenu(Utils._("Phone book"));
            this.pbMenu.add(this.openMenu);
            this.pbMenu.add(this.importMenu);
            this.pbMenu.add(this.exportMenu);
            this.pbMenu.addSeparator();
            this.pbMenu.add(this.printAction);
            this.pbMenu.add(this.exportHTMLAction);
            this.pbMenu.addSeparator();
            this.pbMenu.add(new JMenuItem(this.listRemoveAction));
            this.pbMenu.addSeparator();
            this.pbMenu.add(new JMenuItem(this.editAcceleratorsAction));
            this.pbMenu.addSeparator();
            this.pbMenu.add(new JMenuItem(this.closeAction));
        }
        return this.pbMenu;
    }

    public JMenu getEntryMenu() {
        if (this.entryMenu == null) {
            this.entryMenu = new JMenu(Utils._("Entry"));
            this.entryMenu.add(new JMenuItem(this.addEntryAction));
            this.entryMenu.add(new JMenuItem(this.addDistListAction));
            this.entryMenu.add(new JMenuItem(this.removeEntryAction));
            this.entryMenu.addSeparator();
            this.entryMenu.add(new JMenuItem(this.searchEntryAction));
        }
        return this.entryMenu;
    }

    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu(Utils._("View"));
            JMenu jMenu = new JMenu(this.nameStyleGroup.label);
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.nameStyleGroup.createMenuItems()) {
                jMenu.add(jRadioButtonMenuItem);
            }
            this.viewMenu.add(jMenu);
            this.viewMenu.addSeparator();
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.viewGroup.createMenuItems()) {
                this.viewMenu.add(jRadioButtonMenuItem);
            }
            this.viewMenu.addSeparator();
            for (JRadioButtonMenuItem jRadioButtonMenuItem : this.sortGroup.createMenuItems()) {
                this.viewMenu.add(jRadioButtonMenuItem);
            }
            this.viewMenu.addSeparator();
            this.viewMenu.add(new JMenuItem(this.collapseAllAction));
            this.viewMenu.add(new JMenuItem(this.expandAllAction));
            this.viewMenu.add(new ActionJCheckBoxMenuItem(this.expandOnLoadAction));
        }
        return this.viewMenu;
    }

    private JMenuBar getMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.getPhonebookMenu());
        jMenuBar.add(this.getViewMenu());
        jMenuBar.add(this.getEntryMenu());
        return jMenuBar;
    }

    private void putAvailableAction(String string, Action action) {
        if (this.availableActions.put(string, action) != null) {
            log.severe("Action " + string + " already existed!");
        }
        action.putValue("ActionCommandKey", string);
    }

    private void putAvailableAction(Action action) {
        String string = (String)action.getValue("ActionCommandKey");
        if (this.availableActions.put(string, action) != null) {
            log.severe("Action " + string + " already existed!");
        }
    }

    public ProgressPanel getProgressPanel() {
        return this.progressPanel;
    }

    private void createActions() {
        this.addEntryAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (NewPhoneBookWin.this.currentPhonebook == null || NewPhoneBookWin.this.currentPhonebook.isReadOnly()) {
                    return;
                }
                PhoneBookEntry phoneBookEntry = NewPhoneBookWin.this.currentPhonebook.addNewEntry();
                NewPhoneBookWin.this.phoneBookTree.setSelectionPath(new TreePath(new Object[]{NewPhoneBookWin.this.treeModel.getRootNode(), NewPhoneBookWin.this.currentPhonebook, phoneBookEntry}));
            }
        };
        this.addEntryAction.putValue("Name", Utils._("Add"));
        this.addEntryAction.putValue("SmallIcon", Utils.loadCustomIcon("pbaddentry.png"));
        this.addEntryAction.putValue("ShortDescription", Utils._("Add new entry"));
        this.addEntryAction.setEnabled(false);
        this.putAvailableAction("AddEntry", this.addEntryAction);
        this.addDistListAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (NewPhoneBookWin.this.currentPhonebook == null || NewPhoneBookWin.this.currentPhonebook.isReadOnly()) {
                    return;
                }
                DistributionList distributionList = NewPhoneBookWin.this.currentPhonebook.addDistributionList();
                if (NewPhoneBookWin.this.selectedItems.size() > 1) {
                    distributionList.addEntries(NewPhoneBookWin.resolveDistributionLists(NewPhoneBookWin.this.selectedItems));
                }
                NewPhoneBookWin.this.phoneBookTree.setSelectionPath(new TreePath(new Object[]{NewPhoneBookWin.this.treeModel.getRootNode(), NewPhoneBookWin.this.currentPhonebook, distributionList}));
            }
        };
        this.addDistListAction.putValue("Name", Utils._("Add distribution list"));
        this.addDistListAction.putValue("SmallIcon", Utils.loadCustomIcon("pbadddistlist.png"));
        this.addDistListAction.putValue("ShortDescription", Utils._("Add a new distribution list"));
        this.addDistListAction.setEnabled(false);
        this.putAvailableAction("AddDistList", this.addDistListAction);
        this.removeEntryAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (NewPhoneBookWin.this.selectedItems.size() == 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(NewPhoneBookWin.this, Utils._("Do you want to delete the selected entries?"), Utils._("Delete entries"), 0) == 0) {
                    PhoneBookEntry[] phoneBookEntryArray;
                    for (PhoneBookEntry phoneBookEntry : phoneBookEntryArray = NewPhoneBookWin.this.selectedItems.toArray(new PhoneBookEntry[NewPhoneBookWin.this.selectedItems.size()])) {
                        NewPhoneBookWin.this.selectedItems.clear();
                        phoneBookEntry.delete();
                    }
                    NewPhoneBookWin.this.selectedItems.clear();
                    NewPhoneBookWin.this.writeToTextFields(null, null);
                }
            }
        };
        this.removeEntryAction.putValue("Name", Utils._("Delete"));
        this.removeEntryAction.putValue("SmallIcon", Utils.loadIcon("general/Delete"));
        this.removeEntryAction.putValue("ShortDescription", Utils._("Delete selected entry"));
        this.removeEntryAction.setEnabled(false);
        this.putAvailableAction("RemoveEntry", this.removeEntryAction);
        this.searchEntryAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (NewPhoneBookWin.this.searchWin == null) {
                    NewPhoneBookWin.this.searchWin = new NewSearchWin(NewPhoneBookWin.this);
                }
                if (NewPhoneBookWin.this.searchWin.isVisible()) {
                    NewPhoneBookWin.this.searchWin.toFront();
                } else {
                    NewPhoneBookWin.this.searchWin.setVisible(true);
                }
            }
        };
        this.searchEntryAction.putValue("Name", Utils._("Find..."));
        this.searchEntryAction.putValue("SmallIcon", Utils.loadIcon("general/Find"));
        this.searchEntryAction.putValue("ShortDescription", Utils._("Search for an entry"));
        this.putAvailableAction("SearchEntry", this.searchEntryAction);
        this.listRemoveAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(NewPhoneBookWin.this, Utils._("Do you want to remove the current phone book from the list?"), Utils._("Remove from list"), 0) == 0) {
                    NewPhoneBookWin.this.closeCurrentPhoneBook();
                }
            }
        };
        this.listRemoveAction.putValue("Name", Utils._("Remove from list"));
        this.listRemoveAction.putValue("SmallIcon", Utils.loadIcon("general/Remove"));
        this.putAvailableAction("ListRemove", this.listRemoveAction);
        this.nameStyleGroup = new MultiButtonGroup(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (NewPhoneBookWin.CUSTOM_NAME_RULE.equals(actionEvent.getActionCommand())) {
                    ConcatRule concatRule = RuleParserDialog.showForRule(NewPhoneBookWin.this, this.label, NameRule.values(), NewPhoneBookWin.this.nameRule);
                    if (concatRule != null) {
                        NewPhoneBookWin.this.nameRule = concatRule;
                        NewPhoneBookWin.this.treeModel.setNameToStringRule(concatRule);
                    } else {
                        NewPhoneBookWin.this.setSelectedNameRule();
                    }
                } else {
                    NewPhoneBookWin.this.nameRule = NameRule.valueOf(actionEvent.getActionCommand());
                    NewPhoneBookWin.this.treeModel.setNameToStringRule(NewPhoneBookWin.this.nameRule);
                }
            }
        };
        this.nameStyleGroup.label = Utils._("Display style");
        for (NameRule nameRule : NameRule.values()) {
            this.putAvailableAction(this.nameStyleGroup.addItem(nameRule.getDisplayName(), nameRule.name()));
        }
        this.putAvailableAction(this.nameStyleGroup.addItem(Utils._("Custom") + "...", CUSTOM_NAME_RULE));
        this.setSelectedNameRule();
        this.viewGroup = new MultiButtonGroup(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (NewPhoneBookWin.SHOWALL_ACTION_COMMAND.equals(string)) {
                    NewPhoneBookWin.this.searchHelper.setUserFilter(null);
                } else if (NewPhoneBookWin.FILTER_ACTION_COMMAND.equals(string)) {
                    CustomFilterDialog<PhoneBookEntry, PBEntryField> customFilterDialog = new CustomFilterDialog<PhoneBookEntry, PBEntryField>(NewPhoneBookWin.this, Utils._("Filter phone book entries"), Utils._("Only display phone book items fulfilling:"), Utils._("You have entered no filtering conditions. Do you want to show all phone book entries instead?"), Utils._("Please enter a valid date/time!"), PBEntryField.filterKeyList, NewPhoneBookWin.this.searchHelper.getUserFilter());
                    customFilterDialog.setVisible(true);
                    if (customFilterDialog.okClicked) {
                        NewPhoneBookWin.this.searchHelper.setUserFilter(customFilterDialog.returnValue);
                    } else if (NewPhoneBookWin.this.searchHelper.getUserFilter() == null) {
                        this.setSelectedActionCommand(NewPhoneBookWin.SHOWALL_ACTION_COMMAND);
                    }
                }
            }
        };
        this.putAvailableAction(this.viewGroup.addItem(Utils._("Show all entries"), SHOWALL_ACTION_COMMAND));
        this.putAvailableAction(this.viewGroup.addItem(Utils._("Filter entries") + "...", FILTER_ACTION_COMMAND));
        this.viewGroup.setSelectedActionCommand(SHOWALL_ACTION_COMMAND);
        this.sortGroup = new MultiButtonGroup(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (NewPhoneBookWin.SORT_CUSTOM_ACTION_COMMAND.equals(string)) {
                    SortOrder sortOrder = SortOrderDialog.showForSortOrder(NewPhoneBookWin.this, NewPhoneBookWin.this.sortOrder);
                    if (sortOrder != null) {
                        NewPhoneBookWin.this.sortOrder = sortOrder;
                        NewPhoneBookWin.this.treeModel.setComparator(sortOrder);
                    } else {
                        NewPhoneBookWin.this.setSelectedSortOrder();
                    }
                } else if (NewPhoneBookWin.SORT_DEFAULT_ACTION_COMMAND.equals(string)) {
                    NewPhoneBookWin.this.sortOrder = null;
                    NewPhoneBookWin.this.treeModel.setComparator(null);
                }
            }
        };
        this.putAvailableAction(this.sortGroup.addItem(Utils._("Default sort order"), SORT_DEFAULT_ACTION_COMMAND));
        this.putAvailableAction(this.sortGroup.addItem(Utils._("Custom sort order") + "...", SORT_CUSTOM_ACTION_COMMAND));
        this.setSelectedSortOrder();
        this.viewPopupMenuAction = new ExcDialogAbstractAction(){
            private JPopupMenu popup;

            private JPopupMenu getPopup() {
                if (this.popup == null) {
                    this.popup = new JPopupMenu();
                    for (JRadioButtonMenuItem jRadioButtonMenuItem : NewPhoneBookWin.this.viewGroup.createMenuItems()) {
                        this.popup.add(jRadioButtonMenuItem);
                    }
                }
                return this.popup;
            }

            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof Component) {
                    Component component = (Component)actionEvent.getSource();
                    this.getPopup().show(component, 0, component.getHeight());
                }
            }
        };
        this.viewPopupMenuAction.putValue("SmallIcon", Utils.loadCustomIcon("filter.png"));
        this.viewPopupMenuAction.putValue("ShortDescription", Utils._("Filter phone book items"));
        this.printAction = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                PhonebooksPrinter.printPhonebooks(NewPhoneBookWin.this, NewPhoneBookWin.this.treeModel.getPhoneBooks(), NewPhoneBookWin.this.currentPhonebook, NewPhoneBookWin.this.selectedItems, NewPhoneBookWin.this.treeModel.isShowingFilteredResults());
            }
        };
        this.printAction.putValue("Name", Utils._("Print phone books") + "...");
        this.printAction.putValue("SmallIcon", Utils.loadIcon("general/Print"));
        this.putAvailableAction("Print", this.printAction);
        this.exportHTMLAction = new ExcDialogAbstractAction(){
            private JFileChooser fileChooser;

            private JFileChooser getFileChooser() {
                if (this.fileChooser == null) {
                    this.fileChooser = new SafeJFileChooser();
                    this.fileChooser.setAcceptAllFileFilterUsed(false);
                    this.fileChooser.addChoosableFileFilter(new ExampleFileFilter(FileFormat.HTML.getPossibleExtensions(), FileFormat.HTML.getDescription()));
                    if (Utils.getFaxOptions().lastExportSavePath != null) {
                        this.fileChooser.setCurrentDirectory(new File(Utils.getFaxOptions().lastExportSavePath));
                    }
                }
                return this.fileChooser;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void actualActionPerformed(ActionEvent actionEvent) {
                if (NewPhoneBookWin.this.currentPhonebook == null) {
                    return;
                }
                JFileChooser jFileChooser = this.getFileChooser();
                if (jFileChooser.showSaveDialog(NewPhoneBookWin.this) != 0) {
                    return;
                }
                Utils.setWaitCursor(null);
                try {
                    Utils.getFaxOptions().lastExportSavePath = jFileChooser.getCurrentDirectory().getAbsolutePath();
                    File file = Utils.getSelectedFileFromSaveChooser(jFileChooser);
                    this.exportPhonebookToHTML(NewPhoneBookWin.this, NewPhoneBookWin.this.currentPhonebook, file);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog(NewPhoneBookWin.this, Utils._("Error saving the table:"), exception);
                }
                finally {
                    Utils.unsetWaitCursor(null);
                }
            }

            private void exportPhonebookToHTML(final Dialog dialog, final PhoneBook phoneBook, final File file) {
                Utils.setWaitCursor(null);
                ProgressWorker progressWorker = new ProgressWorker(){

                    protected void initialize() {
                        this.progressMonitor = NewPhoneBookWin.this.progressPanel;
                    }

                    public void doWork() {
                        try {
                            this.updateNote(Utils._("Exporting..."));
                            String string = phoneBook.toString();
                            String string2 = "";
                            PhoneBookHTMLExporter phoneBookHTMLExporter = new PhoneBookHTMLExporter();
                            phoneBookHTMLExporter.saveToFile(file, new PBEntryFieldTableModel(Collections.unmodifiableList(phoneBook.getEntries())), string, string2);
                        }
                        catch (Exception exception) {
                            ExceptionDialog.showExceptionDialog(dialog, Utils._("Error saving the table:"), exception);
                        }
                    }

                    protected void done() {
                        Utils.unsetWaitCursor(null);
                    }
                };
                progressWorker.startWork(dialog, Utils._("Export to HTML"));
            }
        };
        this.exportHTMLAction.putValue("Name", Utils._("Save as HTML") + "...");
        this.exportHTMLAction.putValue("SmallIcon", Utils.loadIcon("general/Save"));
        this.putAvailableAction("ExportHTML", this.exportHTMLAction);
        this.closeAction = new ExcDialogAbstractAction(){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                NewPhoneBookWin.this.usedSelectButton = false;
                NewPhoneBookWin.this.closeAndSaveAllPhonebooks(true);
            }
        };
        this.closeAction.putValue("Name", Utils._("Close"));
        this.closeAction.putValue("SmallIcon", Utils.loadCustomIcon("close.gif"));
        this.putAvailableAction("Close", this.closeAction);
        this.editAcceleratorsAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                AcceleratorKeyDialog acceleratorKeyDialog = new AcceleratorKeyDialog((Dialog)NewPhoneBookWin.this, NewPhoneBookWin.this.availableActions.values(), AcceleratorKeys.DEFAULT_PBWIN_MAPPING);
                acceleratorKeyDialog.setVisible(true);
                if (acceleratorKeyDialog.modalResult) {
                    AcceleratorKeys.saveToMap(Utils.getFaxOptions().pbwinKeyboardAccelerators, NewPhoneBookWin.this.availableActions);
                }
            }
        };
        this.editAcceleratorsAction.putValue("Name", Utils._("Edit keyboard shortcuts") + "...");
        this.editAcceleratorsAction.putValue("ShortDescription", Utils._("Customize the keyboard shortcuts"));
        this.putAvailableAction("EditAccelerators", this.editAcceleratorsAction);
        this.expandAllAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                NewPhoneBookWin.this.expandAllPhonebooks();
            }
        };
        this.expandAllAction.putValue("Name", Utils._("Expand all"));
        this.expandAllAction.putValue("ShortDescription", Utils._("Expand all phone books"));
        this.expandAllAction.putValue("SmallIcon", Utils.loadCustomIcon("expandAll.png"));
        this.putAvailableAction("ExpandAll", this.expandAllAction);
        this.collapseAllAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                NewPhoneBookWin.this.collapseAllPhonebooks();
            }
        };
        this.collapseAllAction.putValue("Name", Utils._("Collapse all"));
        this.collapseAllAction.putValue("ShortDescription", Utils._("Collapse all phone books"));
        this.collapseAllAction.putValue("SmallIcon", Utils.loadCustomIcon("collapseAll.png"));
        this.putAvailableAction("CollapseAll", this.collapseAllAction);
        this.expandOnLoadAction = new ExcDialogAbstractAction(){

            public void actualActionPerformed(ActionEvent actionEvent) {
                Boolean bl = (Boolean)this.getValue("selected");
                boolean bl2 = bl == null ? true : bl == false;
                Utils.getFaxOptions().expandPhoneBooksOnLoad = bl2;
                this.putValue("selected", bl2);
            }
        };
        this.expandOnLoadAction.putValue("Name", Utils._("Expand on load"));
        this.expandOnLoadAction.putValue("ShortDescription", Utils._("Expand all phone books when dialog is opened"));
        this.expandOnLoadAction.putValue("selected", Utils.getFaxOptions().expandPhoneBooksOnLoad);
        this.putAvailableAction("ExpandOnLoad", this.expandOnLoadAction);
    }

    void setSelectedSortOrder() {
        this.sortGroup.setSelectedActionCommand(this.sortOrder == null ? SORT_DEFAULT_ACTION_COMMAND : SORT_CUSTOM_ACTION_COMMAND);
    }

    void setSelectedNameRule() {
        String string = this.nameRule instanceof NameRule ? ((NameRule)this.nameRule).name() : CUSTOM_NAME_RULE;
        this.nameStyleGroup.setSelectedActionCommand(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        FaxOptions faxOptions = Utils.getFaxOptions();
        this.nameRule = RuleSerializer.stringToRule(faxOptions.phonebookDisplayStyle, NameRule.class, NameRule.GIVENNAME_NAME);
        if (faxOptions.phonebookSortOrder != null && faxOptions.phonebookSortOrder.length() > 0) {
            try {
                this.sortOrder = SortOrder.deserialize(faxOptions.phonebookSortOrder);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Invalid sort order found: " + faxOptions.phonebookSortOrder, exception);
                this.sortOrder = null;
            }
        } else {
            this.sortOrder = null;
        }
        this.createActions();
        this.setContentPane(this.createJContentPane());
        this.setJMenuBar(this.getMenu());
        this.setDefaultCloseOperation(0);
        this.setTitle(Utils._("Phone book"));
        this.addWindowListener(new WindowAdapter(){
            private boolean saved = false;

            public void windowClosed(WindowEvent windowEvent) {
                if (!this.saved) {
                    this.savePhonebooks();
                }
                FaxOptions faxOptions = Utils.getFaxOptions();
                faxOptions.phoneWinBounds = NewPhoneBookWin.this.getBounds();
                faxOptions.phonebookDisplayStyle = RuleSerializer.ruleToString(NewPhoneBookWin.this.nameRule, NameRule.class);
                String string = faxOptions.phonebookSortOrder = NewPhoneBookWin.this.sortOrder == null ? "" : NewPhoneBookWin.this.sortOrder.serialize();
                if (NewPhoneBookWin.this.searchWin != null) {
                    NewPhoneBookWin.this.searchWin.dispose();
                    NewPhoneBookWin.this.searchWin = null;
                }
            }

            private void savePhonebooks() {
                try {
                    NewPhoneBookWin.this.closeAndSaveAllPhonebooks(true);
                    this.saved = true;
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog(NewPhoneBookWin.this, Utils._("Error closing the phone books:"), exception);
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                this.savePhonebooks();
            }
        });
        AcceleratorKeys.loadFromMap(faxOptions.pbwinKeyboardAccelerators, this.availableActions);
        if (faxOptions.phoneWinBounds != null) {
            this.setBounds(faxOptions.phoneWinBounds);
        } else {
            this.setSize(640, 480);
            Utils.setDefWinPos(this);
        }
        Object[] objectArray = faxOptions.phoneBooks;
        synchronized (faxOptions.phoneBooks) {
            Object[] objectArray2 = faxOptions.phoneBooks.toArray(new String[faxOptions.phoneBooks.size()]);
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (objectArray2.length > 0) {
                if (Utils.debugMode) {
                    log.finest("Phonebooks found: " + Arrays.toString(objectArray2));
                }
                Arrays.sort(objectArray2);
                for (Object object : objectArray2) {
                    if (Utils.debugMode) {
                        log.finest("Adding phone book: " + (String)object);
                    }
                    this.allowSavePhonebooks = false;
                    this.addPhoneBook((String)object);
                }
            } else {
                log.finest("No phonebooks found.");
                this.addPhoneBook(PhoneBookFactory.getDefaultPhonebookDescriptor());
            }
            for (PluginUI pluginUI : PluginManager.pluginUIs) {
                try {
                    pluginUI.configurePhoneBookWin(this);
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Error initializing plugin " + pluginUI, exception);
                }
            }
            this.checkMenuEnable();
            return;
        }
    }

    public NewPhoneBookWin(Dialog dialog) {
        super(dialog);
        this.initialize();
    }

    public NewPhoneBookWin(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void showSelectButton() {
        if (this.selectAction == null) {
            this.selectAction = new ExcDialogAbstractAction(){

                public void actualActionPerformed(ActionEvent actionEvent) {
                    if (NewPhoneBookWin.this.selectedItems.size() == 0) {
                        return;
                    }
                    NewPhoneBookWin.this.usedSelectButton = true;
                    NewPhoneBookWin.this.setVisible(false);
                }
            };
            this.selectAction.putValue("Name", Utils._("Select"));
            this.selectAction.putValue("SmallIcon", Utils.loadIcon("general/Undo"));
            this.selectAction.setEnabled(false);
            JButton jButton = new JButton(this.selectAction);
            this.leftPane.add(Box.createVerticalStrut(5), "0,3");
            this.leftPane.add((Component)jButton, "0,4,2,4");
            this.entryMenu.addSeparator();
            this.entryMenu.add(new JMenuItem(this.selectAction));
            this.treePopup.addSeparator();
            this.treePopup.add(new JMenuItem(this.selectAction));
            this.phoneBookTree.getActionMap().put("selectEntry", this.selectAction);
            this.phoneBookTree.getInputMap().put(KeyStroke.getKeyStroke('\n'), "selectEntry");
            this.phoneBookTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        NewPhoneBookWin.this.selectAction.actionPerformed(null);
                    }
                }
            });
        }
    }

    public List<PhoneBookEntry> selectNumbers() {
        this.usedSelectButton = false;
        this.setModal(true);
        this.showSelectButton();
        this.setVisible(true);
        if (this.usedSelectButton && this.selectedItems.size() > 0) {
            List<PhoneBookEntry> list = NewPhoneBookWin.resolveDistributionLists(this.selectedItems);
            this.dispose();
            return list;
        }
        return null;
    }

    void commitCurrentEdits() {
        if (this.selectedItems.size() == 1) {
            this.readFromTextFields(this.selectedItems.get(0), false);
        }
    }

    protected void expandAllPhonebooks() {
        for (PhoneBook phoneBook : this.treeModel.getPhoneBooks()) {
            if (Utils.debugMode) {
                log.finest("Expanding tree node for phone book " + phoneBook.getDescriptor());
            }
            this.phoneBookTree.expandPath(new TreePath(new Object[]{this.treeModel.getRootNode(), phoneBook}));
        }
    }

    protected void collapseAllPhonebooks() {
        for (PhoneBook phoneBook : this.treeModel.getPhoneBooks()) {
            if (Utils.debugMode) {
                log.finest("Collapsing tree node for phone book " + phoneBook.getDescriptor());
            }
            this.phoneBookTree.collapsePath(new TreePath(new Object[]{this.treeModel.getRootNode(), phoneBook}));
        }
    }

    static List<PhoneBookEntry> resolveDistributionLists(List<PhoneBookEntry> list) {
        ArrayList<PhoneBookEntry> arrayList = new ArrayList<PhoneBookEntry>(list.size() + 20);
        for (PhoneBookEntry phoneBookEntry : list) {
            if (phoneBookEntry instanceof DistributionList) {
                arrayList.addAll(((DistributionList)phoneBookEntry).getEntries());
                continue;
            }
            arrayList.add(phoneBookEntry);
        }
        return arrayList;
    }

    protected static boolean treePathsEqual(TreePath[] treePathArray, TreePath[] treePathArray2) {
        if (treePathArray == treePathArray2) {
            return true;
        }
        if (treePathArray == null || treePathArray2 == null) {
            return false;
        }
        int n = treePathArray.length;
        if (n != treePathArray2.length) {
            return false;
        }
        if (Arrays.equals(treePathArray, treePathArray2)) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (blArray[j] || !treePathArray[i].equals(treePathArray2[j])) continue;
                bl = true;
                blArray[j] = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    class PBOpenWorker
    extends ProgressWorker {
        protected PhoneBook phoneBook = null;
        protected String descriptor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doWork() {
            block9: {
                NewPhoneBookWin newPhoneBookWin = NewPhoneBookWin.this;
                synchronized (newPhoneBookWin) {
                    if (NewPhoneBookWin.this.openCounter++ == 0) {
                        this.updateNote(Utils._("Loading..."));
                    }
                }
                try {
                    if (Utils.debugMode) {
                        log.fine("Opening phone book " + this.descriptor);
                    }
                    this.phoneBook = PhoneBookFactory.instanceForDescriptor(this.descriptor, NewPhoneBookWin.this);
                    if (this.phoneBook == null) {
                        this.showMessageDialog(Utils._("Unknown phone book type selected."), Utils._("Error"), 0);
                        log.info("Unknown phone book type selected.");
                        return;
                    }
                    this.phoneBook.open(this.descriptor);
                    if (Utils.debugMode) {
                        log.fine("Successfully opened phone book " + this.descriptor);
                    }
                }
                catch (PhoneBookException phoneBookException) {
                    if (phoneBookException.messageAlreadyDisplayed()) break block9;
                    this.showExceptionDialog(Utils._("Error loading the phone book: "), phoneBookException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            if (this.phoneBook != null) {
                NewPhoneBookWin.this.treeModel.addPhoneBook(this.phoneBook);
                if (Utils.debugMode) {
                    log.fine("Added phone book to tree: " + this.descriptor);
                }
            }
            NewPhoneBookWin newPhoneBookWin = NewPhoneBookWin.this;
            synchronized (newPhoneBookWin) {
                if (--NewPhoneBookWin.this.openCounter == 0) {
                    NewPhoneBookWin.this.treeModel.sortPhonebooks();
                    if (Utils.getFaxOptions().expandPhoneBooksOnLoad) {
                        NewPhoneBookWin.this.expandAllPhonebooks();
                    }
                    if (NewPhoneBookWin.this.phoneBookTree.getSelectionPath() == null) {
                        NewPhoneBookWin.this.phoneBookTree.setSelectionRow(1);
                    }
                    this.progressMonitor.close();
                    NewPhoneBookWin.this.allowSavePhonebooks = true;
                }
            }
        }

        public PBOpenWorker(String string) {
            this.descriptor = string;
            this.closeOnExit = false;
            this.progressMonitor = NewPhoneBookWin.this.progressPanel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PBEntryTransferable
    implements Transferable {
        public static final DataFlavor PHONEBOOKENTRY_FLAVOR = new DataFlavor(List.class, "Phone book entries");
        protected final List<PhoneBookEntry> items;

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == PHONEBOOKENTRY_FLAVOR) {
                return this.items;
            }
            if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                return Utils.listToString(this.items, "\n");
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PHONEBOOKENTRY_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == PHONEBOOKENTRY_FLAVOR || DataFlavor.stringFlavor.equals(dataFlavor);
        }

        public PBEntryTransferable(List<PhoneBookEntry> list) {
            this.items = list;
        }
    }

    private class PhonebookMenuActionListener
    implements ActionListener {
        public static final String IMPORT_COMMAND = "pb_import";
        public static final String EXPORT_COMMAND = "pb_export";
        public static final String OPEN_COMMAND = "pb_open";
        public PhoneBookType pbType;

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = actionEvent.getActionCommand();
                if (string.equals(OPEN_COMMAND)) {
                    this.doOpen();
                } else if (string.equals(EXPORT_COMMAND)) {
                    this.doExport();
                } else if (string.equals(IMPORT_COMMAND)) {
                    this.doImport();
                } else {
                    log.log(Level.WARNING, "Unknown Action command: " + string);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog(NewPhoneBookWin.this, Utils._("Error executing the desired action:"), exception);
            }
        }

        private void doImport() {
            if (NewPhoneBookWin.this.currentPhonebook == null || NewPhoneBookWin.this.currentPhonebook.isReadOnly()) {
                return;
            }
            PhoneBook phoneBook = this.pbType.createInstance(NewPhoneBookWin.this);
            String string = phoneBook.browseForPhoneBook(false);
            if (string != null) {
                NewPhoneBookWin.this.importFromPhonebook(phoneBook, string);
            }
        }

        private void doExport() {
            if (NewPhoneBookWin.this.selectedItems.size() == 0 && NewPhoneBookWin.this.currentPhonebook == null) {
                return;
            }
            PhoneBook phoneBook = this.pbType.createInstance(NewPhoneBookWin.this);
            String string = phoneBook.browseForPhoneBook(true);
            if (string != null) {
                NewPhoneBookWin.this.exportToPhonebook(phoneBook, string);
            }
        }

        private void doOpen() {
            PhoneBook phoneBook;
            String string;
            if (Utils.debugMode) {
                log.fine("Opening new phone book of type " + this.pbType);
            }
            if ((string = (phoneBook = this.pbType.createInstance(NewPhoneBookWin.this)).browseForPhoneBook(false)) != null) {
                if (Utils.debugMode) {
                    log.fine("Adding phone book " + string);
                }
                NewPhoneBookWin.this.addPhoneBook(string);
            }
        }

        public PhonebookMenuActionListener(PhoneBookType phoneBookType) {
            this.pbType = phoneBookType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SearchHelper
    extends AbstractQuickSearchHelper
    implements PhoneBookTreeModel.PBTreeModelListener {
        protected Filter<PhoneBookEntry, PBEntryField> quickSearchFilter;
        protected Filter<PhoneBookEntry, PBEntryField> userFilter;

        SearchHelper() {
        }

        public void setUserFilter(Filter<PhoneBookEntry, PBEntryField> filter) {
            this.userFilter = filter;
            this.refreshFilter();
        }

        public Filter<PhoneBookEntry, PBEntryField> getUserFilter() {
            return this.userFilter;
        }

        public Filter<PhoneBookEntry, PBEntryField> createQuickSearchFilter(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            OrFilter<PhoneBookEntry, PBEntryField> orFilter = new OrFilter<PhoneBookEntry, PBEntryField>();
            orFilter.addChild(new ConcatStringFilter(PBEntryField.class, new Object[]{PBEntryField.GivenName, " ", PBEntryField.Name, ", ", PBEntryField.Department, ", ", PBEntryField.Company}, StringFilterOperator.CONTAINS, string, false));
            orFilter.addChild(new StringFilter(PBEntryField.FaxNumber, StringFilterOperator.CONTAINS, string, false));
            return orFilter;
        }

        private void refreshFilter() {
            if (this.quickSearchFilter == null) {
                NewPhoneBookWin.this.treeModel.applyFilter(this.userFilter);
            } else if (this.userFilter == null) {
                NewPhoneBookWin.this.treeModel.applyFilter(this.quickSearchFilter);
            } else {
                NewPhoneBookWin.this.treeModel.applyFilter(new AndFilter<PhoneBookEntry, PBEntryField>(this.userFilter, this.quickSearchFilter));
            }
        }

        @Override
        protected void performActualQuickSearch() {
            this.quickSearchFilter = this.createQuickSearchFilter(this.textQuickSearch.getText());
            this.refreshFilter();
        }

        @Override
        public void filterWasReset() {
            this.eventLock = true;
            this.textQuickSearch.setText("");
            this.clearQuickSearchButton.setEnabled(false);
            NewPhoneBookWin.this.viewGroup.setSelectedActionCommand(NewPhoneBookWin.SHOWALL_ACTION_COMMAND);
            this.userFilter = null;
            this.quickSearchFilter = null;
            this.eventLock = false;
        }

        @Override
        protected Component getFocusComponent() {
            return NewPhoneBookWin.this.phoneBookTree;
        }
    }

    public static class PhoneBookRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon allPhoneBooksIcon = Utils.loadIcon("general/Bookmarks");
        private ImageIcon phoneBookIcon = Utils.loadCustomIcon("phonebook.png");
        private ImageIcon entryIcon = Utils.loadCustomIcon("pbentry.png");
        private ImageIcon distlistIcon = Utils.loadCustomIcon("pbdistlist.png");

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DistributionList) {
                this.setIcon(this.distlistIcon);
            } else if (object instanceof PhoneBookTreeModel.RootNode) {
                this.setIcon(this.allPhoneBooksIcon);
            }
            return this;
        }

        public PhoneBookRenderer() {
            this.setLeafIcon(this.entryIcon);
            this.setOpenIcon(this.phoneBookIcon);
            this.setClosedIcon(this.phoneBookIcon);
        }
    }
}

