/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.phonebook.xml;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yajhfc.phonebook.PBEntryField;
import yajhfc.phonebook.PhoneBook;
import yajhfc.phonebook.SimplePhoneBookEntry;
import yajhfc.phonebook.xml.XMLPhoneBook;
import yajhfc.phonebook.xml.XMLPhoneBookEntry;

public class SingleXMLPhoneBookEntry
extends SimplePhoneBookEntry
implements XMLPhoneBookEntry {
    private static final Logger log = Logger.getLogger(SingleXMLPhoneBookEntry.class.getName());
    private XMLPhoneBook parent;

    public SingleXMLPhoneBookEntry(XMLPhoneBook xMLPhoneBook) {
        this.parent = xMLPhoneBook;
    }

    public void commit() {
        if (this.isDirty()) {
            this.parent.writeEntry(this);
            this.setDirty(false);
        }
    }

    public void delete() {
        this.parent.deleteEntry(this);
    }

    public void saveToXML(Element element, Document document) {
        for (PBEntryField pBEntryField : PBEntryField.values()) {
            try {
                String string = this.getField(pBEntryField);
                if (string == null || string.length() == 0) continue;
                Element element2 = document.createElement(pBEntryField.getKey());
                element2.setTextContent(string);
                element.appendChild(element2);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error writing element " + pBEntryField + ": ", exception);
            }
        }
    }

    public void loadFromXML(Element element) {
        NodeList nodeList = element.getChildNodes();
        Map<String, PBEntryField> map = PBEntryField.getKeyToFieldMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            try {
                PBEntryField pBEntryField = map.get(node.getNodeName());
                if (pBEntryField == null) {
                    log.warning("Unknown field: " + node.getNodeName());
                    continue;
                }
                this.setFieldUndirty(pBEntryField, node.getTextContent());
                continue;
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error reading element " + node.getNodeName() + ": ", exception);
            }
        }
        this.setDirty(false);
    }

    public PhoneBook getParent() {
        return this.parent;
    }
}

