/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.customprops.EntryPoint;
import yajhfc.plugin.PluginClassLoader;
import yajhfc.plugin.PluginType;
import yajhfc.plugin.PluginUI;
import yajhfc.util.TransactFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    public static final int STARTUP_MODE_NORMAL = 0;
    public static final int STARTUP_MODE_NO_GUI = 1;
    public static final int STARTUP_MODE_SEND_ONLY = 2;
    public static final int STARTUP_MODE_LOAD_WHILE_RUNNING = 3;
    public static final int STARTUP_MODE_CONSOLE = 4;
    private static final Logger log = Logger.getLogger(PluginManager.class.getName());
    public static final List<Class<?>> internalPlugins = new ArrayList();
    public static final String INITCLASS_KEY = "YajHFC-Plugin-InitClass";
    public static final List<PluginUI> pluginUIs;
    private static final Map<File, PluginInfo> knownPlugins;
    public static PluginClassLoader pluginClassLoader;
    protected static final Set<String> registeredDrivers;

    public static Collection<PluginInfo> getKnownPlugins() {
        return knownPlugins.values();
    }

    public static void addPlugins(Collection<? extends PluginInfo> collection) {
        for (PluginInfo pluginInfo : collection) {
            knownPlugins.put(pluginInfo.file, pluginInfo);
        }
    }

    public static boolean addPlugin(PluginInfo pluginInfo, boolean bl) {
        PluginInfo pluginInfo2 = knownPlugins.put(pluginInfo.file, pluginInfo);
        if (pluginInfo2 != null && pluginInfo2.loaded) {
            pluginInfo.loaded = true;
            return true;
        }
        if (bl) {
            try {
                switch (pluginInfo.type) {
                    case JDBCDRIVER: {
                        PluginManager.addJARToClassPath(pluginInfo.file);
                        pluginInfo.loaded = true;
                        return true;
                    }
                    case PLUGIN: {
                        pluginInfo.initClass = PluginManager.loadInitClass(pluginInfo.file, true);
                        if (pluginInfo.initClass != null) {
                            pluginInfo.loaded = PluginManager.initializePluginClass(pluginInfo.file, pluginInfo.initClass, 3);
                            return pluginInfo.loaded;
                        }
                        pluginInfo.loaded = false;
                        return false;
                    }
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Can not load plugin " + pluginInfo.file, iOException);
            }
            return false;
        }
        return true;
    }

    public static boolean updatePluginList(Collection<? extends PluginInfo> collection) {
        PluginInfo pluginInfo;
        HashSet<File> hashSet = new HashSet<File>(knownPlugins.keySet());
        boolean bl = false;
        boolean bl2 = false;
        for (PluginInfo object : collection) {
            hashSet.remove(object.file);
            pluginInfo = knownPlugins.get(object.file);
            if (pluginInfo != null) {
                object.loaded = pluginInfo.loaded;
            }
            if (pluginInfo != null && pluginInfo.equals(object)) continue;
            knownPlugins.put(object.file, object);
            if (!object.loaded) {
                switch (object.type) {
                    case JDBCDRIVER: {
                        try {
                            PluginManager.addJARToClassPath(object.file);
                            object.loaded = true;
                        }
                        catch (Exception exception) {
                            log.log(Level.WARNING, "Could not load driver", exception);
                            object.loaded = false;
                        }
                        break;
                    }
                    case PLUGIN: {
                        bl2 = true;
                    }
                }
            }
            bl = true;
        }
        for (File file : hashSet) {
            pluginInfo = knownPlugins.get(file);
            if (pluginInfo.loaded) {
                bl2 = true;
                pluginInfo.persistent = false;
            } else {
                knownPlugins.remove(file);
            }
            bl = true;
        }
        if (bl) {
            try {
                PluginManager.writePluginList();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Could not save plugin list:", iOException);
            }
        }
        return bl2;
    }

    public static void writePluginList() throws IOException {
        PluginManager.writePluginList(new File(Utils.getConfigDir(), "plugin.lst"));
    }

    public static void writePluginList(File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new TransactFileOutputStream(file)));
        bufferedWriter.write("# This file contains the list of plugins and JDBC drivers loaded by YajHFC on startup.\n");
        bufferedWriter.write("# Format: One file name per line, a prefix of \":jdbcdriver:\" denotes a JDBC driver.\n");
        bufferedWriter.write("# \n");
        for (PluginInfo pluginInfo : knownPlugins.values()) {
            if (!pluginInfo.persistent) continue;
            switch (pluginInfo.type) {
                case JDBCDRIVER: {
                    bufferedWriter.write(":jdbcdriver:" + pluginInfo.file.getPath() + "\n");
                    break;
                }
                case PLUGIN: {
                    bufferedWriter.write(pluginInfo.file.getPath() + "\n");
                }
            }
        }
        ((Writer)bufferedWriter).close();
    }

    public static boolean isValidPlugin(File file) {
        try {
            String string = PluginManager.extractInitClassName(file);
            if (string == null) {
                return false;
            }
            PluginClassLoader pluginClassLoader = new PluginClassLoader(new URL[]{file.toURI().toURL()});
            pluginClassLoader.loadClass(string);
            return true;
        }
        catch (Exception exception) {
            log.log(Level.FINE, "Exception testing plugin for validity:", exception);
            return false;
        }
    }

    private static Class<?> loadInitClass(File file, boolean bl) throws IOException {
        String string = PluginManager.extractInitClassName(file);
        if (string == null) {
            log.log(Level.WARNING, file.toString() + " is not a valid YajHFC Plugin.");
            return null;
        }
        try {
            if (Utils.debugMode) {
                log.info("Loading class " + string + " from file " + file);
            }
            if (bl) {
                PluginManager.addJARToClassPath(file);
            }
            return Class.forName(string, true, pluginClassLoader);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Could not initialize plugin " + file + ":", exception);
            return null;
        }
    }

    private static boolean initializePluginClass(File file, Class<?> clazz, int n) {
        try {
            Object[] objectArray;
            Method method;
            if (Utils.debugMode) {
                log.fine("Initializing " + clazz + " from plugin jar " + file);
            }
            try {
                method = clazz.getMethod("init", Integer.TYPE);
                objectArray = new Object[]{n};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (Utils.debugMode) {
                    log.log(Level.FINER, "init(int) not found, trying init()...", noSuchMethodException);
                }
                method = clazz.getMethod("init", new Class[0]);
                objectArray = null;
            }
            Object object = method.invoke(null, objectArray);
            if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) {
                log.log(Level.WARNING, "Initialization of plugin class " + clazz + " (from " + file + ") failed.");
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Could not initialize plugin class " + clazz + " (from " + file + "):", exception);
            return false;
        }
    }

    private static String extractInitClassName(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        String string = manifest.getMainAttributes().getValue(INITCLASS_KEY);
        jarFile.close();
        return string;
    }

    private static void addJARToClassPath(File file) throws MalformedURLException {
        if (pluginClassLoader == null) {
            pluginClassLoader = new PluginClassLoader(new URL[]{file.toURI().toURL()});
        } else {
            pluginClassLoader.addURL(file.toURI().toURL());
        }
    }

    public static void readPluginList() {
        File file = new File(Utils.getApplicationDir(), "plugin.lst");
        if (file.canRead()) {
            PluginManager.readPluginList(file);
        }
        if ((file = new File(Utils.getConfigDir(), "plugin.lst")).canRead()) {
            PluginManager.readPluginList(file);
        }
    }

    public static void readPluginList(File file) {
        try {
            log.fine("Reading plugin list from " + file);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                if ((string = string.trim()).length() > 0 && !string.startsWith("#")) {
                    boolean bl = string.startsWith(":jdbcdriver:");
                    String string2 = bl ? string.substring(":jdbcdriver:".length()) : string;
                    File file2 = new File(string2);
                    if (!file2.canRead() && !file2.isAbsolute()) {
                        file2 = new File(file.getParentFile(), string2);
                    }
                    if (file2.canRead()) {
                        knownPlugins.put(file2, new PluginInfo(file2, bl ? PluginType.JDBCDRIVER : PluginType.PLUGIN, true));
                    } else {
                        log.warning("Can not find (plugin) JAR file " + string);
                    }
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error reading plugin list:", exception);
        }
    }

    public static void loadAllKnownPlugins() {
        log.fine("Loading all plugins...");
        if (knownPlugins.size() == 0) {
            return;
        }
        if (pluginClassLoader != null) {
            log.warning("In loadAllKnownPlugins(): Class loader already exists!");
        }
        URL[] uRLArray = new URL[knownPlugins.size()];
        int n = 0;
        for (File object : knownPlugins.keySet()) {
            try {
                uRLArray[n++] = object.toURI().toURL();
            }
            catch (MalformedURLException iOException) {
                log.log(Level.WARNING, "Can not convert file to URL (File: " + object + ")", iOException);
            }
        }
        pluginClassLoader = new PluginClassLoader(uRLArray);
        for (PluginInfo pluginInfo : knownPlugins.values()) {
            try {
                switch (pluginInfo.type) {
                    case JDBCDRIVER: {
                        pluginInfo.loaded = true;
                        break;
                    }
                    case PLUGIN: {
                        pluginInfo.initClass = PluginManager.loadInitClass(pluginInfo.file, false);
                    }
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Can not load plugin " + pluginInfo.file, iOException);
            }
        }
    }

    public static void initializeAllKnownPlugins(int n) {
        log.fine("Initializing all plugins...");
        for (Class<?> object : internalPlugins) {
            PluginManager.initializePluginClass(null, object, n);
        }
        for (PluginInfo pluginInfo : knownPlugins.values()) {
            if (pluginInfo.initClass == null) continue;
            pluginInfo.loaded = PluginManager.initializePluginClass(pluginInfo.file, pluginInfo.initClass, n);
        }
    }

    public static void registerJDBCDriver(String string) throws ClassNotFoundException {
        if (registeredDrivers.contains(string)) {
            return;
        }
        Class<?> clazz = Class.forName(string, true, pluginClassLoader == null ? PluginManager.class.getClassLoader() : pluginClassLoader);
        if (clazz.getClassLoader() != PluginManager.class.getClassLoader()) {
            try {
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverWrapper(driver));
                registeredDrivers.add(string);
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Could not register driver " + string, exception);
            }
        } else {
            registeredDrivers.add(string);
        }
    }

    static {
        internalPlugins.add(yajhfc.printerport.EntryPoint.class);
        internalPlugins.add(EntryPoint.class);
        internalPlugins.add(yajhfc.report.EntryPoint.class);
        pluginUIs = new ArrayList<PluginUI>();
        knownPlugins = new TreeMap<File, PluginInfo>();
        registeredDrivers = new HashSet<String>();
    }

    public static class DriverWrapper
    implements Driver {
        protected Driver wrapped;

        public DriverWrapper(Driver driver) {
            this.wrapped = driver;
        }

        public boolean acceptsURL(String string) throws SQLException {
            return this.wrapped.acceptsURL(string);
        }

        public Connection connect(String string, Properties properties) throws SQLException {
            return this.wrapped.connect(string, properties);
        }

        public int getMajorVersion() {
            return this.wrapped.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.wrapped.getMinorVersion();
        }

        public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
            return this.wrapped.getPropertyInfo(string, properties);
        }

        public boolean jdbcCompliant() {
            return this.wrapped.jdbcCompliant();
        }

        public Logger getParentLogger() {
            try {
                Method method = this.wrapped.getClass().getMethod("getParentLogger", new Class[0]);
                return (Logger)method.invoke((Object)this.wrapped, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class PluginInfo {
        public final File file;
        public final PluginType type;
        Class<?> initClass;
        public boolean persistent;
        public boolean loaded;

        public PluginInfo(File file, PluginType pluginType, boolean bl) {
            this.file = file;
            this.type = pluginType;
            this.loaded = false;
            this.persistent = bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.file != null) {
                n ^= this.file.hashCode();
            }
            if (this.type != null) {
                n ^= this.type.hashCode();
            }
            if (this.persistent) {
                n ^= 0x913;
            }
            if (this.loaded) {
                n ^= 0x1092;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PluginInfo pluginInfo = (PluginInfo)object;
            if (this.file == null ? pluginInfo.file != null : !this.file.equals(pluginInfo.file)) {
                return false;
            }
            if (this.loaded != pluginInfo.loaded) {
                return false;
            }
            if (this.persistent != pluginInfo.persistent) {
                return false;
            }
            return !(this.type == null ? pluginInfo.type != null : !this.type.equals((Object)pluginInfo.type));
        }
    }
}

