/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class StatusDialogPrintable
implements Printable {
    static final Logger log = Logger.getLogger(StatusDialogPrintable.class.getName());
    Throwable printError = null;
    Printable printDelegate;
    MessageFormat statusFormat;
    JLabel statusLabel;

    private StatusDialogPrintable(Printable printable) {
        this.printDelegate = printable;
    }

    public void startUpdatingStatus(MessageFormat messageFormat, JLabel jLabel) {
        this.statusFormat = messageFormat;
        this.statusLabel = jLabel;
    }

    public void stopUpdatingStatus() {
        this.statusFormat = null;
        this.statusLabel = null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, final int n) throws PrinterException {
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        if (StatusDialogPrintable.this.statusLabel != null) {
                            Object[] objectArray = new Object[]{n + 1};
                            StatusDialogPrintable.this.statusLabel.setText(StatusDialogPrintable.this.statusFormat.format(objectArray));
                        }
                    }
                    catch (Throwable throwable) {
                        log.log(Level.WARNING, "Error showing status dialog", throwable);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
            return this.printDelegate.print(graphics, pageFormat, n);
        }
        catch (Exception exception) {
            throw (PrinterException)new PrinterException().initCause(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean printWithDialog(Component component, Printable printable, PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException, HeadlessException {
        Throwable throwable;
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        final StatusDialogPrintable statusDialogPrintable = new StatusDialogPrintable(printable);
        printerJob.setPrintable(statusDialogPrintable);
        if (!printerJob.printDialog(printRequestAttributeSet)) {
            return false;
        }
        String string = StatusDialogPrintable.getUIManagerString("PrintingDialog.titleProgressText");
        String string2 = StatusDialogPrintable.getUIManagerString("PrintingDialog.contentInitialText");
        MessageFormat messageFormat = new MessageFormat(StatusDialogPrintable.getUIManagerString("PrintingDialog.contentProgressText"));
        String string3 = StatusDialogPrintable.getUIManagerString("PrintingDialog.abortButtonText");
        String string4 = StatusDialogPrintable.getUIManagerString("PrintingDialog.abortButtonToolTipText");
        int n = UIManager.getInt("PrintingDialog.abortButtonMnemonic");
        int n2 = UIManager.getInt("PrintingDialog.abortButtonDisplayedMnemonicIndex");
        final JButton jButton = new JButton(string3);
        jButton.setToolTipText(string4);
        if (n != -1) {
            jButton.setMnemonic(n);
        }
        if (n2 != -1) {
            jButton.setDisplayedMnemonicIndex(n2);
        }
        final JLabel jLabel = new JLabel(string2);
        JOptionPane jOptionPane = new JOptionPane(jLabel, 1, -1, null, new Object[]{jButton}, jButton);
        statusDialogPrintable.startUpdatingStatus(messageFormat, jLabel);
        final JDialog jDialog = jOptionPane.createDialog(component, string);
        jDialog.setDefaultCloseOperation(0);
        final AbstractAction abstractAction = new AbstractAction(){
            boolean isAborted = false;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.isAborted) {
                    this.isAborted = true;
                    jButton.setEnabled(false);
                    jDialog.setTitle(StatusDialogPrintable.getUIManagerString("PrintingDialog.titleAbortingText"));
                    jLabel.setText(StatusDialogPrintable.getUIManagerString("PrintingDialog.contentAbortingText"));
                    statusDialogPrintable.stopUpdatingStatus();
                    printerJob.cancel();
                }
            }
        };
        jButton.addActionListener(abstractAction);
        jOptionPane.getActionMap().put("close", abstractAction);
        final WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                abstractAction.actionPerformed(null);
            }
        };
        jDialog.addWindowListener(windowAdapter);
        statusDialogPrintable.printError = null;
        final Object object = new Object();
        final PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    printerJob.print(printRequestAttributeSet2);
                }
                catch (Throwable throwable) {
                    try {
                        Object object2 = object;
                        synchronized (object2) {
                            statusDialogPrintable.printError = throwable;
                        }
                    }
                    catch (Throwable throwable2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jDialog.removeWindowListener(windowAdapter);
                                jDialog.dispose();
                            }
                        });
                        throw throwable2;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        jDialog.setVisible(true);
        Object object2 = object;
        synchronized (object2) {
            throwable = statusDialogPrintable.printError;
            statusDialogPrintable.printError = null;
        }
        if (throwable != null) {
            if (throwable instanceof PrinterAbortException) {
                return false;
            }
            if (throwable instanceof PrinterException) {
                throw (PrinterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        return true;
    }

    static String getUIManagerString(Object object) {
        return UIManager.getString(object);
    }
}

