/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.print.tableprint;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.table.TableModel;
import yajhfc.print.tableprint.ColumnLayout;
import yajhfc.print.tableprint.TableCellRenderer;
import yajhfc.print.tableprint.TablePrintColumn;
import yajhfc.print.tableprint.TablePrintable;

public class SimpleColumnLayout
implements ColumnLayout {
    protected TablePrintable parent;
    protected TablePrintColumn[] tableColumns;
    protected double tableWidth = -1.0;
    protected double minFillColsWidth = 0.0;

    public void calculateColumnWidths(Graphics2D graphics2D, double d, double d2) {
        this.tableWidth = this.calculateColumnWidth(graphics2D, this.getTableColumns(), d, d2);
    }

    protected boolean useForPreferredWidth(TablePrintColumn tablePrintColumn, int n) {
        return true;
    }

    protected double calculateColumnWidth(Graphics2D graphics2D, TablePrintColumn[] tablePrintColumnArray, double d, double d2) {
        Object object;
        int n = tablePrintColumnArray.length;
        double d3 = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TablePrintColumn tablePrintColumn = tablePrintColumnArray[i];
            float f = tablePrintColumn.getWidth();
            if (f == -1.0f) {
                object = graphics2D.getFontMetrics(tablePrintColumn.getEffectiveHeaderFont());
                double d4 = this.parent.getDefaultRenderer().getPreferredWidth(graphics2D, tablePrintColumn.getHeaderText(), (FontMetrics)object, null, tablePrintColumn);
                object = graphics2D.getFontMetrics(tablePrintColumn.getEffectiveFont());
                TableCellRenderer tableCellRenderer = tablePrintColumn.getEffectiveRenderer();
                for (int j = 0; j < this.parent.getModel().getRowCount(); ++j) {
                    double d5;
                    if (!this.useForPreferredWidth(tablePrintColumn, j) || !((d5 = tableCellRenderer.getPreferredWidth(graphics2D, tablePrintColumn.getData(j), (FontMetrics)object, tablePrintColumn.getEffectiveFormat(), tablePrintColumn)) > d4)) continue;
                    d4 = d5;
                }
                tablePrintColumn.effectiveColumnWidth = d4 + 2.0 * d2;
                d3 += tablePrintColumn.effectiveColumnWidth;
                continue;
            }
            if (f == -2.0f) {
                ++n2;
                continue;
            }
            if (f > 0.0f && f <= 1.0f) {
                tablePrintColumn.effectiveColumnWidth = d * (double)f;
                d3 += tablePrintColumn.effectiveColumnWidth;
                continue;
            }
            if (f > 1.0f) {
                tablePrintColumn.effectiveColumnWidth = f;
                d3 += tablePrintColumn.effectiveColumnWidth;
                continue;
            }
            throw new IllegalArgumentException("Column " + i + ": Illegal width " + f);
        }
        if (n2 > 0 && (d3 < d || this.minFillColsWidth > 0.0)) {
            double d6 = Math.max(d - d3, this.minFillColsWidth) / (double)n2;
            for (int i = 0; i < n; ++i) {
                object = tablePrintColumnArray[i];
                if (((TablePrintColumn)object).getWidth() != -2.0f) continue;
                ((TablePrintColumn)object).effectiveColumnWidth = d6;
            }
        }
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d7 += tablePrintColumnArray[i].effectiveColumnWidth;
        }
        return d7;
    }

    public TablePrintColumn[] getTableColumns() {
        return this.tableColumns;
    }

    public TablePrintColumn[] getHeaderLayout() {
        return this.getTableColumns();
    }

    public TablePrintColumn[] getLayoutForRow(int n) {
        return this.getTableColumns();
    }

    public double getTableWidth() {
        return this.tableWidth;
    }

    public int getMaximumColumnCount() {
        return this.getTableColumns().length;
    }

    public void setMinFillColsWidth(double d) {
        this.minFillColsWidth = d;
    }

    public double getMinFillColsWidth() {
        return this.minFillColsWidth;
    }

    public void initializeLayout(TablePrintable tablePrintable, TableModel tableModel) {
        this.parent = tablePrintable;
        int n = tableModel.getColumnCount();
        this.tableColumns = new TablePrintColumn[n];
        for (int i = 0; i < n; ++i) {
            this.tableColumns[i] = new TablePrintColumn(tablePrintable, i);
        }
    }
}

