/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.launch.SendWinSubmitProtocol;
import yajhfc.printerport.FIFO;

public class FIFOThread
extends Thread {
    private static final Logger log = Logger.getLogger(FIFOThread.class.getName());
    protected final String fifoName;
    protected FIFO fifo;

    public FIFOThread(String string) {
        super("PrinterFIFO-" + string);
        this.fifoName = string;
    }

    public void close() {
        this.interrupt();
        if (this.fifo != null) {
            this.fifo.close();
            this.fifo = null;
        }
    }

    public void run() {
        try {
            this.fifo = FIFO.createFIFO(this.fifoName);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "Could not create FIFO, not created printer port", iOException);
            return;
        }
        try {
            while (!this.isInterrupted()) {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(this.fifo.openInputStream());
                int n = pushbackInputStream.read();
                if (n != -1) {
                    pushbackInputStream.unread(n);
                    this.submitFax(pushbackInputStream);
                }
                pushbackInputStream.close();
            }
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Error waiting for a document to be printed:", iOException);
        }
        finally {
            this.close();
        }
    }

    protected void submitFax(PushbackInputStream pushbackInputStream) throws IOException {
        SendWinSubmitProtocol sendWinSubmitProtocol = new SendWinSubmitProtocol();
        sendWinSubmitProtocol.setInputStream(pushbackInputStream, this.fifo.toString());
        sendWinSubmitProtocol.submit(true);
    }
}

