/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.printerport;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import yajhfc.FaxOptions;
import yajhfc.PlatformInfo;
import yajhfc.Utils;
import yajhfc.options.AbstractOptionsPanel;
import yajhfc.options.OptionsWin;
import yajhfc.printerport.EntryPoint;
import yajhfc.printerport.PortOptions;
import yajhfc.util.ClipboardPopup;
import yajhfc.util.IntVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortOptionsPanel
extends AbstractOptionsPanel<FaxOptions> {
    static final boolean NEED_MKFIFO = !PlatformInfo.IS_WINDOWS;
    private static final int border = 8;
    JTextField textBindAddr;
    JTextField textPort;
    JTextField textMkfifo;
    JTextField textFIFO;
    JCheckBox checkEnabled;
    JCheckBox checkEnableFIFO;
    JLabel labelBindAddr;
    JLabel labelPort;
    JLabel labelMkfifo;
    JLabel labelFIFO;

    public PortOptionsPanel() {
        super(false);
    }

    @Override
    protected void createOptionsUI() {
        double[][] dArrayArray = new double[][]{{8.0, 0.66, 8.0, -1.0, 8.0}, {8.0, -2.0, 8.0, -2.0, 8.0, -2.0, -2.0, 16.0, -2.0, 8.0, -2.0, -2.0, 8.0, -2.0, -2.0, -1.0}};
        this.setLayout(new TableLayout(dArrayArray));
        JLabel jLabel = new JLabel("<html>" + Utils._("YajHFC supports listening for new PostScript documents to send on a TCP port or a named pipe.") + "<br>" + Utils._("The TCP port can be used as <i>AppSocket</i> port (<i>socket:</i> protocol) in CUPS or <i>standard TCP/IP port</i> in Windows to create a virtual fax printer.") + "<br>" + Utils._("The named pipe is especially useful on Unix, where it can be used together with a special CUPS backend to get fax printer support for multiple simultaneously logged in users.") + "</html>");
        this.checkEnabled = new JCheckBox(Utils._("Enable TCP/IP printer port for YajHFC"));
        this.checkEnabled.setSelected(true);
        this.checkEnabled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PortOptionsPanel.this.checkTCPControlsEnable();
            }
        });
        this.checkEnableFIFO = new JCheckBox(Utils._("Enable FIFO/named pipe printer port for YajHFC"));
        this.checkEnableFIFO.setSelected(true);
        this.checkEnableFIFO.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PortOptionsPanel.this.checkFIFOControlsEnable();
            }
        });
        this.textBindAddr = new JTextField();
        this.textBindAddr.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textPort = new JTextField();
        this.textPort.setInputVerifier(new IntVerifier(1, 65536));
        this.textPort.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textFIFO = new JTextField();
        this.textFIFO.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.textMkfifo = new JTextField();
        this.textMkfifo.addMouseListener(ClipboardPopup.DEFAULT_POPUP);
        this.add((Component)jLabel, "1,1,3,1,f,f");
        this.add((Component)this.checkEnabled, "1,3,3,3,l,c");
        this.labelBindAddr = Utils.addWithLabel((JPanel)this, (Component)this.textBindAddr, Utils._("Bind address:"), "1,6");
        this.labelPort = Utils.addWithLabel((JPanel)this, (Component)this.textPort, Utils._("Port:"), "3,6");
        this.add((Component)this.checkEnableFIFO, "1,8,3,8,l,c");
        this.labelFIFO = Utils.addWithLabel((JPanel)this, (Component)this.textFIFO, Utils._("Name of named pipe (%u is replaced with user name):"), "1,11,3,11,f,c");
        this.labelMkfifo = Utils.addWithLabel((JPanel)this, (Component)this.textMkfifo, Utils._("mkfifo command:"), "1,14,3,14,f,c");
    }

    @Override
    public void loadSettings(FaxOptions faxOptions) {
        PortOptions portOptions = EntryPoint.getOptions();
        this.checkEnabled.setSelected(portOptions.enabled);
        this.textBindAddr.setText(portOptions.bindAddress);
        this.textPort.setText(String.valueOf(portOptions.port));
        this.checkEnableFIFO.setSelected(portOptions.enableFIFO);
        this.textFIFO.setText(portOptions.fifoName);
        this.textMkfifo.setText(portOptions.mkfifo);
        this.checkFIFOControlsEnable();
        this.checkTCPControlsEnable();
    }

    @Override
    public void saveSettings(FaxOptions faxOptions) {
        PortOptions portOptions = EntryPoint.getOptions();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.checkEnabled.isSelected();
        String string = this.textBindAddr.getText();
        int n = Integer.parseInt(this.textPort.getText());
        if (bl3 != portOptions.enabled) {
            portOptions.enabled = bl3;
            bl = true;
        }
        if (!string.equals(portOptions.bindAddress)) {
            portOptions.bindAddress = string;
            bl = true;
        }
        if (n != portOptions.port) {
            portOptions.port = n;
            bl = true;
        }
        boolean bl4 = this.checkEnableFIFO.isSelected();
        String string2 = this.textFIFO.getText();
        String string3 = this.textMkfifo.getText();
        if (bl4 != portOptions.enableFIFO) {
            portOptions.enableFIFO = bl4;
            bl2 = true;
        }
        if (!string2.equals(portOptions.fifoName)) {
            portOptions.fifoName = string2;
            bl2 = true;
        }
        if (!string3.equals(portOptions.mkfifo)) {
            portOptions.mkfifo = string3;
            bl2 = true;
        }
        if (bl) {
            EntryPoint.reopenTCPThread();
        }
        if (bl2) {
            EntryPoint.reopenFIFOThread();
        }
    }

    @Override
    public boolean validateSettings(OptionsWin optionsWin) {
        String string;
        String string2;
        try {
            int n = Integer.parseInt(this.textPort.getText());
            if (n < 1 || n > 65536) {
                JOptionPane.showMessageDialog(this, Utils._("Please enter a number between 1 and 65536 as port number!"));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, Utils._("Please enter a number between 1 and 65536 as port number!"));
            return false;
        }
        if (this.checkEnabled.isSelected() && (string2 = this.textBindAddr.getText()).length() > 0) {
            try {
                InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                JOptionPane.showMessageDialog(this, Utils._("Invalid bind address: ") + unknownHostException);
                return false;
            }
        }
        if (NEED_MKFIFO && this.checkEnableFIFO.isSelected() && ((string = this.textMkfifo.getText()).length() == 0 || Utils.searchExecutableInPath(Utils.extractExecutableFromCmdLine(string)) == null)) {
            JOptionPane.showMessageDialog(this, Utils._("The mkfifo command entered cannot be found."));
            return false;
        }
        return true;
    }

    void checkFIFOControlsEnable() {
        boolean bl = this.checkEnableFIFO.isSelected();
        boolean bl2 = bl && NEED_MKFIFO;
        this.textFIFO.setEnabled(bl);
        this.textMkfifo.setEnabled(bl2);
        this.labelFIFO.setEnabled(bl);
        this.labelMkfifo.setEnabled(bl2);
    }

    void checkTCPControlsEnable() {
        boolean bl = this.checkEnabled.isSelected();
        this.textBindAddr.setEnabled(bl);
        this.textPort.setEnabled(bl);
        this.labelBindAddr.setEnabled(bl);
        this.labelPort.setEnabled(bl);
    }
}

