/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.shutdown;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.PlatformInfo;
import yajhfc.Utils;
import yajhfc.shutdown.Win32ShutdownManager;

public class ShutdownManager {
    private static ShutdownManager INSTANCE;

    public static ShutdownManager getInstance() {
        if (INSTANCE == null) {
            if (PlatformInfo.IS_WINDOWS && Utils.getFaxOptions().useWin32ShutdownManager) {
                try {
                    INSTANCE = new Win32ShutdownManager();
                }
                catch (Throwable throwable) {
                    Logger.getLogger(ShutdownManager.class.getName()).log(Level.WARNING, "Error installing Win32 shutdown manager: ", throwable);
                    INSTANCE = new ShutdownManager();
                }
            } else {
                INSTANCE = new ShutdownManager();
            }
        }
        return INSTANCE;
    }

    public static void setInstance(ShutdownManager shutdownManager) {
        INSTANCE = shutdownManager;
    }

    public static void deleteOnExit(File file) {
        ShutdownManager.getInstance().registerDeleteOnExit(file);
    }

    public void registerDeleteOnExit(File file) {
        file.deleteOnExit();
    }

    public void registerShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }
}

