/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tiff;

public class Class2Params {
    public int vr;
    public int br;
    public int wd;
    public int ln;
    public int df;
    public int ec;
    public int bf;
    public int st;
    public int jp;
    private static final int MAX_BITSTRING_BYTES = 16;
    public int[] m_bits = new int[16];
    private static final int BOR_C_DIR = 0;
    private static final int BOR_C_REV = 1;
    private static final int BOR_C = 1;
    private static final int BOR_BD_DIR = 0;
    private static final int BOR_BD_REV = 2;
    private static final int BOR_BD = 2;
    private static final int SERVICE_DATA = Class2Params.BIT(0);
    private static final int SERVICE_CLASS1 = Class2Params.BIT(1);
    private static final int SERVICE_CLASS2 = Class2Params.BIT(2);
    private static final int SERVICE_CLASS20 = Class2Params.BIT(3);
    private static final int SERVICE_CLASS10 = Class2Params.BIT(4);
    private static final int SERVICE_CLASS21 = Class2Params.BIT(5);
    private static final int SERVICE_VOICE = Class2Params.BIT(8);
    private static final int SERVICE_ALL = Class2Params.BIT(9) - 1;
    private static final int VR_NORMAL = 0;
    private static final int VR_FINE = 1;
    private static final int VR_R8 = 2;
    private static final int VR_R16 = 4;
    private static final int VR_200X100 = 8;
    private static final int VR_200X200 = 16;
    private static final int VR_200X400 = 32;
    private static final int VR_300X300 = 64;
    private static final int VR_ALL = 127;
    private static final int BR_2400 = 0;
    private static final int BR_4800 = 1;
    private static final int BR_7200 = 2;
    private static final int BR_9600 = 3;
    private static final int BR_12000 = 4;
    private static final int BR_14400 = 5;
    private static final int BR_16800 = 6;
    private static final int BR_19200 = 7;
    private static final int BR_21600 = 8;
    private static final int BR_24000 = 9;
    private static final int BR_26400 = 10;
    private static final int BR_28800 = 11;
    private static final int BR_31200 = 12;
    private static final int BR_33600 = 13;
    private static final int BR_ALL = Class2Params.BIT(14) - 1;
    private static final int WD_A4 = 0;
    private static final int WD_B4 = 1;
    private static final int WD_A3 = 2;
    private static final int WD_ALL = Class2Params.BIT(3) - 1;
    private static final int LN_A4 = 0;
    private static final int LN_B4 = 1;
    private static final int LN_INF = 2;
    private static final int LN_ALL = Class2Params.BIT(3) - 1;
    private static final int LN_LET = 3;
    private static final int DF_1DMH = 0;
    private static final int DF_2DMR = 1;
    private static final int DF_2DMRUNCOMP = 2;
    private static final int DF_2DMMR = 3;
    private static final int DF_JBIG = 4;
    private static final int DF_ALL = Class2Params.BIT(5) - 1 ^ Class2Params.BIT(2);
    private static final int EC_DISABLE = 0;
    private static final int EC_ENABLE64 = 1;
    private static final int EC_ENABLE256 = 2;
    private static final int EC_ECLHALF = 3;
    private static final int EC_ECLFULL = 4;
    private static final int EC_ALL = Class2Params.BIT(5) - 1;
    private static final int BF_DISABLE = 0;
    private static final int BF_ENABLE = 1;
    private static final int BF_DTM = 2;
    private static final int BF_EDI = 4;
    private static final int BF_BTM = 8;
    private static final int BF_CM = 10;
    private static final int BF_MM = 20;
    private static final int BF_PM = 40;
    private static final int BF_ALL = 3;
    private static final int ST_0MS = 0;
    private static final int ST_5MS = 1;
    private static final int ST_10MS2 = 2;
    private static final int ST_10MS = 3;
    private static final int ST_20MS2 = 4;
    private static final int ST_20MS = 5;
    private static final int ST_40MS2 = 6;
    private static final int ST_40MS = 7;
    private static final int ST_ALL = Class2Params.BIT(8) - 1;
    private static final int JP_NONE = 0;
    private static final int JP_GREY = 1;
    private static final int JP_COLOR = 2;
    private static final int JP_HUFFMAN = 3;
    private static final int JP_12BIT = 4;
    private static final int JP_NOSUB = 5;
    private static final int JP_ILLUM = 6;
    private static final int JP_GAMUT = 7;
    private static final int JP_ALL = Class2Params.BIT(8) - 1;
    private static final int PPM_MPS = 0;
    private static final int PPM_EOM = 1;
    private static final int PPM_EOP = 2;
    private static final int PPM_PRI_MPS = 4;
    private static final int PPM_PRI_EOM = 5;
    private static final int PPM_PRI_EOP = 6;
    private static final int PPH_SKIP = 251;
    private static final int PPR_MCF = 1;
    private static final int PPR_RTN = 2;
    private static final int PPR_RTP = 3;
    private static final int PPR_PIN = 4;
    private static final int PPR_PIP = 5;
    private static final int DLE = 16;
    private static final int SUB = 26;
    private static final int ETX = 3;
    private static final int DC1 = 17;
    private static final int DC2 = 18;
    private static final int CAN = 24;
    private static final int EOT = 4;
    private static final int DIS_V8 = 262144;
    private static final int DIS_FRAMESIZE = 131072;
    private static final int DIS_T4XMTR = 32768;
    private static final int DIS_T4RCVR = 16384;
    private static final int DIS_SIGRATE = 15360;
    private static final int DISSIGRATE_V27FB = 0;
    private static final int DISSIGRATE_V27 = 4;
    private static final int DISSIGRATE_V29 = 8;
    private static final int DISSIGRATE_V2729 = 12;
    private static final int DISSIGRATE_V33 = 14;
    private static final int DISSIGRATE_V17 = 13;
    private static final int DIS_7MMVRES = 512;
    private static final int DIS_2DENCODE = 256;
    private static final int DIS_PAGEWIDTH = 192;
    private static final int DISWIDTH_A4 = 0;
    private static final int DISWIDTH_A3 = 1;
    private static final int DISWIDTH_B4 = 2;
    private static final int DISWIDTH_INVALID = 3;
    private static final int DIS_PAGELENGTH = 48;
    private static final int DISLENGTH_A4 = 0;
    private static final int DISLENGTH_UNLIMITED = 1;
    private static final int DISLENGTH_A4B4 = 2;
    private static final int DISLENGTH_INVALID = 3;
    private static final int DIS_MINSCAN = 14;
    private static final int DISMINSCAN_20MS = 0;
    private static final int DISMINSCAN_40MS = 1;
    private static final int DISMINSCAN_10MS = 2;
    private static final int DISMINSCAN_10MS2 = 3;
    private static final int DISMINSCAN_5MS = 4;
    private static final int DISMINSCAN_40MS2 = 5;
    private static final int DISMINSCAN_20MS2 = 6;
    private static final int DISMINSCAN_0MS = 7;
    private static final int DIS_XTNDFIELD = 1;
    private static final int DIS_2400HS = Integer.MIN_VALUE;
    private static final int DIS_2DUNCOMP = 0x40000000;
    private static final int DIS_ECMODE = 0x20000000;
    private static final int DIS_ELMODE = 0x8000000;
    private static final int DIS_G4COMP = 0x2000000;
    private static final int DIS_IGNOLD = 0x800000;
    private static final int DIS_1216 = 0x400000;
    private static final int DIS_864 = 0x200000;
    private static final int DIS_1728L = 0x100000;
    private static final int DIS_1728H = 524288;
    private static final int DIS_MULTSEP = 0x400000;
    private static final int DIS_POLLSUB = 0x200000;
    private static final int DIS_T43 = 0x100000;
    private static final int DIS_INTERLV = 524288;
    private static final int DIS_VOICE = 262144;
    private static final int DIS_VOICEXT = 131072;
    private static final int DIS_200X400 = 32768;
    private static final int DIS_300X300 = 16384;
    private static final int DIS_400X400 = 8192;
    private static final int DIS_INCHRES = 4096;
    private static final int DIS_METRES = 2048;
    private static final int DIS_400MST2 = 1024;
    private static final int DIS_SEP = 512;
    private static final int DIS_SUB = 128;
    private static final int DIS_PWD = 64;
    private static final int DIS_DATAFILE = 32;
    private static final int DIS_BFT = 8;
    private static final int DIS_DTM = 4;
    private static final int DIS_EDI = 2;
    private static final int DCS_T4RCVR = 16384;
    private static final int DCS_SIGRATE = 15360;
    private static final int DCSSIGRATE_2400V27 = 0;
    private static final int DCSSIGRATE_4800V27 = 4096;
    private static final int DCSSIGRATE_9600V29 = 8192;
    private static final int DCSSIGRATE_7200V29 = 12288;
    private static final int DCSSIGRATE_14400V33 = 2048;
    private static final int DCSSIGRATE_12000V33 = 6144;
    private static final int DCSSIGRATE_14400V17 = 1024;
    private static final int DCSSIGRATE_12000V17 = 5120;
    private static final int DCSSIGRATE_9600V17 = 9216;
    private static final int DCSSIGRATE_7200V17 = 13312;
    private static final int DCS_7MMVRES = 512;
    private static final int DCS_2DENCODE = 256;
    private static final int DCS_PAGEWIDTH = 192;
    private static final int DCSWIDTH_A4 = 0;
    private static final int DCSWIDTH_A3 = 64;
    private static final int DCSWIDTH_B4 = 128;
    private static final int DCS_PAGELENGTH = 48;
    private static final int DCSLENGTH_A4 = 0;
    private static final int DCSLENGTH_UNLIMITED = 16;
    private static final int DCSLENGTH_B4 = 32;
    private static final int DCS_MINSCAN = 14;
    private static final int DCSMINSCAN_20MS = 0;
    private static final int DCSMINSCAN_40MS = 2;
    private static final int DCSMINSCAN_10MS = 4;
    private static final int DCSMINSCAN_5MS = 8;
    private static final int DCSMINSCAN_0MS = 14;
    private static final int DCS_XTNDFIELD = 1;
    private static final int DCS_2400HS = Integer.MIN_VALUE;
    private static final int DCS_2DUNCOMP = 0x40000000;
    private static final int DCS_ECMODE = 0x20000000;
    private static final int DCS_FRAMESIZE = 0x10000000;
    private static final int DCSFRAME_256 = 0;
    private static final int DCSFRAME_64 = 0x10000000;
    private static final int DCS_ELMODE = 0x8000000;
    private static final int DCS_G4COMP = 0x2000000;
    private static final int DCS_IGNOLD = 0x800000;
    private static final int DCS_1216 = 0x400000;
    private static final int DCS_864 = 0x200000;
    private static final int DCS_200X400 = 32768;
    private static final int DCS_300X300 = 16384;
    private static final int DCS_400X400 = 8192;
    private static final int DCS_INCHRES = 4096;
    private static final int DCS_BFT = 8;
    private static final int DCS_DTM = 4;
    private static final int DCS_EDI = 2;
    private static final int BITNUM_V8_CAPABLE = 6;
    private static final int BITNUM_FRAMESIZE_DIS = 7;
    private static final int BITNUM_T4XMTR = 9;
    private static final int BITNUM_T4RCVR = 10;
    private static final int BITNUM_SIGRATE_11 = 11;
    private static final int BITNUM_SIGRATE_12 = 12;
    private static final int BITNUM_SIGRATE_13 = 13;
    private static final int BITNUM_SIGRATE_14 = 14;
    private static final int BITNUM_VR_FINE = 15;
    private static final int BITNUM_2DMR = 16;
    private static final int BITNUM_WIDTH_17 = 17;
    private static final int BITNUM_WIDTH_18 = 18;
    private static final int BITNUM_LENGTH_19 = 19;
    private static final int BITNUM_LENGTH_20 = 20;
    private static final int BITNUM_ST_21 = 21;
    private static final int BITNUM_ST_22 = 22;
    private static final int BITNUM_ST_23 = 23;
    private static final int BITNUM_ECM = 27;
    private static final int BITNUM_FRAMESIZE_DCS = 28;
    private static final int BITNUM_2DMMR = 31;
    private static final int BITNUM_JBIG = 36;
    private static final int BITNUM_VR_R8 = 41;
    private static final int BITNUM_VR_300X300 = 42;
    private static final int BITNUM_VR_R16 = 43;
    private static final int BITNUM_INCH_RES = 44;
    private static final int BITNUM_METRIC_RES = 45;
    private static final int BITNUM_SEP = 47;
    private static final int BITNUM_SUB = 49;
    private static final int BITNUM_PWD = 50;
    private static final int BITNUM_JPEG = 68;
    private static final int BITNUM_FULLCOLOR = 69;
    private static final int BITNUM_LETTER_SIZE = 76;
    private static final int BITNUM_LEGAL_SIZE = 77;
    private static final int BITNUM_JBIG_BASIC = 78;
    private static final int BITNUM_JBIG_L0 = 79;
    private static final int[] DISdfTab = new int[]{0, 1};
    private static final int[] DISvrTab = new int[]{0, 1};
    private static final int[] DISbrTab = new int[]{0, 5, 3, 5, 1, 5, 1, 5, 3, 5, 3, 5, 3, 5, 5, 5};
    private static final int[] DISwdTab = new int[]{0, 2, 1};
    private static final int[] DISlnTab = new int[]{0, 2, 1, 0};
    private static final int[] DISstTab = new int[]{5, 7, 3, 2, 1, 6, 4, 0};
    private static final int[] DCSbrTab = new int[]{0, 5, 5, 0, 1, 4, 4, 0, 3, 3, 3, 0, 2, 2, 2, 0};
    private static final int[] brRates = new int[]{2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200, 21600, 24000, 26400, 28800, 31200, 33600, 14400, 14400};
    private static final String[] dataFormatNames = new String[]{"1-D MH", "2-D MR", "2-D Uncompressed Mode", "2-D MMR", "JBIG", "JPEG Greyscale", "JPEG Full-Color"};
    private static final int[] lengths = new int[]{297, 364, -1, 280};

    private static final int BIT(int n) {
        return 1 << n;
    }

    public void asciiDecode(char[] cArray) {
        int n = 0;
        int n2 = 0;
        while (n2 + 1 < cArray.length) {
            this.m_bits[n] = (cArray[n2 + 0] - (cArray[n2 + 0] > '@' ? 55 : 48) << 4) + (cArray[n2 + 1] - (cArray[n2 + 1] > '@' ? 55 : 48));
            this.setExtendBits(n++);
            if ((n2 += 2) >= cArray.length || cArray[n2] != ' ') continue;
            ++n2;
        }
    }

    private void setExtendBits(int n) {
        if (n >= 3) {
            for (int i = n - 1; i >= 2; --i) {
                this.m_bits[i] = this.m_bits[i] | 1;
            }
        }
    }

    public void setPageWidthInPixels(int n) {
        this.wd = n == 1728 ? 0 : (n == 2048 ? 1 : (n == 2432 ? 2 : (n == 3456 ? 0 : (n == 4096 ? 1 : (n == 4864 ? 2 : (n == 2592 ? 0 : (n == 3072 ? 1 : (n == 3648 ? 2 : 0))))))));
    }

    public void setPageLengthInMM(int n) {
        this.ln = n == -1 ? 2 : (n <= 280 ? 3 : (n <= 300 ? 0 : (n <= 380 ? 1 : 2)));
    }

    public void setRes(int n, int n2) {
        this.vr = n > 300 && n2 > 391 ? 4 : (n > 204 && n2 > 250 ? 64 : (n2 > 391 ? 32 : (n2 > 250 ? 2 : (n2 > 196 ? 16 : (n2 > 150 ? 1 : (n2 > 98 ? 8 : 0))))));
    }

    public static char[] sanitize(char[] cArray) {
        return cArray;
    }

    public int getHorizontalRes() {
        return this.vr == 0 ? 204 : (this.vr == 1 ? 204 : (this.vr == 2 ? 204 : (this.vr == 4 ? 408 : (this.vr == 8 ? 200 : (this.vr == 16 ? 200 : (this.vr == 32 ? 200 : (this.vr == 64 ? 300 : -1)))))));
    }

    public int getVerticalRes() {
        return this.vr == 0 ? 98 : (this.vr == 1 ? 196 : (this.vr == 2 ? 391 : (this.vr == 4 ? 391 : (this.vr == 8 ? 100 : (this.vr == 16 ? 200 : (this.vr == 32 ? 400 : (this.vr == 64 ? 300 : -1)))))));
    }

    public void decodeClass2Params(long l) {
        if (l >> 21 == 1L) {
            this.vr = (int)(l >> 0 & 7L);
            this.br = (int)(l >> 3) & 0xF;
            this.wd = (int)(l >> 9) & 7;
            this.ln = (int)(l >> 12) & 3;
            if (this.ln == 3) {
                this.ln = 0;
            }
            this.df = (int)(l >> 14) & 3;
            this.ec = (int)(l >> 16) & 1;
            this.bf = (int)(l >> 17) & 1;
            this.st = (int)(l >> 18) & 7;
        } else {
            this.vr = (int)(l >> 0) & 1;
            this.br = (int)(l >> 1) & 7;
            this.wd = (int)(l >> 4) & 7;
            this.ln = (int)(l >> 7) & 3;
            if (this.ln == 3) {
                this.ln = 0;
            }
            this.df = (int)(l >> 9) & 3;
            this.ec = (int)(l >> 11) & 1;
            this.bf = (int)(l >> 12) & 1;
            this.st = (int)(l >> 13) & 7;
        }
    }

    private int getByte(int n) {
        return this.m_bits[n];
    }

    public void setFromDCS() {
        int n = 0;
        int n2 = 0;
        n |= this.getByte(0) << 16;
        n |= this.getByte(1) << 8;
        n2 |= this.getByte(3) << 24;
        n2 |= this.getByte(4) << 16;
        n2 |= this.getByte(5) << 8;
        this.setFromDCS(n |= this.getByte(2) << 0, n2 |= this.getByte(6) << 0);
        if (this.isBitEnabled(76) || this.isBitEnabled(77)) {
            this.wd = 0;
            this.ln = 2;
        }
        if (this.isBitEnabled(78)) {
            this.df = 4;
        }
        if (this.isBitEnabled(79)) {
            this.df = 4;
        }
        if (this.isBitEnabled(68)) {
            this.jp = 1;
        }
        if (this.isBitEnabled(69) && this.jp == 1) {
            this.jp = 2;
        }
        if (this.ec == 0 && (this.df == 3 || this.df == 4 || this.jp == 1 || this.jp == 2)) {
            this.ec = 2;
        }
    }

    void setFromDCS(int n, int n2) {
        this.setFromDIS(n, n2);
        this.br = DCSbrTab[(n & 0x3C00) >> 10];
        this.vr = (n2 & 0x1000) != 0 ? ((n2 & 0x2000) != 0 ? 4 : ((n2 & 0x4000) != 0 ? 64 : ((n2 & 0x8000) != 0 ? 32 : ((n & 0x200) != 0 ? 16 : 8)))) : ((n2 & 0x4000) != 0 ? 64 : ((n2 & 0x2000) != 0 ? 4 : ((n2 & 0x8000) != 0 ? 2 : DISvrTab[(n & 0x200) >> 9])));
        this.df = (this.df & Class2Params.BIT(3)) != 0 ? 3 : ((this.df & Class2Params.BIT(1)) != 0 ? 1 : 0);
        this.ec = (n2 & 0x20000000) != 0 ? ((n2 & 0x10000000) != 0 ? 1 : 2) : 0;
    }

    void setFromDIS(int n, int n2) {
        this.vr = DISvrTab[(n & 0x200) >> 9];
        if ((n2 & 0x800) != 0) {
            if ((n2 & 0x8000) != 0) {
                this.vr |= 2;
            }
            if ((n2 & 0x2000) != 0) {
                this.vr |= 4;
            }
        }
        if ((n2 & 0x1000) != 0) {
            this.vr |= 8;
            if ((n & 0x200) != 0) {
                this.vr |= 0x10;
            }
            if ((n2 & 0x8000) != 0) {
                this.vr |= 0x20;
            }
        }
        if ((n2 & 0x4000) != 0) {
            this.vr |= 0x40;
        }
        this.br = (n & 0x40000) != 0 && (n2 & 0x20000000) != 0 ? 13 : DISbrTab[(n & 0x3C00) >> 10];
        this.wd = DISwdTab[(n & 0xC0) >> 6];
        this.ln = DISlnTab[(n & 0x30) >> 4];
        this.df = Class2Params.BIT(0);
        if ((n2 & 0x2000000) != 0 && (n2 & 0x20000000) != 0) {
            this.df |= Class2Params.BIT(3);
        }
        if ((n2 & 0x40000000) != 0) {
            this.df |= Class2Params.BIT(2);
        }
        if ((n & 0x100) != 0) {
            this.df |= Class2Params.BIT(1);
        }
        this.ec = (n2 & 0x20000000) != 0 ? ((n & 0x20000) != 0 ? 1 : 2) : 0;
        this.bf = 0;
        this.st = DISstTab[(n & 0xE) >> 1];
        this.jp = 0;
    }

    private boolean validBitNumber(int n) {
        return n >= 1 && n <= 127;
    }

    private boolean isBitEnabled(int n) {
        if (!this.validBitNumber(n)) {
            return false;
        }
        return (this.m_bits[this.calculateByteNumber(n)] & this.calculateMask(n)) != 0;
    }

    private int calculateByteNumber(int n) {
        return (n - 1) / 8;
    }

    private int calculateMask(int n) {
        int n2 = 7 - (n - 1) % 8;
        int n3 = 1 << n2;
        return n3;
    }

    public int bitRate() {
        return brRates[this.br & 0xF];
    }

    public String dataFormatName() {
        int n = this.df + (this.jp > 0 ? this.jp + 4 : 0);
        return dataFormatNames[n > 6 ? 0 : n];
    }

    public int pageLength() {
        return lengths[this.ln & 3];
    }

    public int pageWidth() {
        int[] nArray = new int[]{1728, 2048, 2432, 1216, 864, 1728, 1728, 1728};
        switch (this.vr) {
            case 64: {
                nArray[0] = 2592;
                nArray[1] = 3072;
                nArray[2] = 3648;
                nArray[3] = 1824;
                nArray[4] = 1296;
                break;
            }
            case 4: {
                nArray[0] = 3456;
                nArray[1] = 4096;
                nArray[2] = 4864;
                nArray[3] = 2432;
                nArray[4] = 1728;
                break;
            }
        }
        return nArray[this.wd & 7];
    }
}

