/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.file.TIFFLibConverter;
import yajhfc.tiff.Class2Params;
import yajhfc.tiff.TIFFReader;
import yajhfc.tiff.TIFFTag;

public class RecvTIFFReader
extends TIFFReader {
    private static final Logger log = Logger.getLogger(RecvTIFFReader.class.getName());
    protected Class2Params params;
    protected String sender;
    protected List<String> callid;
    protected String subaddr;
    protected Date date;
    protected String strDate;
    protected int recvTime;
    protected boolean inProgress;
    private static final int CallID_NUMBER = 0;
    private static final int CallID_NAME = 1;

    protected boolean shouldTagBeRead(int n, int n2) {
        switch (n) {
            case 256: 
            case 257: 
            case 270: 
            case 282: 
            case 283: 
            case 296: 
            case 306: 
            case 34908: 
            case 34909: 
            case 34911: {
                return n2 == 0;
            }
            case 34910: {
                return true;
            }
        }
        return false;
    }

    public void read(FileInputStream fileInputStream, boolean bl) {
        String string;
        TIFFTag tIFFTag;
        try {
            super.read(fileInputStream, true);
            this.inProgress = false;
        }
        catch (IOException iOException) {
            log.log(Level.INFO, "Exception reading TIFF, assuming it's in progress: " + fileInputStream, iOException);
            this.inProgress = true;
            return;
        }
        if (Utils.debugMode) {
            log.finest("TIFF read successfully; tags are: " + Arrays.toString(this.tags));
        }
        this.params = new Class2Params();
        TIFFTag tIFFTag2 = this.findTag(34908);
        if (tIFFTag2 != null) {
            this.params.decodeClass2Params(tIFFTag2.longValue());
        } else {
            float f = 3.85f;
            tIFFTag = this.findTag(283);
            if (tIFFTag != null) {
                f = tIFFTag.floatValue();
                int n = 2;
                TIFFTag object = this.findTag(296);
                if (object != null) {
                    n = object.intValue();
                }
                if (n == 2) {
                    f = (float)((double)f / 25.4);
                }
                if (n == 1) {
                    f = (float)((double)f / 720.0);
                }
            }
            float f2 = 8.03f;
            TIFFTag parseException = this.findTag(282);
            if (parseException != null) {
                f2 = parseException.floatValue();
                int n = 2;
                TIFFTag tIFFTag3 = this.findTag(296);
                if (tIFFTag3 != null) {
                    n = tIFFTag3.intValue();
                }
                if (n == 2) {
                    f2 = (float)((double)f2 / 25.4);
                }
                if (n == 1) {
                    f2 = (float)((double)f2 / 720.0);
                }
            }
            this.params.setRes((int)f2, (int)f);
            tIFFTag2 = this.findTag(256);
            if (tIFFTag2 != null) {
                this.params.setPageWidthInPixels(tIFFTag2.intValue());
            }
            if ((tIFFTag2 = this.findTag(257)) != null) {
                this.params.setPageLengthInMM((int)(tIFFTag2.floatValue() / f));
            }
        }
        tIFFTag2 = this.findTag(34911);
        String string2 = string = tIFFTag2 == null ? null : (String)tIFFTag2.value;
        if (string != null && !string.equals("00 00 00")) {
            int n = this.params.br;
            this.params.asciiDecode(Class2Params.sanitize(string.toCharArray()));
            this.params.setFromDCS();
            this.params.br = n;
        }
        this.sender = "";
        this.callid = Collections.emptyList();
        tIFFTag2 = this.findTag(270);
        TIFFTag tIFFTag4 = tIFFTag = tIFFTag2 == null ? null : (String)tIFFTag2.value;
        if (tIFFTag != null) {
            List<String> list = Utils.fastSplitToList((String)((Object)tIFFTag), '\n');
            if (list.size() >= 1) {
                this.sender = list.get(0);
                if (list.size() >= 2) {
                    this.callid = list.subList(1, list.size());
                }
            }
        } else {
            this.sender = "<unknown>";
        }
        tIFFTag2 = this.findTag(34909);
        String string3 = tIFFTag2 == null ? null : (String)tIFFTag2.value;
        this.subaddr = string3 != null ? string3 : "";
        tIFFTag2 = this.findTag(306);
        String string4 = this.strDate = tIFFTag2 == null ? null : (String)tIFFTag2.value;
        if (this.strDate != null) {
            try {
                this.date = Utils.HYLA_LONG_DATE_FORMAT.parse(this.strDate);
            }
            catch (ParseException parseException) {
                log.log(Level.INFO, "Error parsing date " + this.strDate, parseException);
                this.date = null;
            }
        } else {
            this.date = null;
        }
        this.recvTime = 0;
        for (TIFFTag tIFFTag5 : this.tags) {
            if (tIFFTag5.ID != 34910) continue;
            this.recvTime += tIFFTag5.intValue();
        }
    }

    public String getSubAddress() {
        return this.subaddr;
    }

    public int getBitRate() {
        return this.params.bitRate();
    }

    public String getDataFormatName() {
        return this.params.dataFormatName();
    }

    public String getReason() {
        return "";
    }

    public int getRecvTime() {
        return this.recvTime;
    }

    public String getCallIDNumber() {
        if (this.callid.size() > 0) {
            return this.callid.get(0);
        }
        return "";
    }

    public String getCallIDName() {
        if (this.callid.size() > 1) {
            return this.callid.get(1);
        }
        return "";
    }

    public int getVerticalRes() {
        return this.params.getVerticalRes();
    }

    public String getSender() {
        return this.sender;
    }

    public int getPageWidth() {
        return this.params.pageWidth();
    }

    public int getPageLength() {
        return this.params.pageLength();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public Date getDate() {
        return this.date;
    }

    public String getStrDate() {
        return this.strDate;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Usage: TIFFReader file1 ...");
        }
        RecvTIFFReader recvTIFFReader = new RecvTIFFReader();
        for (String string : stringArray) {
            System.out.println("Reading " + string + ": ");
            FileInputStream fileInputStream = new FileInputStream(string);
            recvTIFFReader.read(fileInputStream, true);
            fileInputStream.close();
            System.out.println("Number of pages: \t" + recvTIFFReader.getNumberOfPages());
            System.out.println("Bit rate: \t" + recvTIFFReader.getBitRate());
            System.out.println("Call ID name: \t" + recvTIFFReader.getCallIDName());
            System.out.println("Call ID number: \t" + recvTIFFReader.getCallIDNumber());
            System.out.println("Data format: \t" + recvTIFFReader.getDataFormatName());
            System.out.println("Receive Date: \t" + recvTIFFReader.getDate());
            System.out.println("Page width: \t" + recvTIFFReader.getPageWidth());
            System.out.println("Error reason: \t" + recvTIFFReader.getReason());
            System.out.println("Time to receive: \t" + recvTIFFReader.getRecvTime());
            System.out.println("Sender: \t" + recvTIFFReader.getSender());
            System.out.println("SubAddress: \t" + recvTIFFReader.getSubAddress());
            System.out.println("Vertical resolution: \t" + recvTIFFReader.getVerticalRes());
            System.out.println("Page size: \t" + TIFFLibConverter.getTIFFSizeInMM(new File(string)));
            System.out.println("-----------------------------");
            System.out.println();
        }
    }
}

