/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.tray;

import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import yajhfc.PlatformInfo;
import yajhfc.Utils;
import yajhfc.launch.Launcher2;
import yajhfc.tray.TrayManager;
import yajhfc.util.DoNotAskAgainDialog;

public class TrayFactory {
    static final Logger log = Logger.getLogger(TrayFactory.class.getName());
    private static boolean haveAWTSupport = true;
    private static TrayManager trayManager;
    private static Method isSupported;
    private static final String trayManagerClassName = "yajhfc.tray.DefaultTrayManager";

    public static boolean trayIsAvailable() {
        if (haveAWTSupport) {
            try {
                Constable constable;
                if (isSupported == null) {
                    constable = Class.forName("java.awt.SystemTray");
                    isSupported = ((Class)constable).getMethod("isSupported", new Class[0]);
                }
                constable = (Boolean)isSupported.invoke(null, new Object[0]);
                if (Utils.debugMode) {
                    log.fine("Tray is available: " + constable);
                }
                return (Boolean)constable;
            }
            catch (Exception exception) {
                if (Utils.debugMode) {
                    log.log(Level.INFO, "No tray available.", exception);
                }
                haveAWTSupport = false;
                return false;
            }
        }
        return false;
    }

    public static TrayManager getTrayManager() {
        if (TrayFactory.trayIsAvailable()) {
            if (trayManager == null) {
                try {
                    Class<?> clazz = Class.forName(trayManagerClassName);
                    trayManager = (TrayManager)clazz.newInstance();
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Could not create a tray manager.", exception);
                    haveAWTSupport = false;
                    return null;
                }
            }
            return trayManager;
        }
        return null;
    }

    public static void checkForProblematicPlatformAsync() {
        if (PlatformInfo.isGNOME()) {
            log.fine("Running GNOME, check version of it...");
            Utils.executorService.submit(new Runnable(){

                public void run() {
                    if (PlatformInfo.getGNOMEMajorVersion() >= 3) {
                        log.info("We have GNOME >= 3, show a warning.");
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DoNotAskAgainDialog.showMessageDialog("GNOME3-TrayIcon", Launcher2.application.getFrame(), Utils._("You seem to be running GNOME3:\nThis environment may cause problems when the tray icon is enabled (e.g. after minimizing YajHFC you may not be able to restore the main window again).\nIf you experience such problems, please disable the tray icon (Options->General->Show tray icon)."), "GNOME 3", 1);
                            }
                        });
                    }
                }
            });
        } else {
            log.fine("Not a known problematic platform.");
        }
    }
}

