/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import yajhfc.Utils;
import yajhfc.util.CancelAction;
import yajhfc.util.ExcDialogAbstractAction;
import yajhfc.util.KeyStrokeTextField;
import yajhfc.util.ToolbarEditorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleratorKeyDialog
extends JDialog {
    private static final int border = 6;
    ActionToKeyStrokeTableModel tableModel;
    JTable table;
    KeyStrokeTextField textAccelerator;
    Action actClearAccelerator;
    Action actOK;
    Action actReset;
    Action actUseDefault;
    Map<String, String> defaults;
    public boolean modalResult = false;

    public AcceleratorKeyDialog(Dialog dialog, Collection<Action> collection, Map<String, String> map) {
        super(dialog, Utils._("Edit keyboard shortcuts"), true);
        this.defaults = map;
        this.initialize(collection);
    }

    public AcceleratorKeyDialog(Frame frame, Collection<Action> collection, Map<String, String> map) {
        super(frame, Utils._("Edit keyboard shortcuts"), true);
        this.defaults = map;
        this.initialize(collection);
    }

    KeyStroke getDefaultForAction(Action action) {
        return KeyStroke.getKeyStroke(this.defaults.get(action.getValue("ActionCommandKey")));
    }

    private void initialize(Collection<Action> collection) {
        this.actClearAccelerator = new ExcDialogAbstractAction(Utils._("Clear")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = AcceleratorKeyDialog.this.table.getSelectedRow();
                if (n >= 0) {
                    AcceleratorKeyDialog.this.tableModel.setKeystroke(n, null);
                    AcceleratorKeyDialog.this.textAccelerator.setKeyStroke(null);
                }
            }
        };
        this.actUseDefault = new ExcDialogAbstractAction(Utils._("Use default")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                int n = AcceleratorKeyDialog.this.table.getSelectedRow();
                if (n >= 0) {
                    Action action = AcceleratorKeyDialog.this.tableModel.getAction(n);
                    KeyStroke keyStroke = AcceleratorKeyDialog.this.getDefaultForAction(action);
                    AcceleratorKeyDialog.this.tableModel.setKeystroke(n, keyStroke);
                    AcceleratorKeyDialog.this.textAccelerator.setKeyStroke(keyStroke);
                }
            }
        };
        this.actReset = new ExcDialogAbstractAction(Utils._("Reset")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < AcceleratorKeyDialog.this.tableModel.getRowCount(); ++i) {
                    Action action = AcceleratorKeyDialog.this.tableModel.getAction(i);
                    KeyStroke keyStroke = AcceleratorKeyDialog.this.getDefaultForAction(action);
                    AcceleratorKeyDialog.this.tableModel.setKeystroke(i, keyStroke);
                }
                AcceleratorKeyDialog.this.table.getSelectionModel().clearSelection();
            }
        };
        this.actOK = new ExcDialogAbstractAction(Utils._("OK")){

            protected void actualActionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = AcceleratorKeyDialog.this.tableModel.searchDuplicates();
                if (objectArray != null) {
                    JOptionPane.showMessageDialog(AcceleratorKeyDialog.this, MessageFormat.format(Utils._("Duplicate shortcut {0} found for actions \"{1}\" and \"{2}\"!"), objectArray), Utils._("Error"), 2);
                    return;
                }
                AcceleratorKeyDialog.this.tableModel.commitChanges();
                AcceleratorKeyDialog.this.modalResult = true;
                AcceleratorKeyDialog.this.dispose();
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tableModel = new ActionToKeyStrokeTableModel(collection);
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(Action.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                Icon icon;
                String string2;
                Action action = (Action)object;
                if (action == null) {
                    string2 = "";
                    icon = null;
                    string = null;
                } else {
                    string2 = (String)action.getValue("Name");
                    icon = (Icon)action.getValue("SmallIcon");
                    string = (String)action.getValue("ShortDescription");
                }
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                jLabel.setIcon(icon);
                jLabel.setToolTipText(string);
                return jLabel;
            }
        });
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    AcceleratorKeyDialog.this.updateSelection();
                }
            }
        });
        this.textAccelerator = new KeyStrokeTextField();
        this.textAccelerator.addKeyStrokeTextFieldListener(new KeyStrokeTextField.KeyStrokeTextFieldListener(){

            public void userTypedShortcut(KeyStroke keyStroke) {
                int n = AcceleratorKeyDialog.this.table.getSelectedRow();
                if (n >= 0) {
                    AcceleratorKeyDialog.this.tableModel.setKeystroke(n, keyStroke);
                }
            }
        });
        CancelAction cancelAction = new CancelAction(this);
        double[][] dArrayArray = new double[][]{{6.0, this.textAccelerator.getPreferredSize().width, 6.0}, {6.0, -2.0, -2.0, 6.0, -2.0, 6.0, -2.0, 6.0, -2.0, 6.0, -1.0}};
        JPanel jPanel2 = new JPanel(new TableLayout(dArrayArray));
        Utils.addWithLabel(jPanel2, (Component)this.textAccelerator, Utils._("Accelerator key") + ':', "1,2");
        JLabel jLabel = new JLabel("<html>" + Utils._("Click on the text field above and press the key (combination) to be used as the selected action's keyboard shortcut.") + "</html>");
        jPanel2.add((Component)jLabel, "1,4");
        jPanel2.add((Component)new JButton(this.actClearAccelerator), "1,6");
        jPanel2.add((Component)new JButton(this.actUseDefault), "1,8");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(new JButton(this.actOK));
        jPanel3.add(new JButton(this.actReset));
        jPanel3.add(cancelAction.createCancelButton());
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        jPanel.add((Component)jPanel2, "East");
        jPanel.add((Component)jPanel3, "South");
        this.setContentPane(jPanel);
        this.pack();
        Utils.setDefWinPos(this);
        this.updateSelection();
    }

    void updateSelection() {
        int n = this.table.getSelectedRow();
        boolean bl = n >= 0;
        this.actUseDefault.setEnabled(bl);
        this.actClearAccelerator.setEnabled(bl);
        this.textAccelerator.setEnabled(bl);
        if (bl) {
            this.textAccelerator.setKeyStroke(this.tableModel.getKeystroke(n));
        } else {
            this.textAccelerator.setKeyStroke(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActionToKeyStrokeTableModel
    extends AbstractTableModel {
        private static final String[] cols = new String[]{Utils._("Action"), Utils._("Accelerator key")};
        protected Action[] actions;
        protected KeyStroke[] keyStrokes;

        @Override
        public int getRowCount() {
            return this.actions.length;
        }

        @Override
        public int getColumnCount() {
            return cols.length;
        }

        @Override
        public String getColumnName(int n) {
            return cols[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Action.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.actions[n];
                }
                case 1: {
                    return KeyStrokeTextField.keyStrokeToUserString(this.keyStrokes[n]);
                }
            }
            return null;
        }

        public void setKeystroke(int n, KeyStroke keyStroke) {
            this.keyStrokes[n] = keyStroke;
            this.fireTableCellUpdated(n, 1);
        }

        public KeyStroke getKeystroke(int n) {
            return this.keyStrokes[n];
        }

        public Action getAction(int n) {
            return this.actions[n];
        }

        public Object[] searchDuplicates() {
            for (int i = 0; i < this.keyStrokes.length - 1; ++i) {
                KeyStroke keyStroke = this.keyStrokes[i];
                if (keyStroke == null) continue;
                for (int j = i + 1; j < this.keyStrokes.length; ++j) {
                    KeyStroke keyStroke2 = this.keyStrokes[j];
                    if (keyStroke2 == null || !keyStroke.equals(keyStroke2)) continue;
                    return new Object[]{keyStroke, this.actions[i], this.actions[j]};
                }
            }
            return null;
        }

        public void commitChanges() {
            for (int i = 0; i < this.actions.length; ++i) {
                Action action = this.actions[i];
                KeyStroke keyStroke = this.keyStrokes[i];
                action.putValue("AcceleratorKey", keyStroke);
            }
        }

        public ActionToKeyStrokeTableModel(Collection<Action> collection) {
            this.actions = collection.toArray(new Action[collection.size()]);
            this.keyStrokes = new KeyStroke[this.actions.length];
            Arrays.sort(this.actions, ToolbarEditorDialog.actionComparator);
            for (int i = 0; i < this.actions.length; ++i) {
                this.keyStrokes[i] = (KeyStroke)this.actions[i].getValue("AcceleratorKey");
            }
        }
    }
}

