/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Toolkit;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleratorKeys {
    public static final Map<String, String> DEFAULT_MAINWIN_MAPPING = new TreeMap<String, String>();
    public static final Map<String, String> DEFAULT_PBWIN_MAPPING = new TreeMap<String, String>();

    public static void saveToMap(Map<String, String> map, Map<String, Action> map2) {
        map.clear();
        for (Action action : map2.values()) {
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            if (keyStroke == null) continue;
            map.put((String)action.getValue("ActionCommandKey"), keyStroke.toString());
        }
    }

    public static void loadFromMap(Map<String, String> map, Map<String, Action> map2) {
        for (Action action : map2.values()) {
            String string = map.get(action.getValue("ActionCommandKey"));
            if (string == null) {
                action.putValue("AcceleratorKey", null);
                continue;
            }
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string));
        }
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((n & 1) != 0) {
            stringBuilder.append("shift ");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("ctrl ");
        }
        if ((n & 4) != 0) {
            stringBuilder.append("meta ");
        }
        if ((n & 8) != 0) {
            stringBuilder.append("alt ");
        }
        String string = stringBuilder.toString();
        DEFAULT_MAINWIN_MAPPING.put("AdminMode", "shift pressed F12");
        DEFAULT_MAINWIN_MAPPING.put("AnswerCall", "pressed F11");
        DEFAULT_MAINWIN_MAPPING.put("ClipCopy", string + "pressed C");
        DEFAULT_MAINWIN_MAPPING.put("Delete", "pressed DELETE");
        DEFAULT_MAINWIN_MAPPING.put("Exit", string + "pressed Q");
        DEFAULT_MAINWIN_MAPPING.put("FaxRead", string + "pressed R");
        DEFAULT_MAINWIN_MAPPING.put("FaxSave", string + "pressed S");
        DEFAULT_MAINWIN_MAPPING.put("Forward", "pressed F4");
        DEFAULT_MAINWIN_MAPPING.put("Phonebook", "pressed F9");
        DEFAULT_MAINWIN_MAPPING.put("Poll", "pressed F3");
        DEFAULT_MAINWIN_MAPPING.put("PrintTable", string + "pressed P");
        DEFAULT_MAINWIN_MAPPING.put("Readme", "pressed F1");
        DEFAULT_MAINWIN_MAPPING.put("Reconnect", "pressed F12");
        DEFAULT_MAINWIN_MAPPING.put("Refresh", "pressed F5");
        DEFAULT_MAINWIN_MAPPING.put("Resend", "shift pressed F4");
        DEFAULT_MAINWIN_MAPPING.put("Resume", "pressed F6");
        DEFAULT_MAINWIN_MAPPING.put("SaveAsPDF", "shift " + string + "pressed S");
        DEFAULT_MAINWIN_MAPPING.put("SearchFax", string + "pressed F");
        DEFAULT_MAINWIN_MAPPING.put("Send", "pressed F2");
        DEFAULT_MAINWIN_MAPPING.put("Suspend", "pressed F7");
        DEFAULT_MAINWIN_MAPPING.put("ViewLog", string + "pressed L");
        DEFAULT_MAINWIN_MAPPING.put("view_custom", string + "shift pressed F");
        DEFAULT_MAINWIN_MAPPING.put("view_all", string + "pressed A");
        DEFAULT_PBWIN_MAPPING.put("Print", string + "pressed P");
        DEFAULT_PBWIN_MAPPING.put("Close", "alt pressed F4");
        DEFAULT_PBWIN_MAPPING.put("SearchEntry", string + "pressed F");
        DEFAULT_PBWIN_MAPPING.put("RemoveEntry", string + "pressed DELETE");
        DEFAULT_PBWIN_MAPPING.put("AddEntry", string + "pressed N");
        DEFAULT_PBWIN_MAPPING.put("AddDistList", string + "shift pressed N");
        DEFAULT_PBWIN_MAPPING.put("FilterEntries", string + "shift pressed F");
        DEFAULT_PBWIN_MAPPING.put("ShowAllEntries", string + "pressed A");
    }
}

