/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.io.IOException;
import java.io.Reader;

public class ArrayCharSequence
implements CharSequence {
    protected final char[] wrapped;
    protected final int offset;
    protected final int length;

    public int length() {
        return this.length;
    }

    public char charAt(int n) {
        if (n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.wrapped[this.offset + n];
    }

    public CharSequence subSequence(int n, int n2) {
        return new ArrayCharSequence(this.wrapped, n, n2 - n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof CharSequence)) {
            return false;
        }
        CharSequence charSequence = (CharSequence)object;
        if (charSequence.length() != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.charAt(i) == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            n = 31 * n + this.wrapped[i];
        }
        return n;
    }

    public String toString() {
        return new String(this.wrapped, this.offset, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public char[] getArray() {
        return this.wrapped;
    }

    public static ArrayCharSequence readCompletely(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4000];
        int n2 = 0;
        while ((n = reader.read(cArray, n2, cArray.length - n2)) >= 0) {
            if ((n2 += n) < cArray.length) continue;
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray = cArray2;
        }
        return new ArrayCharSequence(cArray, 0, n2);
    }

    public ArrayCharSequence(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public ArrayCharSequence(char[] cArray, int n, int n2) {
        this.wrapped = cArray;
        this.offset = n;
        this.length = n2;
    }
}

