/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BOMInputStream
extends FilterInputStream {
    protected byte[] buf = new byte[16];
    protected int bufpos = 0;
    protected int buflen = 0;
    protected String detectedCharset = null;

    public BOMInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.detectBOM();
    }

    protected void detectBOM() throws IOException {
        this.buflen = this.in.read(this.buf);
        if (this.buf[0] == -17 && this.buf[1] == -69 && this.buf[2] == -65) {
            this.detectedCharset = "UTF-8";
            this.bufpos = 3;
        } else if (this.buf[0] == -2 && this.buf[1] == -1) {
            this.detectedCharset = "UTF-16BE";
            this.bufpos = 2;
        } else if (this.buf[0] == -1 && this.buf[1] == -2) {
            this.detectedCharset = "UTF-16LE";
            this.bufpos = 2;
        } else {
            this.detectedCharset = null;
            this.bufpos = 0;
        }
    }

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    public int read() throws IOException {
        if (this.bufpos >= this.buflen) {
            return this.in.read();
        }
        return this.buf[this.bufpos++];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buflen - this.bufpos;
        if (n3 <= 0) {
            return this.in.read(byArray, n, n2);
        }
        int n4 = Math.min(n3, n2);
        System.arraycopy(this.buf, this.bufpos, byArray, n, n4);
        this.bufpos += n4;
        if (n4 < n2) {
            int n5 = this.in.read(byArray, n + n4, n2 - n4);
            if (n5 <= 0) {
                return n4;
            }
            return n4 + n5;
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        int n = this.buflen - this.bufpos;
        if (n <= 0) {
            return this.in.skip(l);
        }
        long l2 = l - (long)n;
        this.bufpos += (int)l;
        if (l2 >= 0L) {
            return this.in.skip(l2) + (long)n;
        }
        return l;
    }
}

