/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import yajhfc.Utils;

public class KeyStrokeTextField
extends JTextField {
    protected KeyStroke keyStroke;

    public KeyStrokeTextField() {
        super(20);
        this.setKeymap(new AcceleratorKeymap());
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
        this.setText(KeyStrokeTextField.keyStrokeToUserString(keyStroke));
    }

    public void addKeyStrokeTextFieldListener(KeyStrokeTextFieldListener keyStrokeTextFieldListener) {
        this.listenerList.add(KeyStrokeTextFieldListener.class, keyStrokeTextFieldListener);
    }

    public void removeKeyStrokeTextFieldListener(KeyStrokeTextFieldListener keyStrokeTextFieldListener) {
        this.listenerList.remove(KeyStrokeTextFieldListener.class, keyStrokeTextFieldListener);
    }

    protected void fireUserTypedShortCut(KeyStroke keyStroke) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KeyStrokeTextFieldListener.class) continue;
            ((KeyStrokeTextFieldListener)objectArray[i + 1]).userTypedShortcut(keyStroke);
        }
    }

    public static String keyStrokeToUserString(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return Utils._("<none>");
        }
        if (keyStroke.getModifiers() != 0) {
            return KeyEvent.getModifiersExText(keyStroke.getModifiers()) + '-' + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public static interface KeyStrokeTextFieldListener
    extends EventListener {
        public void userTypedShortcut(KeyStroke var1);
    }

    class AcceleratorKeymap
    extends AbstractAction
    implements Keymap {
        private Keymap resolveParent;
        private KeyStroke lastKeystroke;

        AcceleratorKeymap() {
        }

        public String getName() {
            return "Accelerator key map";
        }

        public Action getDefaultAction() {
            return this;
        }

        public void setDefaultAction(Action action) {
        }

        public Action getAction(KeyStroke keyStroke) {
            this.lastKeystroke = keyStroke;
            return this;
        }

        public KeyStroke[] getBoundKeyStrokes() {
            return new KeyStroke[0];
        }

        public Action[] getBoundActions() {
            return new Action[0];
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            return new KeyStroke[0];
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return true;
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        }

        public void removeBindings() {
        }

        public Keymap getResolveParent() {
            return this.resolveParent;
        }

        public void setResolveParent(Keymap keymap) {
            this.resolveParent = keymap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.lastKeystroke.getKeyEventType() == 401) {
                switch (this.lastKeystroke.getKeyCode()) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 157: 
                    case 65406: {
                        break;
                    }
                    default: {
                        KeyStrokeTextField.this.setKeyStroke(this.lastKeystroke);
                        KeyStrokeTextField.this.fireUserTypedShortCut(this.lastKeystroke);
                    }
                }
            }
        }
    }
}

