/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;

public class MsgBundle {
    private static final Logger log = Logger.getLogger(MsgBundle.class.getName());
    protected final String resourceBundleName;
    protected final ClassLoader classLoader;
    protected ResourceBundle msgs = null;
    protected boolean triedMsgLoad = false;

    public String _(String string) {
        return this._(string, string);
    }

    public String _(String string, String string2) {
        ResourceBundle resourceBundle = this.getMessagesResourceBundle();
        if (resourceBundle == null) {
            return string2;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public ResourceBundle getMessagesResourceBundle() {
        if (!this.triedMsgLoad) {
            this.triedMsgLoad = true;
            Locale locale = this.getLocale();
            if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
                if (Utils.debugMode) {
                    log.fine("Not loading messages for language " + locale);
                }
                this.msgs = null;
            } else {
                try {
                    if (Utils.debugMode) {
                        log.fine("Trying to load messages for language " + locale);
                    }
                    this.msgs = ResourceBundle.getBundle(this.resourceBundleName, locale, this.getClassLoader());
                }
                catch (Exception exception) {
                    log.log(Level.INFO, "Error loading messages for " + locale, exception);
                    this.msgs = null;
                }
            }
        }
        return this.msgs;
    }

    public Locale getLocale() {
        return Utils.getLocale();
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MsgBundle(String string, ClassLoader classLoader) {
        this.resourceBundleName = string;
        this.classLoader = classLoader;
    }
}

