/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.Window;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import yajhfc.Utils;
import yajhfc.ui.YajOptionPane;
import yajhfc.ui.swing.SwingYajOptionPane;

public abstract class ProgressWorker
extends Thread {
    static final Logger log = Logger.getLogger(ProgressWorker.class.getName());
    protected ProgressUI progressMonitor;
    protected int progress;
    protected YajOptionPane dialogs;
    protected boolean closeOnExit = true;
    protected boolean working = false;

    public abstract void doWork();

    protected void initialize() {
    }

    protected void done() {
    }

    protected void pMonClosed() {
    }

    protected int calculateMaxProgress() {
        return 100;
    }

    public void updateNote(String string) {
        SwingUtilities.invokeLater(new NoteUpdater(string, this.progressMonitor));
    }

    public void stepProgressBar(int n) {
        this.progress += n;
        SwingUtilities.invokeLater(new ProgressUpdater(this.progress, this.progressMonitor));
    }

    public void setProgress(int n) {
        if (this.progress != n || this.progressMonitor.isShowingIndeterminate()) {
            this.progress = n;
            SwingUtilities.invokeLater(new ProgressUpdater(n, this.progressMonitor));
        }
    }

    public ProgressUI getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressUI progressUI) {
        if (this.isAlive()) {
            throw new IllegalStateException("Can not set progress monitor after thread has been started.");
        }
        this.progressMonitor = progressUI;
    }

    public boolean isCloseOnExit() {
        return this.closeOnExit;
    }

    public void setCloseOnExit(boolean bl) {
        this.closeOnExit = bl;
    }

    public void showExceptionDialog(String string, Exception exception) {
        this.dialogs.showExceptionDialog(string, exception);
    }

    public void showMessageDialog(String string, String string2, int n) {
        this.dialogs.showMessageDialog(string, string2, n);
    }

    public int showConfirmDialog(String string, String string2, int n, int n2) {
        return this.dialogs.showConfirmDialog(string, string2, n, n2);
    }

    public void startWork(Window window, String string) {
        this.startWork(new SwingYajOptionPane(window), string);
    }

    public void startWork(YajOptionPane yajOptionPane, String string) {
        try {
            this.startWorkPriv(yajOptionPane, string);
        }
        catch (Exception exception) {
            yajOptionPane.showExceptionDialog(Utils._("Error performing the operation:"), exception);
            this.working = false;
        }
    }

    private void startWorkPriv(YajOptionPane yajOptionPane, String string) {
        this.working = true;
        this.initialize();
        if (this.progressMonitor == null) {
            this.progressMonitor = yajOptionPane.createDefaultProgressMonitor(string, Utils._("Initializing..."), 0, this.calculateMaxProgress());
        } else if (this.progressMonitor.supportsIndeterminateProgress()) {
            this.progressMonitor.showIndeterminateProgress(string, Utils._("Initializing..."));
            this.progressMonitor.setMaximum(this.calculateMaxProgress());
        } else {
            this.progressMonitor.showDeterminateProgress(string, Utils._("Initializing..."), 0, this.calculateMaxProgress());
        }
        this.progress = 0;
        this.dialogs = yajOptionPane;
        this.start();
    }

    public final void run() {
        try {
            this.doWork();
            this.dialogs.invokeLater(new Runnable(){

                public void run() {
                    try {
                        try {
                            ProgressWorker.this.done();
                        }
                        catch (Exception exception) {
                            ProgressWorker.this.dialogs.showExceptionDialog(Utils._("Error performing the operation:"), exception);
                        }
                        if (ProgressWorker.this.dialogs.getParent() != null) {
                            ProgressWorker.this.dialogs.getParent().setEnabled(true);
                        }
                        if (ProgressWorker.this.closeOnExit) {
                            ProgressWorker.this.progressMonitor.close();
                            try {
                                ProgressWorker.this.pMonClosed();
                            }
                            catch (Exception exception) {
                                ProgressWorker.this.dialogs.showExceptionDialog(Utils._("Error performing the operation:"), exception);
                            }
                        }
                    }
                    finally {
                        ProgressWorker.this.working = false;
                    }
                }
            });
        }
        catch (Exception exception) {
            try {
                this.dialogs.showExceptionDialog(Utils._("Error performing the operation:"), exception);
                this.dialogs.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                this.dialogs.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    public static interface ProgressUI {
        public void close();

        public void setNote(String var1);

        public void setProgress(int var1);

        public void setMaximum(int var1);

        public boolean supportsIndeterminateProgress();

        public void showIndeterminateProgress(String var1, String var2);

        public boolean isShowingIndeterminate();

        public void showDeterminateProgress(String var1, String var2, int var3, int var4);
    }

    private static class NoteUpdater
    implements Runnable {
        private String note;
        private ProgressUI pMon;

        public void run() {
            if (this.pMon != null) {
                this.pMon.setNote(this.note);
            }
        }

        public NoteUpdater(String string, ProgressUI progressUI) {
            this.note = string;
            this.pMon = progressUI;
            if (Utils.debugMode) {
                log.fine("ProgressWorker setNote: " + string);
            }
        }
    }

    private static class ProgressUpdater
    implements Runnable {
        private int progress;
        private ProgressUI pMon;

        public void run() {
            if (this.pMon != null) {
                this.pMon.setProgress(this.progress);
            }
        }

        public ProgressUpdater(int n, ProgressUI progressUI) {
            this.progress = n;
            this.pMon = progressUI;
        }
    }
}

