/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.table.AbstractTableModel;
import yajhfc.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTableModel<T>
extends AbstractTableModel {
    protected T[] items;
    protected boolean[] selected;

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.items.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.selected[n];
            }
            case 1: {
                return this.items[n];
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                this.selected[n] = (Boolean)object;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not editable");
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return this.getItemClass();
            }
        }
        return null;
    }

    public void setItems(T[] TArray) {
        this.items = TArray;
        this.selected = new boolean[TArray.length];
        this.fireTableDataChanged();
    }

    public int countNumberOfSelectedItems() {
        int n = 0;
        for (boolean bl : this.selected) {
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public int[] getSelectedIndices() {
        int[] nArray = new int[this.countNumberOfSelectedItems()];
        int n = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public T[] getSelectedObjects() {
        T[] TArray = this.newArray(this.countNumberOfSelectedItems());
        int n = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            TArray[n++] = this.items[i];
        }
        return TArray;
    }

    public void setSelectedIndices(int[] nArray) {
        Arrays.fill(this.selected, false);
        for (int n : nArray) {
            this.selected[n] = true;
        }
        this.fireTableDataChanged();
    }

    public void setSelectedObjects(Collection<T> collection) {
        Arrays.fill(this.selected, false);
        for (T t : collection) {
            int n = Utils.indexOfArray(this.items, t);
            if (n < 0) continue;
            this.selected[n] = true;
        }
        this.fireTableDataChanged();
    }

    public void selectAll() {
        this.selectAll(true);
    }

    public void deselectAll() {
        this.selectAll(false);
    }

    public void selectAll(boolean bl) {
        Arrays.fill(this.selected, bl);
        this.fireTableDataChanged();
    }

    public boolean getSelectedState(int n) {
        return this.selected[n];
    }

    public void setSelectedState(int n, boolean bl) {
        this.selected[n] = bl;
        this.fireTableCellUpdated(n, 0);
    }

    private T[] newArray(int n) {
        return (Object[])Array.newInstance(this.getItemClass(), n);
    }

    private Class<T> getItemClass() {
        return this.items.getClass().getComponentType();
    }

    public SelectionTableModel(T[] TArray) {
        this.setItems(TArray);
    }
}

