/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedListModel<T>
extends AbstractListModel {
    protected List<T> list;
    protected Comparator<T> comparator;

    public SortedListModel(List<T> list, Comparator<T> comparator) {
        this.list = list;
        this.comparator = comparator;
        this.sort();
    }

    public void sort() {
        Collections.sort(this.list, this.comparator);
    }

    @Override
    public Object getElementAt(int n) {
        return this.list.get(n);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public void add(T t) {
        int n = Collections.binarySearch(this.list, t, this.comparator);
        if (n < 0) {
            n = -(n + 1);
        }
        this.list.add(n, t);
        this.fireIntervalAdded(this, n, n);
    }

    public void remove(int n) {
        this.list.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public void clear() {
        int n = this.list.size() - 1;
        this.list.clear();
        this.fireIntervalRemoved(this, 0, n);
    }

    public void addAll(Collection<? extends T> collection) {
        for (T t : collection) {
            this.add(t);
        }
    }

    public void removeAll(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.remove(nArray[i]);
        }
    }

    public T get(int n) {
        return this.list.get(n);
    }
}

