/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import yajhfc.Utils;
import yajhfc.util.ListListModel;
import yajhfc.util.SortedListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class fmtEditor<T>
extends JPanel
implements ActionListener {
    private final ListListModel<T> selectedFmtModel;
    private final SortedListModel<T> deselectedFmtModel;
    private final Collection<T> dontDeleteFmts;
    private final Collection<T> availableFmts;
    private final ListCellRenderer listRenderer;
    private final Comparator<T> listComparator;
    final T separator;
    JPanel buttonPane;
    JPanel availPane;
    JPanel selectedPane;
    JButton buttonAdd;
    JButton buttonDelete;
    JButton buttonUp;
    JButton buttonDown;
    JList listAvail;
    JList listSelected;
    JScrollPane scrollAvail;
    JScrollPane scrollSelected;

    boolean canDelete(Object[] objectArray) {
        if (objectArray.length == 0 || this.selectedFmtModel.getSize() <= 1) {
            return false;
        }
        if (this.dontDeleteFmts == null) {
            return true;
        }
        for (Object object : objectArray) {
            if (!this.dontDeleteFmts.contains(object)) continue;
            return false;
        }
        return true;
    }

    private void initialize(String string, String string2) {
        this.setLayout(new BoxLayout(this, 0));
        Dimension dimension = new Dimension(5, 5);
        this.add(this.getAvailPane(string2));
        this.add(Box.createRigidArea(dimension));
        this.add(this.getButtonPane());
        this.add(Box.createRigidArea(dimension));
        this.add(this.getSelectedPane(string));
        if (this.deselectedFmtModel.getSize() > 0) {
            this.listAvail.setSelectedIndex(0);
        }
        if (this.selectedFmtModel.getSize() > 0) {
            this.listSelected.setSelectedIndex(0);
        }
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 1));
            this.buttonPane.add(Box.createVerticalGlue());
            this.buttonUp = new JButton();
            this.initMoveButton(this.buttonUp, "Up", Utils._("Up"));
            this.buttonUp.setToolTipText(Utils._("Moves the selected item up"));
            this.buttonPane.add(this.buttonUp);
            this.buttonPane.add(Box.createVerticalStrut(10));
            this.buttonAdd = new JButton();
            this.initMoveButton(this.buttonAdd, "Forward", ">>");
            this.buttonAdd.setToolTipText(Utils._("Adds the selected item"));
            this.buttonPane.add(this.buttonAdd);
            this.buttonPane.add(Box.createVerticalStrut(10));
            this.buttonDelete = new JButton();
            this.initMoveButton(this.buttonDelete, "Back", "<<");
            this.buttonDelete.setToolTipText(Utils._("Removes the selected item"));
            this.buttonPane.add(this.buttonDelete);
            this.buttonPane.add(Box.createVerticalStrut(10));
            this.buttonDown = new JButton();
            this.initMoveButton(this.buttonDown, "Down", Utils._("Down"));
            this.buttonDown.setToolTipText(Utils._("Moves the selected item down"));
            this.buttonPane.add(this.buttonDown);
            this.buttonPane.add(Box.createVerticalGlue());
        }
        return this.buttonPane;
    }

    private JPanel getAvailPane(String string) {
        if (this.availPane == null) {
            this.availPane = new JPanel(new BorderLayout());
            this.availPane.add((Component)new JLabel(string), "North");
            this.listAvail = new JList<T>(this.deselectedFmtModel);
            this.listAvail.setSelectionMode(2);
            this.listAvail.setCellRenderer(this.listRenderer);
            this.listAvail.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        fmtEditor.this.buttonAdd.setEnabled(fmtEditor.this.listAvail.getSelectedIndex() >= 0);
                    }
                }
            });
            this.listAvail.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = fmtEditor.this.listAvail.locationToIndex(mouseEvent.getPoint())) >= 0) {
                        fmtEditor.this.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), "Forward"));
                    }
                }
            });
            this.scrollAvail = new JScrollPane(this.listAvail);
            this.scrollAvail.setPreferredSize(new Dimension(100, 100));
            this.availPane.add((Component)this.scrollAvail, "Center");
        }
        return this.availPane;
    }

    private JPanel getSelectedPane(String string) {
        if (this.selectedPane == null) {
            this.selectedPane = new JPanel(new BorderLayout());
            this.selectedPane.add((Component)new JLabel(string), "North");
            this.listSelected = new JList<T>(this.selectedFmtModel);
            this.listSelected.setSelectionMode(2);
            this.listSelected.setCellRenderer(this.listRenderer);
            this.listSelected.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        int n = fmtEditor.this.listSelected.getMinSelectionIndex();
                        int n2 = fmtEditor.this.listSelected.getMaxSelectionIndex();
                        fmtEditor.this.buttonUp.setEnabled(n > 0);
                        fmtEditor.this.buttonDown.setEnabled(n >= 0 && n2 < fmtEditor.this.listSelected.getModel().getSize() - 1);
                        fmtEditor.this.buttonDelete.setEnabled(n >= 0 && fmtEditor.this.canDelete(fmtEditor.this.listSelected.getSelectedValues()));
                    }
                }
            });
            this.listSelected.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = fmtEditor.this.listSelected.locationToIndex(mouseEvent.getPoint())) >= 0) {
                        fmtEditor.this.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), "Back"));
                    }
                }
            });
            this.scrollSelected = new JScrollPane(this.listSelected);
            this.scrollSelected.setPreferredSize(new Dimension(100, 100));
            this.selectedPane.add((Component)this.scrollSelected, "Center");
        }
        return this.selectedPane;
    }

    private void initMoveButton(JButton jButton, String string, String string2) {
        ImageIcon imageIcon = Utils.loadIcon("navigation/" + string);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        } else {
            jButton.setText(string2);
        }
        jButton.setActionCommand(string);
        jButton.setAlignmentX(0.5f);
        jButton.setMaximumSize(new Dimension(200, 100));
        jButton.addActionListener(this);
        jButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Forward")) {
            int[] nArray = this.listAvail.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n = nArray[i];
                T t = this.deselectedFmtModel.get(n);
                this.selectedFmtModel.add(t);
                if (t == this.separator) continue;
                this.deselectedFmtModel.remove(n);
            }
        } else {
            int[] nArray = this.listSelected.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            if (string.equals("Back")) {
                Object[] objectArray = this.listSelected.getSelectedValues();
                if (this.canDelete(objectArray)) {
                    for (Object object : objectArray) {
                        if (object == this.separator) continue;
                        this.deselectedFmtModel.add(object);
                    }
                    this.selectedFmtModel.removeAll(nArray);
                }
            } else if (string.equals("Up")) {
                this.selectedFmtModel.moveUp(nArray);
                int n = 0;
                while (n < nArray.length) {
                    int n2 = n++;
                    nArray[n2] = nArray[n2] - 1;
                }
                this.listSelected.setSelectedIndices(nArray);
            } else if (string.equals("Down")) {
                this.selectedFmtModel.moveDown(nArray);
                int n = 0;
                while (n < nArray.length) {
                    int n3 = n++;
                    nArray[n3] = nArray[n3] + 1;
                }
                this.listSelected.setSelectedIndices(nArray);
            }
        }
    }

    public void setNewSelection(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(this.availableFmts);
        arrayList.removeAll(collection);
        if (this.separator != null) {
            arrayList.add(this.separator);
        }
        this.deselectedFmtModel.clear();
        this.deselectedFmtModel.addAll(arrayList);
        this.selectedFmtModel.clear();
        this.selectedFmtModel.addAll(collection);
    }

    @Override
    public void setEnabled(boolean bl) {
        Utils.enableChildren(this, bl);
        super.setEnabled(bl);
    }

    public JList getSelectedList() {
        return this.listSelected;
    }

    public ListListModel<T> getSelectedListModel() {
        return this.selectedFmtModel;
    }

    public JList getDeselectedList() {
        return this.listAvail;
    }

    public SortedListModel<T> getDeselectedListModel() {
        return this.deselectedFmtModel;
    }

    public fmtEditor(T[] TArray, List<T> list, Collection<T> collection, ListCellRenderer listCellRenderer, Comparator<T> comparator, T t, String string, String string2) {
        this(Arrays.asList(TArray), list, collection, listCellRenderer, comparator, t, string, string2);
    }

    public fmtEditor(Collection<T> collection, List<T> list, Collection<T> collection2, ListCellRenderer listCellRenderer, Comparator<T> comparator, T t, String string, String string2) {
        super(false);
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        if (list.size() > 0) {
            arrayList.removeAll(list);
        }
        if (t != null) {
            arrayList.add(t);
        }
        this.dontDeleteFmts = collection2;
        this.listRenderer = listCellRenderer;
        this.listComparator = comparator;
        this.separator = t;
        this.availableFmts = collection;
        this.deselectedFmtModel = new SortedListModel<T>(arrayList, this.listComparator);
        this.selectedFmtModel = new ListListModel<T>(list);
        this.initialize(string, string2);
    }
}

