/*
 * Decompiled with CFR 0.152.
 */
package yajhfc.virtualcolumnstore;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import yajhfc.Utils;
import yajhfc.model.VirtualColumnType;
import yajhfc.util.TransactFileOutputStream;
import yajhfc.virtualcolumnstore.AvailablePersistenceMethod;
import yajhfc.virtualcolumnstore.CachingVirtColPersister;
import yajhfc.virtualcolumnstore.VirtColChangeListener;
import yajhfc.virtualcolumnstore.VirtColPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVirtColPersister
extends CachingVirtColPersister
implements Runnable {
    static final Logger log = Logger.getLogger(LocalVirtColPersister.class.getName());
    protected static final String KEY_COLUMN_NAME = "KEY";
    protected static final String FILE_CHARSET = "UTF-8";
    protected static final int SAVE_INTERVAL = 5;
    protected File saveFile;
    protected File oldFormatFile;
    protected ScheduledFuture<?> sft;

    @Override
    public void shutdown() {
        if (this.sft != null) {
            this.sft.cancel(false);
            this.sft = null;
        }
        this.persistValues();
    }

    @Override
    public void run() {
        this.persistValues();
    }

    @Override
    public synchronized void persistValues() {
        try {
            if (this.dirty) {
                this.saveValues(this.saveFile);
            }
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Error saving values", iOException);
        }
    }

    @Override
    public void addVirtColChangeListener(VirtColChangeListener virtColChangeListener) {
    }

    @Override
    public void removeVirtColChangeListener(VirtColChangeListener virtColChangeListener) {
    }

    @Override
    public synchronized void cleanupState(Collection<String> collection) {
        this.checkInitialized();
        this.data.keySet().retainAll(collection);
    }

    @Override
    protected void checkInitialized() {
        if (this.data != null) {
            return;
        }
        this.data = new TreeMap();
        if (this.saveFile.canRead()) {
            try {
                this.loadValues(this.saveFile);
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error loading values", iOException);
            }
        } else if (this.oldFormatFile.canRead()) {
            try {
                this.loadValuesFromOldFormatFile(this.oldFormatFile);
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "Error loading values", iOException);
            }
        } else {
            log.info("No saved values found");
        }
        this.sft = Utils.executorService.scheduleWithFixedDelay(this, 5L, 5L, TimeUnit.SECONDS);
    }

    protected static String booleanToString(boolean bl) {
        return bl ? "Y" : "N";
    }

    protected static boolean stringToBoolean(String string) {
        if ("Y".equalsIgnoreCase(string)) {
            return true;
        }
        if ("N".equalsIgnoreCase(string)) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    protected synchronized void loadValuesFromOldFormatFile(File file) throws IOException {
        log.fine("Reading values from old format file " + file);
        this.data.clear();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("#") || string.length() <= 0) continue;
            this.setValue(string, VirtualColumnType.READ, (Object)Boolean.TRUE);
        }
        bufferedReader.close();
        this.dirty = false;
    }

    protected synchronized void loadValues(File file) throws IOException {
        Object object;
        int n;
        log.fine("Reading values from " + file);
        this.data.clear();
        CSVReader cSVReader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(file), FILE_CHARSET));
        Object[] objectArray = cSVReader.readNext();
        if (objectArray == null) {
            throw new IOException("File has no header line!");
        }
        if (Utils.debugMode) {
            log.fine("First line is: " + Arrays.toString(objectArray));
        }
        if (!KEY_COLUMN_NAME.equals(objectArray[0])) {
            throw new IOException("Invalid file format: First column must be KEY");
        }
        VirtualColumnType[] virtualColumnTypeArray = new VirtualColumnType[objectArray.length - 1];
        for (n = 1; n < objectArray.length; ++n) {
            try {
                object = Enum.valueOf(VirtualColumnType.class, (String)objectArray[n]);
            }
            catch (Exception exception) {
                object = null;
                log.log(Level.WARNING, "File " + file + " has unknown column named " + (String)objectArray[n], exception);
            }
            virtualColumnTypeArray[n - 1] = object;
        }
        if (Utils.debugMode) {
            log.fine("map is: " + Arrays.toString((Object[])virtualColumnTypeArray));
        }
        while ((objectArray = cSVReader.readNext()) != null) {
            n = Math.min(objectArray.length - 1, virtualColumnTypeArray.length);
            if (n <= 0) continue;
            object = objectArray[0];
            Object[] objectArray2 = this.allocateKeyData();
            for (int i = 0; i < n; ++i) {
                Object object2;
                Object object3 = objectArray[i + 1];
                VirtualColumnType virtualColumnType = virtualColumnTypeArray[i];
                Class<?> clazz = virtualColumnType.getDataType();
                if (clazz == String.class) {
                    object2 = object3;
                } else if (object3 == null || ((String)object3).length() == 0) {
                    object2 = null;
                } else if (clazz == Boolean.class) {
                    object2 = LocalVirtColPersister.stringToBoolean((String)object3);
                } else if (clazz == Integer.class) {
                    object2 = Integer.valueOf((String)object3);
                } else if (clazz == Long.class) {
                    object2 = Long.valueOf((String)object3);
                } else {
                    log.warning("Unsupported data type: " + clazz);
                    object2 = object3;
                }
                objectArray2[this.columnToIndex((VirtualColumnType)virtualColumnType)] = object2;
            }
            if (Utils.debugMode) {
                log.finest("line " + Arrays.toString(objectArray) + " parsed to: key=" + (String)object + "; keyData=" + Arrays.toString(objectArray2));
            }
            this.data.put(object, objectArray2);
        }
        cSVReader.close();
        this.dirty = false;
    }

    protected synchronized void saveValues(File file) throws IOException {
        log.fine("Saving values to " + file);
        CSVWriter cSVWriter = new CSVWriter(new OutputStreamWriter((OutputStream)new TransactFileOutputStream(file), FILE_CHARSET));
        String[] stringArray = new String[this.columnMap.size() + 1];
        VirtualColumnType[] virtualColumnTypeArray = this.getReverseMap();
        stringArray[0] = KEY_COLUMN_NAME;
        for (int i = 0; i < virtualColumnTypeArray.length; ++i) {
            stringArray[i + 1] = virtualColumnTypeArray[i].name();
        }
        cSVWriter.writeNext(stringArray);
        for (Map.Entry entry : this.data.entrySet()) {
            Object[] objectArray = (Object[])entry.getValue();
            stringArray[0] = (String)entry.getKey();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string = object != null ? (object instanceof Boolean ? LocalVirtColPersister.booleanToString((Boolean)object) : object.toString()) : "";
                stringArray[i + 1] = string;
            }
            cSVWriter.writeNext(stringArray);
        }
        cSVWriter.close();
        this.dirty = false;
    }

    public LocalVirtColPersister(File file) {
        this(file, null);
    }

    public LocalVirtColPersister(File file, File file2) {
        this.saveFile = file;
        this.oldFormatFile = file2;
    }

    static class PersistenceMethod
    implements AvailablePersistenceMethod {
        PersistenceMethod() {
        }

        public boolean canConfigure() {
            return false;
        }

        public VirtColPersister createInstance(String string, int n) {
            File file = new File(Utils.getConfigDir(), "recvread-" + n + ".csv");
            TransactFileOutputStream.checkRecovery(file);
            File file2 = new File(Utils.getConfigDir(), "recvread-" + n);
            TransactFileOutputStream.checkRecovery(file2);
            File file3 = new File(Utils.getConfigDir(), "recvread");
            if (file3.exists()) {
                file3.renameTo(file2);
            }
            return new LocalVirtColPersister(file, file2);
        }

        public String getDescription() {
            return Utils._("Local file");
        }

        public String getKey() {
            return "local";
        }

        public String toString() {
            return this.getDescription();
        }

        public String showConfigDialog(Window window, String string) {
            return null;
        }
    }
}

